/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;

public class SVSReader
extends BaseTiffReader {
    private float[] pixelSize;

    public SVSReader() {
        super("Aperio SVS", new String[]{"svs"});
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.getSeriesCount() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        TiffTools.getSamples(this.ifds[this.series], this.in, buf, x, y, w, h);
        return buf;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.core = new CoreMetadata[this.ifds.length];
        this.pixelSize = new float[this.ifds.length];
        for (int i = 0; i < this.ifds.length; ++i) {
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            String comment = TiffTools.getComment(this.ifds[i]);
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                StringTokenizer tokens = new StringTokenizer(st.nextToken(), "|");
                while (tokens.hasMoreTokens()) {
                    String t = tokens.nextToken();
                    if (t.indexOf("=") == -1) {
                        this.addGlobalMeta("Comment", t);
                        continue;
                    }
                    String key = t.substring(0, t.indexOf("=")).trim();
                    String value = t.substring(t.indexOf("=") + 1).trim();
                    this.addSeriesMeta(key, value);
                    if (!key.equals("MPP")) continue;
                    this.pixelSize[i] = Float.parseFloat(value);
                }
            }
        }
        this.setSeries(0);
        for (int s = 0; s < this.ifds.length; ++s) {
            int p = TiffTools.getPhotometricInterpretation(this.ifds[s]);
            int samples = TiffTools.getSamplesPerPixel(this.ifds[s]);
            this.core[s].rgb = samples > 1 || p == 2;
            this.core[s].sizeX = (int)TiffTools.getImageWidth(this.ifds[s]);
            this.core[s].sizeY = (int)TiffTools.getImageLength(this.ifds[s]);
            this.core[s].sizeZ = 1;
            this.core[s].sizeT = 1;
            this.core[s].sizeC = this.core[s].rgb ? samples : 1;
            this.core[s].littleEndian = TiffTools.isLittleEndian(this.ifds[s]);
            this.core[s].indexed = p == 3 && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            this.core[s].imageCount = 1;
            this.core[s].pixelType = TiffTools.getPixelType(this.ifds[s]);
            this.core[s].metadataComplete = true;
            this.core[s].interleaved = false;
            this.core[s].falseColor = false;
            this.core[s].dimensionOrder = "XYCZT";
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }
}

