/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.SDTInfo;
import loci.formats.meta.FilterMetadata;

public class SDTReader
extends FormatReader {
    protected SDTInfo info;
    protected int off;
    protected int timeBins;
    protected int channels;
    protected boolean intensity = false;

    public SDTReader() {
        super("SPCImage Data", "sdt");
    }

    public void setIntensity(boolean intensity) {
        FormatTools.assertId(this.currentId, false, 1);
        this.intensity = intensity;
    }

    public boolean isIntensity() {
        return this.intensity;
    }

    public int getTimeBinCount() {
        return this.timeBins;
    }

    public int getChannelCount() {
        return this.channels;
    }

    public SDTInfo getInfo() {
        return this.info;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public int[] getChannelDimLengths() {
        int[] nArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.intensity) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.channels;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = this.timeBins;
            nArray = nArray3;
            nArray3[1] = this.channels;
        }
        return nArray;
    }

    public String[] getChannelDimTypes() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.intensity) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Spectra";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Lifetime";
            stringArray = stringArray3;
            stringArray3[1] = "Spectra";
        }
        return stringArray;
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return !this.intensity && subC == 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int sizeX = this.getSizeX();
        int sizeY = this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        boolean little = this.isLittleEndian();
        if (buf.length == sizeY * sizeX * bpp && this.timeBins > 1) {
            this.timeBins = 1;
        }
        int paddedWidth = sizeX + (4 - sizeX % 4) % 4;
        int planeSize = paddedWidth * sizeY * this.timeBins * bpp;
        boolean direct = !this.intensity;
        byte[] b = direct ? buf : new byte[sizeY * sizeX * this.timeBins * bpp];
        this.in.seek(this.off + no * planeSize + y * paddedWidth * bpp * this.timeBins);
        for (int row = 0; row < h; ++row) {
            this.in.skipBytes(x * bpp * this.timeBins);
            this.in.read(b, row * bpp * this.timeBins * w, w * this.timeBins * bpp);
            this.in.skipBytes(bpp * this.timeBins * (paddedWidth - x - w));
        }
        if (direct) {
            return buf;
        }
        int scan = this.intensity ? bpp : this.timeBins * bpp;
        for (int row = 0; row < h; ++row) {
            int yi = (y + row) * sizeX * this.timeBins * bpp;
            int ri = row * w * scan;
            for (int col = 0; col < w; ++col) {
                int xi = yi + (x + col) * this.timeBins * bpp;
                int ci = ri + col * scan;
                if (this.intensity) {
                    short sum = 0;
                    for (int t = 0; t < this.timeBins; ++t) {
                        sum = (short)(sum + DataTools.bytesToShort(b, xi + t * bpp, little));
                    }
                    DataTools.unpackShort(sum, buf, ci, little);
                    continue;
                }
                System.arraycopy(b, xi, buf, ci, scan);
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.channels = 0;
        this.timeBins = 0;
        this.off = 0;
        this.info = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("SDTReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.status("Reading header");
        this.info = new SDTInfo(this.in, this.metadata);
        this.off = this.info.dataBlockOffs + 22;
        this.timeBins = this.info.timeBins;
        this.channels = this.info.channels;
        this.addGlobalMeta("time bins", this.timeBins);
        this.addGlobalMeta("channels", this.channels);
        this.status("Populating metadata");
        this.core[0].sizeX = this.info.width;
        this.core[0].sizeY = this.info.height;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.intensity ? this.channels : this.timeBins * this.channels;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYZTC";
        this.core[0].pixelType = 3;
        this.core[0].rgb = !this.intensity;
        this.core[0].littleEndian = true;
        this.core[0].imageCount = this.channels;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

