/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.TiffTools;
import loci.formats.meta.FilterMetadata;

public class PCIReader
extends FormatReader {
    private Vector imageFiles;
    private POITools poi;
    private Vector timestamps;

    public PCIReader() {
        super("Compix Simple-PCI", "cxd");
        this.blockCheckLen = 4;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        RandomAccessInputStream s = this.poi.getDocumentStream((String)this.imageFiles.get(no));
        if (TiffTools.isValidHeader(s)) {
            Hashtable ifd = TiffTools.getFirstIFD(s);
            TiffTools.getSamples(ifd, s, buf);
        } else {
            s.seek(0L);
            int planeSize = FormatTools.getPlaneSize(this);
            s.skipBytes((int)(s.length() - (long)planeSize));
            this.readPlane(s, x, y, w, h, buf);
        }
        s.close();
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.imageFiles = null;
        this.timestamps = null;
        if (this.poi != null) {
            this.poi.close();
        }
        this.poi = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("PCIReader.initFile(" + id + ")");
        super.initFile(id);
        this.imageFiles = new Vector();
        this.timestamps = new Vector();
        this.poi = new POITools(Location.getMappedId(this.currentId));
        float scaleFactor = 1.0f;
        Vector allFiles = this.poi.getDocumentList();
        for (int i = 0; i < allFiles.size(); ++i) {
            double v;
            byte[] b;
            String name = (String)allFiles.get(i);
            String relativePath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (relativePath.equals("Field Count")) {
                b = this.poi.getDocumentBytes(name, 4);
                this.core[0].imageCount = DataTools.bytesToInt(b, 0, true);
                continue;
            }
            if (relativePath.equals("File Has Image")) {
                b = this.poi.getDocumentBytes(name, 2);
                if (DataTools.bytesToInt(b, 0, true) != 0) continue;
                throw new FormatException("This file does not contain image data.");
            }
            if (relativePath.equals("Comments")) {
                String comments = new String(this.poi.getDocumentBytes(name));
                StringTokenizer st = new StringTokenizer(comments.trim(), "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (token.indexOf("=") == -1) continue;
                    int idx = token.indexOf("=");
                    String key = token.substring(0, idx).trim();
                    String value = token.substring(idx + 1).trim();
                    this.addGlobalMeta(key, value);
                    if (!key.equals("factor")) continue;
                    if (value.indexOf(";") != -1) {
                        value = value.substring(0, value.indexOf(";"));
                    }
                    scaleFactor = Float.parseFloat(value.trim());
                }
                continue;
            }
            if (relativePath.startsWith("Bitmap") || relativePath.equals("Data")) {
                String parent = name.substring(0, name.lastIndexOf(File.separator));
                int space = parent.lastIndexOf(" ") + 1;
                if (space >= parent.length()) continue;
                int num = Integer.parseInt(parent.substring(space, parent.indexOf(File.separator, space))) - 1;
                if (num < this.imageFiles.size()) {
                    this.imageFiles.setElementAt(name, num);
                } else {
                    int diff = num - this.imageFiles.size();
                    for (int q = 0; q < diff; ++q) {
                        this.imageFiles.add("");
                    }
                    this.imageFiles.add(name);
                }
                if (this.getSizeX() == 0 || this.getSizeY() == 0) continue;
                int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
                int plane = this.getSizeX() * this.getSizeY() * bpp;
                this.core[0].sizeC = this.poi.getFileSize(name) / plane;
                if (this.getSizeC() != 0) continue;
                this.core[0].sizeX /= 16;
                this.core[0].sizeY /= 16;
                this.core[0].sizeC = this.poi.getFileSize(name) / plane;
                continue;
            }
            if (relativePath.indexOf("Image_Depth") != -1) {
                int bits;
                b = this.poi.getDocumentBytes(name, 8);
                for (bits = (int)Double.longBitsToDouble(DataTools.bytesToLong(b, 0, true)); bits % 8 != 0 || bits == 0; ++bits) {
                }
                switch (bits) {
                    case 8: {
                        this.core[0].pixelType = 1;
                        break;
                    }
                    case 16: {
                        this.core[0].pixelType = 3;
                        break;
                    }
                    case 32: {
                        this.core[0].pixelType = 5;
                        break;
                    }
                    case 48: {
                        this.core[0].pixelType = 3;
                        break;
                    }
                    default: {
                        throw new FormatException("Unsupported bits per pixel : " + bits);
                    }
                }
                continue;
            }
            if (relativePath.indexOf("Image_Height") != -1 && this.getSizeY() == 0) {
                b = this.poi.getDocumentBytes(name, 8);
                this.core[0].sizeY = (int)Double.longBitsToDouble(DataTools.bytesToLong(b, 0, true));
                continue;
            }
            if (relativePath.indexOf("Image_Width") != -1 && this.getSizeX() == 0) {
                b = this.poi.getDocumentBytes(name, 8);
                this.core[0].sizeX = (int)Double.longBitsToDouble(DataTools.bytesToLong(b, 0, true));
                continue;
            }
            if (relativePath.indexOf("Time_From_Start") == -1 || this.timestamps.contains(new Double(v = Double.longBitsToDouble(DataTools.bytesToLong(b = this.poi.getDocumentBytes(name, 8), 0, true))))) continue;
            this.timestamps.add(new Double(v));
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.timestamps.size() > 0) {
            this.core[0].sizeZ = this.getImageCount() / this.timestamps.size();
            this.core[0].sizeT = this.timestamps.size();
        }
        if (this.timestamps.size() == 0 || this.getSizeZ() * this.getSizeT() != this.getImageCount()) {
            this.core[0].sizeZ = this.getImageCount();
            this.core[0].sizeT = 1;
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].littleEndian = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setDimensionsPhysicalSizeX(new Float(scaleFactor), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(scaleFactor), 0, 0);
    }
}

