/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class OpenlabRawReader
extends FormatReader {
    protected int[] offsets;
    private int bytesPerPixel;

    public OpenlabRawReader() {
        super("Openlab RAW", "raw");
        this.blockCheckLen = 4;
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readString(this.blockCheckLen).startsWith("OLRW");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.offsets[no / this.getSizeC()] + 288);
        this.readPlane(this.in, x, y, w, h, buf);
        if (FormatTools.getBytesPerPixel(this.getPixelType()) == 1) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.offsets = null;
        this.bytesPerPixel = 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("OpenlabRawReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Verifying Openlab RAW format");
        if (!this.in.readString(4).equals("OLRW")) {
            throw new FormatException("Openlab RAW magic string not found.");
        }
        this.status("Populating metadata");
        this.addGlobalMeta("Version", this.in.readInt());
        this.core[0].imageCount = this.in.readInt();
        this.offsets = new int[this.getImageCount()];
        this.offsets[0] = 12;
        this.in.skipBytes(8);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.in.skipBytes(1);
        this.core[0].sizeC = this.in.read();
        this.bytesPerPixel = this.in.read();
        this.in.skipBytes(1);
        long stampMs = this.in.readLong();
        Date timestamp = null;
        String stamp = null;
        SimpleDateFormat sdf = null;
        if (stampMs > 0L) {
            stampMs /= 1000000L;
            stampMs = (long)((double)stampMs - 2.1143592E9);
            timestamp = new Date(stampMs);
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            stamp = sdf.format(timestamp);
            this.addGlobalMeta("Timestamp", stamp);
        }
        if (stamp == null) {
            stamp = DataTools.convertDate(System.currentTimeMillis(), 0);
        }
        this.in.skipBytes(4);
        int len = this.in.read() & 0xFF;
        this.addGlobalMeta("Image name", this.in.readString(len - 1).trim());
        this.core[0].sizeC = this.getSizeC() <= 1 ? 1 : 3;
        this.addGlobalMeta("Width", this.getSizeX());
        this.addGlobalMeta("Height", this.getSizeY());
        this.addGlobalMeta("Bytes per pixel", this.bytesPerPixel);
        int plane = this.getSizeX() * this.getSizeY() * this.bytesPerPixel;
        for (int i = 1; i < this.getImageCount(); ++i) {
            this.offsets[i] = this.offsets[i - 1] + 288 + plane;
        }
        this.core[0].sizeZ = this.getImageCount();
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYZTC";
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        switch (this.bytesPerPixel) {
            case 1: 
            case 3: {
                this.core[0].pixelType = 1;
                break;
            }
            case 2: {
                this.core[0].pixelType = 3;
                break;
            }
            default: {
                this.core[0].pixelType = 6;
            }
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        store.setImageCreationDate(stamp, 0);
    }
}

