/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.MJPBCodec;
import loci.formats.codec.MJPBCodecOptions;
import loci.formats.codec.QTRLECodec;
import loci.formats.codec.RPZACodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.FilterMetadata;

public class NativeQTReader
extends FormatReader {
    private static final String[] CONTAINER_TYPES = new String[]{"moov", "trak", "udta", "tref", "imap", "mdia", "minf", "stbl", "edts", "mdra", "rmra", "imag", "vnrp", "dinf"};
    private long pixelOffset;
    private long pixelBytes;
    private int bitsPerPixel;
    private int rawSize;
    private Vector offsets;
    private byte[] prevPixels;
    private int prevPlane;
    private boolean canUsePrevious;
    private String codec;
    private String altCodec;
    private int altPlanes;
    private int scale;
    private Vector chunkSizes;
    private boolean interlaced;
    private boolean spork;
    private boolean flip;

    public NativeQTReader() {
        super("QuickTime", "mov");
        this.blockCheckLen = 64;
    }

    public boolean isThisType(String name, boolean open) {
        if (super.isThisType(name, open)) {
            return true;
        }
        if (open) {
            try {
                RandomAccessInputStream s = new RandomAccessInputStream(name);
                boolean isThisType = this.isThisType(s);
                s.close();
                return isThisType;
            }
            catch (IOException e) {
                if (debug) {
                    this.trace(e);
                }
                return false;
            }
        }
        return name.indexOf(".") < 0;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        String s = stream.readString(this.blockCheckLen);
        for (int i = 0; i < CONTAINER_TYPES.length; ++i) {
            if (s.indexOf(CONTAINER_TYPES[i]) < 0 || CONTAINER_TYPES[i].equals("imag")) continue;
            return true;
        }
        return s.indexOf("wide") >= 0 || s.indexOf("mdat") >= 0 || s.indexOf("ftypqt") >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int size;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        String code = this.codec;
        if (no >= this.getImageCount() - this.altPlanes) {
            code = this.altCodec;
        }
        int offset = (Integer)this.offsets.get(no);
        int nextOffset = (int)this.pixelBytes;
        this.scale = (Integer)this.offsets.get(0);
        offset -= this.scale;
        if (no < this.offsets.size() - 1) {
            nextOffset = (Integer)this.offsets.get(no + 1);
            nextOffset -= this.scale;
        }
        if (nextOffset - offset < 0) {
            int temp = offset;
            offset = nextOffset;
            nextOffset = temp;
        }
        byte[] pixs = new byte[nextOffset - offset];
        this.in.seek(this.pixelOffset + (long)offset);
        this.in.read(pixs);
        this.canUsePrevious = this.prevPixels != null && this.prevPlane == no - 1 && !code.equals(this.altCodec);
        byte[] t = this.uncompress(pixs, code);
        if (code.equals("rpza")) {
            for (int i = 0; i < t.length; ++i) {
                t[i] = (byte)(255 - t[i]);
            }
            this.prevPlane = no;
            return buf;
        }
        if (this.canUsePrevious && this.prevPixels.length < t.length) {
            byte[] temp = t;
            t = new byte[this.prevPixels.length];
            System.arraycopy(temp, 0, t, 0, t.length);
        }
        this.prevPixels = t;
        this.prevPlane = no;
        int pad = (4 - this.getSizeX() % 4) % 4;
        if (this.codec.equals("mjpb")) {
            pad = 0;
        }
        if ((size = this.getSizeX() * this.getSizeY()) * (this.bitsPerPixel / 8) == this.prevPixels.length) {
            pad = 0;
        }
        if (pad > 0) {
            int bytes = this.bitsPerPixel < 40 ? this.bitsPerPixel / 8 : (this.bitsPerPixel - 32) / 8;
            t = new byte[this.prevPixels.length - this.getSizeY() * pad * bytes];
            for (int row = 0; row < this.getSizeY(); ++row) {
                System.arraycopy(this.prevPixels, bytes * row * (this.getSizeX() + pad), t, row * this.getSizeX() * bytes, this.getSizeX() * bytes);
            }
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int srcRowLen = this.getSizeX() * bpp * this.getSizeC();
        int destRowLen = w * bpp * this.getSizeC();
        for (int row = 0; row < h; ++row) {
            if (this.bitsPerPixel == 32) {
                for (int col = 0; col < w; ++col) {
                    int src = row * this.getSizeX() * bpp * 4 + (x + col) * bpp * 4 + 1;
                    int dst = row * destRowLen + col * bpp * 3;
                    if (src + 3 > t.length || dst + 3 > buf.length) continue;
                    System.arraycopy(t, src, buf, dst, 3);
                }
                continue;
            }
            System.arraycopy(t, row * srcRowLen + x * bpp * this.getSizeC(), buf, row * destRowLen, destRowLen);
        }
        if (!(this.bitsPerPixel != 40 && this.bitsPerPixel != 8 || code.equals("mjpb"))) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.offsets = null;
        this.prevPixels = null;
        this.altCodec = null;
        this.codec = null;
        this.rawSize = 0;
        this.bitsPerPixel = 0;
        this.pixelOffset = this.pixelBytes = (long)0;
        this.altPlanes = 0;
        this.prevPlane = 0;
        this.canUsePrevious = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("QTReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.spork = true;
        this.offsets = new Vector();
        this.chunkSizes = new Vector();
        this.status("Parsing tags");
        this.parse(0, 0L, this.in.length());
        this.core[0].imageCount = this.offsets.size();
        if (this.chunkSizes.size() < this.getImageCount() && this.chunkSizes.size() > 0) {
            this.core[0].imageCount = this.chunkSizes.size();
        }
        this.status("Populating metadata");
        int bytesPerPixel = this.bitsPerPixel / 8 % 4;
        this.core[0].pixelType = bytesPerPixel == 2 ? 3 : 1;
        this.core[0].sizeZ = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        if (this.spork) {
            String base = null;
            base = id.indexOf(".") != -1 ? id.substring(0, id.lastIndexOf(".")) : id;
            Location f = new Location(base + ".qtr");
            this.debug("Searching for research fork:");
            if (f.exists()) {
                this.debug("\t Found: " + f);
                if (this.in != null) {
                    this.in.close();
                }
                this.in = new RandomAccessInputStream(f.getAbsolutePath());
                this.stripHeader();
                this.parse(0, 0L, this.in.length());
                this.core[0].imageCount = this.offsets.size();
            } else {
                this.debug("\tAbsent: " + f);
                f = new Location(id.substring(0, id.lastIndexOf(File.separator) + 1) + "._" + id.substring(base.lastIndexOf(File.separator) + 1));
                if (f.exists()) {
                    this.debug("\t Found: " + f);
                    if (this.in != null) {
                        this.in.close();
                    }
                    this.in = new RandomAccessInputStream(f.getAbsolutePath());
                    this.stripHeader();
                    this.parse(0, this.in.getFilePointer(), this.in.length());
                    this.core[0].imageCount = this.offsets.size();
                } else {
                    this.debug("\tAbsent: " + f);
                    f = new Location(id + "/..namedfork/rsrc");
                    if (f.exists()) {
                        this.debug("\t Found: " + f);
                        if (this.in != null) {
                            this.in.close();
                        }
                        this.in = new RandomAccessInputStream(f.getAbsolutePath());
                        this.stripHeader();
                        this.parse(0, this.in.getFilePointer(), this.in.length());
                        this.core[0].imageCount = this.offsets.size();
                    } else {
                        this.debug("\tAbsent: " + f);
                        throw new FormatException("QuickTime resource fork not found.  To avoid this issue, please flatten your QuickTime movies before importing with Bio-Formats.");
                    }
                }
            }
        }
        this.core[0].rgb = this.bitsPerPixel < 40;
        this.core[0].sizeC = this.isRGB() ? 3 : 1;
        this.core[0].interleaved = this.isRGB();
        this.core[0].sizeT = this.getImageCount();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(int depth, long offset, long length) throws FormatException, IOException {
        while (offset < length) {
            this.in.seek(offset);
            long atomSize = this.in.readInt() & 0xFFFFFFFF;
            String atomType = this.in.readString(4);
            if (atomSize == 1L) {
                atomSize = this.in.readLong();
            }
            if (atomSize < 0L) {
                LogTools.println("QTReader: invalid atom size: " + atomSize);
            }
            this.debug("Seeking to " + offset + "; atomType=" + atomType + "; atomSize=" + atomSize);
            if (this.isContainer(atomType)) {
                this.parse(depth++, this.in.getFilePointer(), offset + atomSize);
            } else {
                int i;
                if (atomSize == 0L) {
                    atomSize = this.in.length();
                }
                long oldpos = this.in.getFilePointer();
                if (atomType.equals("mdat")) {
                    this.pixelOffset = this.in.getFilePointer();
                    this.pixelBytes = atomSize;
                    if (this.pixelBytes > this.in.length() - this.pixelOffset) {
                        this.pixelBytes = this.in.length() - this.pixelOffset;
                    }
                } else if (atomType.equals("tkhd")) {
                    this.in.skipBytes(38);
                    int[][] matrix = new int[3][3];
                    for (i = 0; i < matrix.length; ++i) {
                        for (int j = 0; j < matrix[0].length; ++j) {
                            matrix[i][j] = this.in.readInt();
                        }
                    }
                    boolean bl = this.flip = matrix[0][0] == 0 && matrix[1][0] != 0;
                    if (this.getSizeX() == 0) {
                        this.core[0].sizeX = this.in.readInt();
                    }
                    if (this.getSizeY() == 0) {
                        this.core[0].sizeY = this.in.readInt();
                    }
                } else if (atomType.equals("cmov")) {
                    this.in.skipBytes(8);
                    if (!"zlib".equals(this.in.readString(4))) throw new FormatException("Compressed header not supported.");
                    atomSize = this.in.readInt();
                    this.in.skipBytes(4);
                    int uncompressedSize = this.in.readInt();
                    byte[] b = new byte[(int)(atomSize - 12L)];
                    this.in.read(b);
                    byte[] output = new ZlibCodec().decompress(b, null);
                    RandomAccessInputStream oldIn = this.in;
                    this.in = new RandomAccessInputStream(output);
                    this.parse(0, 0L, output.length);
                    this.in.close();
                    this.in = oldIn;
                } else if (atomType.equals("stco")) {
                    if (this.offsets.size() > 0) return;
                    this.spork = false;
                    this.in.skipBytes(4);
                    int numPlanes = this.in.readInt();
                    if (numPlanes != this.getImageCount()) {
                        this.in.seek(this.in.getFilePointer() - 4L);
                        int off = this.in.readInt();
                        this.offsets.add(new Integer(off));
                        for (int i2 = 1; i2 < this.getImageCount(); ++i2) {
                            if (this.chunkSizes.size() > 0 && i2 < this.chunkSizes.size()) {
                                this.rawSize = (Integer)this.chunkSizes.get(i2);
                            } else {
                                i2 = this.getImageCount();
                            }
                            this.offsets.add(new Integer(off += this.rawSize));
                        }
                    } else {
                        for (i = 0; i < numPlanes; ++i) {
                            this.offsets.add(new Integer(this.in.readInt()));
                        }
                    }
                } else if (atomType.equals("stsd")) {
                    this.in.skipBytes(4);
                    int numEntries = this.in.readInt();
                    this.in.skipBytes(4);
                    for (i = 0; i < numEntries; ++i) {
                        if (i == 0) {
                            this.codec = this.in.readString(4);
                            if (!(this.codec.equals("raw ") || this.codec.equals("rle ") || this.codec.equals("rpza") || this.codec.equals("mjpb") || this.codec.equals("jpeg"))) {
                                throw new FormatException("Unsupported codec: " + this.codec);
                            }
                            this.in.skipBytes(16);
                            if (this.in.readShort() != 0) continue;
                            this.in.skipBytes(56);
                            this.bitsPerPixel = this.in.readShort();
                            if (this.codec.equals("rpza")) {
                                this.bitsPerPixel = 8;
                            }
                            this.in.skipBytes(10);
                            this.interlaced = this.in.read() == 2;
                            this.addGlobalMeta("Codec", this.codec);
                            this.addGlobalMeta("Bits per pixel", this.bitsPerPixel);
                            this.in.skipBytes(9);
                            continue;
                        }
                        this.altCodec = this.in.readString(4);
                        this.addGlobalMeta("Second codec", this.altCodec);
                    }
                } else if (atomType.equals("stsz")) {
                    this.in.skipBytes(4);
                    this.rawSize = this.in.readInt();
                    this.core[0].imageCount = this.in.readInt();
                    if (this.rawSize == 0) {
                        this.in.seek(this.in.getFilePointer() - 4L);
                        for (int b = 0; b < this.getImageCount(); ++b) {
                            this.chunkSizes.add(new Integer(this.in.readInt()));
                        }
                    }
                } else if (atomType.equals("stsc")) {
                    this.in.skipBytes(4);
                    int numChunks = this.in.readInt();
                    if (this.altCodec != null) {
                        int prevChunk = 0;
                        for (int i3 = 0; i3 < numChunks; ++i3) {
                            int chunk = this.in.readInt();
                            int planesPerChunk = this.in.readInt();
                            int id = this.in.readInt();
                            if (id == 2) {
                                this.altPlanes += planesPerChunk * (chunk - prevChunk);
                            }
                            prevChunk = chunk;
                        }
                    }
                } else if (atomType.equals("stts")) {
                    this.in.skipBytes(10);
                    int fps = this.in.readInt();
                    this.addGlobalMeta("Frames per second", fps);
                }
                if (oldpos + atomSize >= this.in.length()) return;
                this.in.seek(oldpos + atomSize);
            }
            offset = atomSize == 0L ? this.in.length() : (offset += atomSize);
            if (atomType.equals("udta")) {
                offset += 4L;
            }
            this.print(depth, atomSize, atomType);
        }
    }

    private boolean isContainer(String type) {
        for (int i = 0; i < CONTAINER_TYPES.length; ++i) {
            if (!type.equals(CONTAINER_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    private void print(int depth, long size, String type) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(" ");
        }
        sb.append(type + " : [" + size + "]");
        this.debug(sb.toString());
    }

    private byte[] uncompress(byte[] pixs, String code) throws FormatException, IOException {
        MJPBCodecOptions options = new MJPBCodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.bitsPerSample = this.bitsPerPixel;
        options.channels = this.bitsPerPixel < 40 ? this.bitsPerPixel / 8 : (this.bitsPerPixel - 32) / 8;
        options.previousImage = this.canUsePrevious ? this.prevPixels : null;
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isRGB();
        if (code.equals("raw ")) {
            return pixs;
        }
        if (code.equals("rle ")) {
            return new QTRLECodec().decompress(pixs, (CodecOptions)options);
        }
        if (code.equals("rpza")) {
            return new RPZACodec().decompress(pixs, (CodecOptions)options);
        }
        if (code.equals("mjpb")) {
            options.interlaced = this.interlaced;
            return new MJPBCodec().decompress(pixs, (CodecOptions)options);
        }
        if (code.equals("jpeg")) {
            return new JPEGCodec().decompress(pixs, (CodecOptions)options);
        }
        throw new FormatException("Unsupported codec : " + code);
    }

    private void stripHeader() throws IOException {
        int r;
        long fp = this.in.getFilePointer();
        byte[] buf = new byte[8192];
        int index = -1;
        while ((r = this.in.read(buf, 3, buf.length - 3)) > 0) {
            for (int i = 0; i < buf.length - 3; ++i) {
                if (buf[i] != 109 || buf[i + 1] != 111 || buf[i + 2] != 111 || buf[i + 3] != 118) continue;
                index = i - 3;
                break;
            }
            if (index >= 0) break;
            fp += (long)r;
            buf[0] = buf[buf.length - 3];
            buf[1] = buf[buf.length - 2];
            buf[2] = buf[buf.length - 1];
        }
        if (index >= 0) {
            this.in.seek(fp + (long)index - 4L);
        }
    }
}

