/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIASReader
extends FormatReader {
    private String[][][] tiffs;
    private MinimalTiffReader reader;
    private String resultFile = null;
    private Vector<String> analysisFiles = null;
    private int[][] wellNumber;
    private int tileRows;
    private int tileCols;
    private int tileWidth;
    private int tileHeight;

    public MIASReader() {
        super("MIAS", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.blockCheckLen = 0x100000;
    }

    @Override
    public boolean isThisType(String filename, boolean open) {
        Location baseFile = new Location(filename).getAbsoluteFile();
        Location wellDir = baseFile.getParentFile();
        Location experiment = wellDir.getParentFile().getParentFile();
        return wellDir != null && experiment != null && wellDir.getName().startsWith("Well") && super.isThisType(filename, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        Hashtable ifd = TiffTools.getFirstIFD(stream);
        if (ifd == null) {
            return false;
        }
        Object s = TiffTools.getIFDValue(ifd, 305);
        if (s == null) {
            return false;
        }
        String software = null;
        software = s instanceof String[] ? ((String[])s)[0] : s.toString();
        return software.startsWith("eaZYX");
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.reader == null ? (byte[][])null : this.reader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.reader == null ? (short[][])null : this.reader.get16BitLookupTable();
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        int well = this.getWellNumber(this.getSeries());
        int plate = this.getPlateNumber(this.getSeries());
        this.reader.setId(this.tiffs[well][plate][no * this.tileRows * this.tileCols]);
        return this.reader.openThumbBytes(0);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int well = this.getWellNumber(this.getSeries());
        int plate = this.getPlateNumber(this.getSeries());
        if (this.tileRows == 1 && this.tileCols == 1) {
            this.reader.setId(this.tiffs[plate][well][no]);
            this.reader.openBytes(0, buf, x, y, w, h);
            return buf;
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int outputRowLen = w * bpp;
        Region image = new Region(x, y, w, h);
        int outputRow = 0;
        int outputCol = 0;
        Region intersection = null;
        byte[] tileBuf = null;
        for (int row = 0; row < this.tileRows; ++row) {
            for (int col = 0; col < this.tileCols; ++col) {
                Region tile = new Region(col * this.tileWidth, row * this.tileHeight, this.tileWidth, this.tileHeight);
                if (!tile.intersects(image)) continue;
                intersection = tile.intersection(image);
                intersection.x %= this.tileWidth;
                intersection.y %= this.tileHeight;
                this.reader.setId(this.tiffs[plate][well][(no * this.tileRows + row) * this.tileCols + col]);
                tileBuf = this.reader.openBytes(0, intersection.x, intersection.y, intersection.width, intersection.height);
                int rowLen = tileBuf.length / intersection.height;
                int outputOffset = outputRow * outputRowLen + outputCol;
                for (int trow = 0; trow < intersection.height; ++trow) {
                    System.arraycopy(tileBuf, trow * rowLen, buf, outputOffset, rowLen);
                    outputOffset += outputRowLen;
                }
                outputCol += rowLen;
            }
            if (intersection == null) continue;
            outputRow += intersection.height;
            outputCol = 0;
        }
        return buf;
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        if (!noPixels) {
            String[][][] arr$ = this.tiffs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[][] plates;
                String[][] arr$2 = plates = arr$[i$];
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    String[] wells;
                    for (String file2 : wells = arr$2[i$2]) {
                        files.add(file2);
                    }
                }
            }
        }
        if (this.resultFile != null) {
            files.add(this.resultFile);
        }
        for (String file3 : this.analysisFiles) {
            if (file3.endsWith(".tif") && noPixels) continue;
            files.add(file3);
        }
        return files.toArray(new String[0]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.reader != null) {
            this.reader.close(fileOnly);
        }
        if (!fileOnly) {
            this.reader = null;
            this.tiffs = null;
            this.tileCols = 0;
            this.tileRows = 0;
            this.resultFile = null;
            this.analysisFiles = null;
            this.wellNumber = null;
            this.tileHeight = 0;
            this.tileWidth = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("MIASReader.initFile(" + id + ")");
        super.initFile(id);
        this.reader = new MinimalTiffReader();
        this.analysisFiles = new Vector();
        this.status("Building list of TIFF files");
        Location baseFile = new Location(id).getAbsoluteFile();
        Location experiment = baseFile.getParentFile().getParentFile().getParentFile();
        String experimentName = experiment.getName();
        Vector<Object> plateDirs = new Vector<Object>();
        Object[] directories = experiment.list();
        Arrays.sort(directories);
        for (Object dir : directories) {
            if (((String)dir).equals("Batchresults")) {
                String[] results;
                Location f = new Location(experiment, (String)dir);
                for (String result : results = f.list()) {
                    Location file2 = new Location(f, result);
                    this.analysisFiles.add(file2.getAbsolutePath());
                    if (!result.startsWith("NEO_Results")) continue;
                    this.resultFile = file2.getAbsolutePath();
                }
                continue;
            }
            plateDirs.add(dir);
        }
        int nPlates = plateDirs.size();
        this.tiffs = new String[nPlates][][];
        int[][] zCount = new int[nPlates][];
        int[][] cCount = new int[nPlates][];
        int[][] tCount = new int[nPlates][];
        String[][] order = new String[nPlates][];
        this.wellNumber = new int[nPlates][];
        for (int i2 = 0; i2 < nPlates; ++i2) {
            String plate = (String)plateDirs.get(i2);
            Location plateDir = new Location(experiment, plate);
            Object[] list = plateDir.list();
            Arrays.sort(list);
            Vector<String> wellDirectories = new Vector<String>();
            for (Object dir : list) {
                String[] resultsList;
                Location f = new Location(plateDir, (String)dir);
                if (f.getName().startsWith("Well")) {
                    wellDirectories.add(f.getAbsolutePath());
                    continue;
                }
                if (!f.getName().equals("results")) continue;
                for (String string : resultsList = f.list()) {
                    if (string.endsWith(".sav") || string.endsWith(".dsv")) continue;
                    Location r = new Location(f, string);
                    this.analysisFiles.add(r.getAbsolutePath());
                }
            }
            this.tiffs[i2] = new String[wellDirectories.size()][];
            zCount[i2] = new int[wellDirectories.size()];
            cCount[i2] = new int[wellDirectories.size()];
            tCount[i2] = new int[wellDirectories.size()];
            order[i2] = new String[wellDirectories.size()];
            this.wellNumber[i2] = new int[wellDirectories.size()];
            for (int j = 0; j < wellDirectories.size(); ++j) {
                Location well = new Location((String)wellDirectories.get(j));
                String wellName = well.getName().replaceAll("Well", "");
                this.wellNumber[i2][j] = Integer.parseInt(wellName) - 1;
                String wellPath = well.getAbsolutePath();
                Object[] tiffFiles = well.list();
                Vector<String> tmpFiles = new Vector<String>();
                for (String string : tiffFiles) {
                    String name = string.toLowerCase();
                    if (!name.endsWith(".tif") && !name.endsWith(".tiff")) continue;
                    tmpFiles.add(string);
                }
                tiffFiles = tmpFiles.toArray(new String[0]);
                FilePattern fp = new FilePattern(tiffFiles[0], wellPath);
                String[] blocks = fp.getPrefixes();
                BigInteger[] firstNumber = fp.getFirst();
                BigInteger[] bigIntegerArray = fp.getLast();
                BigInteger[] step = fp.getStep();
                order[i2][j] = "XY";
                for (int block = blocks.length - 1; block >= 0; --block) {
                    blocks[block] = blocks[block].toLowerCase();
                    blocks[block] = blocks[block].substring(blocks[block].lastIndexOf("_") + 1);
                    BigInteger tmp = bigIntegerArray[block].subtract(firstNumber[block]);
                    tmp = tmp.add(BigInteger.ONE).divide(step[block]);
                    int count = tmp.intValue();
                    if (blocks[block].equals("z")) {
                        zCount[i2][j] = count;
                        String[] stringArray = order[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + "Z";
                        continue;
                    }
                    if (blocks[block].equals("t")) {
                        tCount[i2][j] = count;
                        String[] stringArray = order[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + "T";
                        continue;
                    }
                    if (blocks[block].equals("mode")) {
                        cCount[i2][j] = count;
                        String[] stringArray = order[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + "C";
                        continue;
                    }
                    if (blocks[block].equals("im")) {
                        this.tileRows = count;
                        continue;
                    }
                    if (blocks[block].equals("")) {
                        this.tileCols = count;
                        continue;
                    }
                    throw new FormatException("Unsupported block '" + blocks[block]);
                }
                Arrays.sort(tiffFiles);
                this.tiffs[i2][j] = new String[tiffFiles.length];
                for (int k = 0; k < tiffFiles.length; ++k) {
                    this.tiffs[i2][j][k] = new Location(wellPath, (String)tiffFiles[k]).getAbsolutePath();
                }
            }
        }
        this.status("Populating core metadata");
        int nSeries = 0;
        for (i = 0; i < this.tiffs.length; ++i) {
            nSeries += this.tiffs[i].length;
        }
        this.core = new CoreMetadata[nSeries];
        for (i = 0; i < this.core.length; ++i) {
            this.core[i] = new CoreMetadata();
            int plate = this.getPlateNumber(i);
            int well = this.getWellNumber(i);
            this.core[i].sizeZ = zCount[plate][well];
            this.core[i].sizeC = cCount[plate][well];
            this.core[i].sizeT = tCount[plate][well];
            if (this.core[i].sizeZ == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.core[i].sizeC == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.core[i].sizeT == 0) {
                this.core[i].sizeT = 1;
            }
            this.reader.setId(this.tiffs[plate][well][0]);
            this.tileWidth = this.reader.getSizeX();
            this.tileHeight = this.reader.getSizeY();
            this.core[i].sizeX = this.tileWidth * this.tileCols;
            this.core[i].sizeY = this.tileHeight * this.tileRows;
            this.core[i].pixelType = this.reader.getPixelType();
            this.core[i].sizeC *= this.reader.getSizeC();
            this.core[i].rgb = this.reader.isRGB();
            this.core[i].littleEndian = this.reader.isLittleEndian();
            this.core[i].interleaved = this.reader.isInterleaved();
            this.core[i].indexed = this.reader.isIndexed();
            this.core[i].falseColor = this.reader.isFalseColor();
            this.core[i].dimensionOrder = order[plate][well];
            if (this.core[i].dimensionOrder.indexOf("Z") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "Z";
            }
            if (this.core[i].dimensionOrder.indexOf("C") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
            }
            if (this.core[i].dimensionOrder.indexOf("T") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
            }
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeT * cCount[plate][well];
        }
        this.status("Populating metadata hashtable");
        int wellCols = 1;
        if (this.resultFile != null) {
            String[] lines;
            RandomAccessInputStream s = new RandomAccessInputStream(this.resultFile);
            String[] cols = null;
            Vector<String> rows = new Vector<String>();
            boolean doKeyValue = true;
            int nStarLines = 0;
            String analysisResults = s.readString((int)s.length());
            s.close();
            for (String line : lines = analysisResults.split("\n")) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("******") && line.endsWith("******")) {
                    ++nStarLines;
                }
                if (doKeyValue) {
                    String[] n = line.split("\t");
                    if (n[0].endsWith(":")) {
                        n[0] = n[0].substring(0, n[0].length() - 1);
                    }
                    if (n.length >= 2) {
                        this.addGlobalMeta(n[0], n[1]);
                    }
                } else if (cols == null) {
                    cols = line.split("\t");
                } else {
                    rows.add(line);
                }
                if (nStarLines != 2) continue;
                doKeyValue = false;
            }
            for (String row : rows) {
                String[] d = row.split("\t");
                for (int col = 3; col < cols.length; ++col) {
                    this.addGlobalMeta("Plate " + d[0] + ", Well " + d[2] + " " + cols[col], d[col]);
                    if (!cols[col].equals("AreaCode")) continue;
                    String wellID = d[col].replaceAll("\\D", "");
                    wellCols = Integer.parseInt(wellID);
                }
            }
        }
        this.status("Populating MetadataStore");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setExperimentID("Experiment:" + experimentName, 0);
        store.setExperimentType("Other", 0);
        for (int plate = 0; plate < this.tiffs.length; ++plate) {
            store.setPlateColumnNamingConvention("1", plate);
            store.setPlateRowNamingConvention("A", plate);
            String plateDir = (String)plateDirs.get(plate);
            plateDir = plateDir.substring(plateDir.indexOf("-") + 1);
            store.setPlateName(plateDir, plate);
            store.setPlateExternalIdentifier(plateDir, plate);
            for (int well = 0; well < this.tiffs[plate].length; ++well) {
                int wellIndex = this.wellNumber[plate][well];
                store.setWellColumn(wellIndex % wellCols, plate, wellIndex);
                store.setWellRow(wellIndex / wellCols, plate, wellIndex);
                int series = this.getSeriesNumber(plate, well);
                store.setWellSampleImageRef("Image:" + series, plate, wellIndex, 0);
                store.setWellSampleIndex(new Integer(series), plate, wellIndex, 0);
                store.setImageExperimentRef("Experiment:" + experimentName, series);
                char wellRow = (char)(65 + wellIndex / wellCols);
                int wellCol = well % wellCols + 1;
                store.setImageID("Image:" + series, series);
                store.setImageName("Plate #" + plate + ", Well " + wellRow + wellCol, series);
                MetadataTools.setDefaultCreationDate(store, id, series);
            }
        }
        for (String file3 : this.analysisFiles) {
            void var26_83;
            int start;
            String name = new Location(file3).getName();
            if (!name.startsWith("Well") || !name.endsWith(".txt")) continue;
            int[] position = this.getPositionFromFile(file3);
            int series = this.getSeriesNumber(position[0], position[1]);
            RandomAccessInputStream s = new RandomAccessInputStream(file3);
            String data = s.readString((int)s.length());
            String[] lines = data.split("\n");
            for (start = 0; start < lines.length && !lines[start].startsWith("Label"); ++start) {
            }
            if (start >= lines.length) continue;
            String[] columns = lines[start].split("\t");
            Vector<String> columnNames = new Vector<String>();
            for (String v : columns) {
                columnNames.add(v);
            }
            int n = start + 1;
            while (var26_83 < lines.length) {
                this.populateROI(columnNames, lines[var26_83].split("\t"), series, (int)(var26_83 - start - true), position[2], position[3], store);
                ++var26_83;
            }
            s.close();
        }
    }

    private int[] getPositionFromFile(String file2) {
        int[] position = new int[4];
        String plateName = new Location(file2).getParentFile().getParentFile().getName();
        String plateIndex = plateName.substring(0, plateName.indexOf("-"));
        position[0] = Integer.parseInt(plateIndex) - 1;
        file2 = file2.substring(file2.lastIndexOf(File.separator) + 1);
        String wellIndex = file2.substring(4, file2.indexOf("_"));
        position[1] = Integer.parseInt(wellIndex) - 1;
        int tIndex = file2.indexOf("_t") + 2;
        String t = file2.substring(tIndex, file2.indexOf("_", tIndex));
        position[2] = Integer.parseInt(t);
        int zIndex = file2.indexOf("_z") + 2;
        String zValue = file2.substring(zIndex, file2.indexOf("_", zIndex));
        position[3] = Integer.parseInt(zValue);
        return position;
    }

    private void populateROI(Vector<String> columns, String[] data, int series, int roi, int time, int z, MetadataStore store) {
        float cx = Float.parseFloat(data[columns.indexOf("Col")]);
        float cy = Float.parseFloat(data[columns.indexOf("Row")]);
        store.setROIT0(new Integer(time), series, roi);
        store.setROIT1(new Integer(time), series, roi);
        store.setROIZ0(new Integer(z), series, roi);
        store.setROIZ1(new Integer(z), series, roi);
        store.setShapeText(data[columns.indexOf("Label")], series, roi, 0);
        store.setShapeTheT(new Integer(time), series, roi, 0);
        store.setShapeTheZ(new Integer(z), series, roi, 0);
        store.setCircleCx(data[columns.indexOf("Col")], series, roi, 0);
        store.setCircleCy(data[columns.indexOf("Row")], series, roi, 0);
        float diam = Float.parseFloat(data[columns.indexOf("Cell Diam.")]);
        String radius = String.valueOf(diam / 2.0f);
        store.setCircleR(radius, series, roi, 0);
    }

    private int getSeriesNumber(int plate, int well) {
        int series = 0;
        for (int i = 0; i < plate; ++i) {
            series += this.tiffs[i].length;
        }
        return series + well;
    }

    private int getWellNumber(int series) {
        return this.getPlateAndWell(series)[1];
    }

    private int getPlateNumber(int series) {
        return this.getPlateAndWell(series)[0];
    }

    private int[] getPlateAndWell(int series) {
        int wellNumber = series;
        int plateNumber = 0;
        while (wellNumber >= this.tiffs[plateNumber].length) {
            wellNumber -= this.tiffs[plateNumber].length;
            ++plateNumber;
        }
        return new int[]{plateNumber, wellNumber};
    }
}

