/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.List;
import java.util.Vector;
import loci.common.LogTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;
import loci.formats.FormatHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MDBParser {
    private static final String NO_MDB_MSG = "The Java port of MDB tools is required to read MDB files. Please obtain mdbtools-java.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noMDB = false;
    private static ReflectedUniverse r = MDBParser.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        block2: {
            r = null;
            try {
                r = new ReflectedUniverse();
                r.exec("import java.util.Vector");
                r.exec("import mdbtools.jdbc2.File");
                r.exec("import mdbtools.libmdb.Catalog");
                r.exec("import mdbtools.libmdb.Constants");
                r.exec("import mdbtools.libmdb.Data");
                r.exec("import mdbtools.libmdb.Holder");
                r.exec("import mdbtools.libmdb.MdbCatalogEntry");
                r.exec("import mdbtools.libmdb.MdbColumn");
                r.exec("import mdbtools.libmdb.MdbHandle");
                r.exec("import mdbtools.libmdb.MdbTableDef");
                r.exec("import mdbtools.libmdb.Table");
                r.exec("import mdbtools.libmdb.file");
                r.exec("import mdbtools.libmdb.mem");
            }
            catch (Throwable t) {
                noMDB = true;
                if (!FormatHandler.debug) break block2;
                LogTools.trace(t);
            }
        }
        return r;
    }

    private MDBParser() {
    }

    public static Vector<String[]>[] parseDatabase(String filename) throws FormatException {
        if (noMDB) {
            throw new FormatException(NO_MDB_MSG);
        }
        try {
            r.exec("boundValues = new Vector()");
            r.exec("mem.mdb_init()");
            r.setVar("filename", filename);
            r.exec("dbfile = new File(filename)");
            r.exec("mdb = file.mdb_open(dbfile)");
            r.exec("Catalog.mdb_read_catalog(mdb, Constants.MDB_TABLE)");
            int num = (Integer)r.getVar("mdb.num_catalog");
            r.setVar("c", (List)r.getVar("mdb.catalog"));
            int realCount = num;
            for (int i = 0; i < num; ++i) {
                r.setVar("i", i);
                r.exec("entry = c.get(i)");
                int objType = (Integer)r.getVar("entry.object_type");
                int tableType = (Integer)r.getVar("Constants.MDB_TABLE");
                String objName = (String)r.getVar("entry.object_name");
                if (objType == tableType && !objName.startsWith("MSys")) continue;
                --realCount;
            }
            Vector[] rtn = new Vector[realCount];
            int previousColumnCount = 0;
            int index = 0;
            for (int i = 0; i < num; ++i) {
                boolean moreRows;
                int numCols;
                String objName;
                block17: {
                    r.setVar("i", i);
                    r.exec("entry = c.get(i)");
                    r.setVar("objType", (Integer)r.getVar("entry.object_type"));
                    r.setVar("objName", (String)r.getVar("entry.object_name"));
                    int objType = (Integer)r.getVar("objType");
                    int tableType = (Integer)r.getVar("Constants.MDB_TABLE");
                    boolean isTable = objType == tableType;
                    objName = (String)r.getVar("objName");
                    if (!isTable || objName.startsWith("MSys")) continue;
                    rtn[index++] = new Vector();
                    r.exec("table = Table.mdb_read_table(entry)");
                    try {
                        r.exec("Table.mdb_read_columns(table)");
                    }
                    catch (ReflectException e) {
                        if (!FormatHandler.debug) break;
                        LogTools.trace(e);
                        break;
                    }
                    numCols = (Integer)r.getVar("table.num_cols");
                    for (int j = 0; j < numCols; ++j) {
                        r.exec("blah = new Holder()");
                        r.setVar("l", j + 1);
                        r.exec("Data.mdb_bind_column(table, l, blah)");
                        r.exec("boundValues.add(blah)");
                    }
                    moreRows = true;
                    try {
                        r.exec("moreRows = Data.mdb_fetch_row(table)");
                        moreRows = (Boolean)r.getVar("moreRows");
                    }
                    catch (ReflectException e) {
                        moreRows = false;
                        if (!FormatHandler.debug) break block17;
                        LogTools.trace(e);
                    }
                }
                while (moreRows) {
                    String[] row = new String[numCols];
                    for (int j = 0; j < numCols; ++j) {
                        r.setVar("j", j + previousColumnCount + 1);
                        try {
                            r.exec("blah = boundValues.get(j)");
                            row[j] = (String)r.getVar("blah.s");
                            continue;
                        }
                        catch (ReflectException e) {
                            // empty catch block
                        }
                    }
                    rtn[index - 1].add(row);
                    try {
                        r.exec("moreRows = Data.mdb_fetch_row(table)");
                        moreRows = (Boolean)r.getVar("moreRows");
                    }
                    catch (ReflectException e) {
                        moreRows = false;
                    }
                }
                r.setVar("columns", (List)r.getVar("table.columns"));
                String[] columnNames = new String[numCols + 1];
                columnNames[0] = objName;
                for (int j = 1; j < numCols; ++j) {
                    r.setVar("j", j);
                    r.exec("col = columns.get(j)");
                    columnNames[j] = (String)r.getVar("col.name");
                }
                rtn[index - 1].insertElementAt(columnNames, 0);
                previousColumnCount += numCols;
            }
            return rtn;
        }
        catch (ReflectException exc) {
            LogTools.trace(exc);
            return null;
        }
    }
}

