/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;

public class ImprovisionTiffReader
extends BaseTiffReader {
    private String[] cNames;
    private int pixelSizeT;
    private float pixelSizeX;
    private float pixelSizeY;
    private float pixelSizeZ;

    public ImprovisionTiffReader() {
        super("Improvision TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        try {
            RandomAccessInputStream stream = new RandomAccessInputStream(name);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException e) {
            if (debug) {
                this.trace(e);
            }
            return false;
        }
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        Hashtable ifd = TiffTools.getFirstIFD(stream);
        String comment = TiffTools.getComment(ifd);
        return comment != null && comment.indexOf("Improvision") != -1;
    }

    public void close() throws IOException {
        super.close();
        this.cNames = null;
        this.pixelSizeT = 1;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        this.put("Improvision", "yes");
        String comment = TiffTools.getComment(this.ifds[0]);
        String tz = null;
        String tc = null;
        String tt = null;
        if (comment != null) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                this.addGlobalMeta(key, value);
                if (key.equals("TotalZPlanes")) {
                    tz = value;
                    continue;
                }
                if (key.equals("TotalChannels")) {
                    tc = value;
                    continue;
                }
                if (key.equals("TotalTimepoints")) {
                    tt = value;
                    continue;
                }
                if (key.equals("XCalibrationMicrons")) {
                    this.pixelSizeX = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("YCalibrationMicrons")) {
                    this.pixelSizeY = Float.parseFloat(value);
                    continue;
                }
                if (!key.equals("ZCalibrationMicrons")) continue;
                this.pixelSizeZ = Float.parseFloat(value);
            }
            this.metadata.remove("Comment");
        }
        if (tz == null) {
            tz = "1";
        }
        if (tc == null) {
            tc = "1";
        }
        if (tt == null) {
            tt = "1";
        }
        this.core[0].sizeT = 1;
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        this.core[0].sizeZ *= Integer.parseInt(tz);
        this.core[0].sizeC *= Integer.parseInt(tc);
        this.core[0].sizeT *= Integer.parseInt(tt);
        if (this.getSizeZ() * this.getSizeC() * this.getSizeT() < this.getImageCount()) {
            this.core[0].sizeC *= this.getImageCount();
        }
        long[] stamps = new long[this.ifds.length];
        int[][] coords = new int[this.ifds.length][3];
        this.cNames = new String[this.getSizeC()];
        for (int i2 = 0; i2 < this.ifds.length; ++i2) {
            comment = TiffTools.getComment(this.ifds[i2]);
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
            StringTokenizer st = new StringTokenizer(comment, "\n");
            String channelName = null;
            while (st.hasMoreTokens()) {
                int ndx;
                String line = st.nextToken();
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                if (key.equals("TimeStampMicroSeconds")) {
                    stamps[i2] = Long.parseLong(value);
                    continue;
                }
                if (key.equals("ZPlane")) {
                    coords[i2][0] = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("ChannelNo")) {
                    coords[i2][1] = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("TimepointName")) {
                    coords[i2][2] = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("ChannelName")) {
                    channelName = value;
                    continue;
                }
                if (!key.equals("ChannelNo") || this.cNames[ndx = Integer.parseInt(value)] != null) continue;
                this.cNames[ndx] = channelName;
            }
        }
        long sum = 0L;
        for (i = 1; i < stamps.length; ++i) {
            long diff = stamps[i] - stamps[i - 1];
            if (diff <= 0L) continue;
            sum += diff;
        }
        this.pixelSizeT = (int)(sum / (long)this.getSizeT());
        this.core[0].dimensionOrder = "XY";
        for (i = 1; i < coords.length; ++i) {
            int zDiff = coords[i][0] - coords[i - 1][0];
            int cDiff = coords[i][1] - coords[i - 1][1];
            int tDiff = coords[i][2] - coords[i - 1][2];
            if (zDiff > 0 && this.getDimensionOrder().indexOf("Z") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
            }
            if (cDiff > 0 && this.getDimensionOrder().indexOf("C") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
            }
            if (tDiff > 0 && this.getDimensionOrder().indexOf("T") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
            }
            if (this.core[0].dimensionOrder.length() == 5) break;
        }
        if (this.getDimensionOrder().indexOf("Z") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("C") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("T") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(this.pixelSizeZ), 0, 0);
        store.setDimensionsTimeIncrement(new Float((double)this.pixelSizeT / 1000000.0), 0, 0);
    }
}

