/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;
import loci.formats.FormatHandler;

public class LegacyQTTools {
    public static final String NO_QT_MSG = "QuickTime for Java is required to read some QuickTime files. Please install QuickTime for Java from http://www.apple.com/quicktime/";
    public static final String EXPIRED_QT_MSG = "Your version of QuickTime for Java has expired. Please reinstall QuickTime for Java from http://www.apple.com/quicktime/";
    protected static final String[] SUFFIXES = new String[]{"mov", "qt"};
    protected static final boolean MAC_OS_X = System.getProperty("os.name").equals("Mac OS X");
    protected static final ClassLoader LOADER = LegacyQTTools.constructLoader();
    protected boolean initialized = false;
    protected boolean noQT = false;
    protected boolean expiredQT = false;
    protected ReflectedUniverse r;

    protected static ClassLoader constructLoader() {
        URL[] paths = null;
        if (MAC_OS_X) {
            try {
                paths = new URL[]{new URL("file:/System/Library/Java/Extensions/QTJava.zip")};
            }
            catch (MalformedURLException exc) {
                LogTools.trace(exc);
            }
            return paths == null ? null : new URLClassLoader(paths);
        }
        String windir = System.getProperty("java.library.path");
        StringTokenizer st = new StringTokenizer(windir, ";");
        while (st.hasMoreTokens()) {
            Location f = new Location(st.nextToken(), "QTJava.zip");
            if (!f.exists()) continue;
            try {
                paths = new URL[]{f.toURL()};
            }
            catch (MalformedURLException exc) {
                LogTools.trace(exc);
            }
            return paths == null ? null : new URLClassLoader(paths);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClass() {
        if (this.initialized) {
            return;
        }
        boolean needClose = false;
        this.r = new ReflectedUniverse(LOADER);
        try {
            this.r.exec("import quicktime.QTSession");
            this.r.exec("QTSession.open()");
            needClose = true;
            this.r.exec("import quicktime.io.QTFile");
            this.r.exec("import quicktime.std.movies.Movie");
            this.r.exec("import quicktime.app.view.MoviePlayer");
            this.r.exec("import quicktime.app.view.QTImageProducer");
            this.r.exec("import quicktime.io.OpenMovieFile");
            this.r.exec("import quicktime.qd.QDDimension");
            this.r.exec("import quicktime.std.StdQTConstants");
            this.r.exec("import quicktime.std.movies.TimeInfo");
            this.r.exec("import quicktime.std.movies.Track");
            this.r.exec("import quicktime.qd.QDGraphics");
            this.r.exec("import quicktime.qd.QDRect");
            this.r.exec("import quicktime.std.image.CSequence");
            this.r.exec("import quicktime.std.image.CodecComponent");
            this.r.exec("import quicktime.std.image.ImageDescription");
            this.r.exec("import quicktime.std.movies.media.VideoMedia");
            this.r.exec("import quicktime.util.QTHandle");
            this.r.exec("import quicktime.util.RawEncodedImage");
            this.r.exec("import quicktime.util.EndianOrder");
        }
        catch (ExceptionInInitializerError err) {
            SecurityException exc;
            this.noQT = true;
            Throwable t = err.getException();
            if (t instanceof SecurityException && (exc = (SecurityException)t).getMessage().indexOf("expired") >= 0) {
                this.expiredQT = true;
            }
        }
        catch (Throwable t) {
            this.noQT = true;
            if (FormatHandler.debug) {
                LogTools.trace(t);
            }
        }
        finally {
            block20: {
                if (needClose) {
                    try {
                        this.r.exec("QTSession.close()");
                    }
                    catch (Throwable t) {
                        if (!FormatHandler.debug) break block20;
                        LogTools.trace(t);
                    }
                }
            }
            this.initialized = true;
        }
    }

    public boolean canDoQT() {
        if (!this.initialized) {
            this.initClass();
        }
        return !this.noQT;
    }

    public boolean isQTExpired() {
        if (!this.initialized) {
            this.initClass();
        }
        return this.expiredQT;
    }

    public String getQTVersion() {
        if (this.isQTExpired()) {
            return "Expired";
        }
        if (!this.canDoQT()) {
            return "Missing";
        }
        try {
            String qtMajor = this.r.exec("QTSession.getMajorVersion()").toString();
            String qtMinor = this.r.exec("QTSession.getMinorVersion()").toString();
            return qtMajor + "." + qtMinor;
        }
        catch (Throwable t) {
            if (FormatHandler.debug) {
                LogTools.trace(t);
            }
            return "Error";
        }
    }

    public ReflectedUniverse getUniverse() {
        if (!this.initialized) {
            this.initClass();
        }
        return this.r;
    }

    public Dimension getPictDimensions(byte[] bytes) throws FormatException, ReflectException {
        if (this.isQTExpired()) {
            throw new FormatException(EXPIRED_QT_MSG);
        }
        if (!this.canDoQT()) {
            throw new FormatException(NO_QT_MSG);
        }
        try {
            this.r.exec("QTSession.open()");
            this.r.setVar("bytes", bytes);
            this.r.exec("pict = new Pict(bytes)");
            this.r.exec("box = pict.getPictFrame()");
            int width = (Integer)this.r.exec("box.getWidth()");
            int height = (Integer)this.r.exec("box.getHeight()");
            this.r.exec("QTSession.close()");
            return new Dimension(width, height);
        }
        catch (ReflectException e) {
            this.r.exec("QTSession.close()");
            throw new FormatException("PICT height determination failed", e);
        }
    }

    public synchronized Image pictToImage(byte[] bytes) throws FormatException {
        if (this.isQTExpired()) {
            throw new FormatException(EXPIRED_QT_MSG);
        }
        if (!this.canDoQT()) {
            throw new FormatException(NO_QT_MSG);
        }
        try {
            this.r.exec("QTSession.open()");
            this.r.setVar("bytes", bytes);
            this.r.exec("pict = new Pict(bytes)");
            this.r.exec("box = pict.getPictFrame()");
            int width = (Integer)this.r.exec("box.getWidth()");
            int height = (Integer)this.r.exec("box.getHeight()");
            this.r.exec("g = new QDGraphics(box)");
            this.r.exec("pict.draw(g, box)");
            this.r.exec("pixMap = g.getPixMap()");
            this.r.exec("rei = pixMap.getPixelData()");
            int rowBytes = (Integer)this.r.exec("pixMap.getRowBytes()");
            int intsPerRow = rowBytes / 4;
            int pixLen = intsPerRow * height;
            this.r.setVar("pixLen", pixLen);
            int[] pixels = new int[pixLen];
            this.r.setVar("pixels", pixels);
            this.r.setVar("zero", new Integer(0));
            this.r.exec("rei.copyToArray(zero, pixels, zero, pixLen)");
            int bitsPerSample = 32;
            int redMask = 0xFF0000;
            int greenMask = 65280;
            int blueMask = 255;
            int alphaMask = 0;
            DirectColorModel colorModel = new DirectColorModel(bitsPerSample, redMask, greenMask, blueMask, alphaMask);
            this.r.exec("QTSession.close()");
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, (ColorModel)colorModel, pixels, 0, intsPerRow));
        }
        catch (ReflectException e) {
            try {
                this.r.exec("QTSession.close()");
            }
            catch (ReflectException exc) {
                LogTools.trace(exc);
            }
            throw new FormatException("PICT extraction failed", e);
        }
    }
}

