/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.TiffRational;
import loci.formats.TiffTools;

public final class AWTTiffTools {
    public static long writeImage(byte[] buf, Hashtable ifd, RandomAccessOutputStream out, long offset, boolean last, boolean bigTiff, ColorModel colorModel, int pixelType, boolean interleaved) throws FormatException, IOException {
        boolean indexed;
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        TiffTools.debug("writeImage (offset=" + offset + "; last=" + last + ")");
        boolean little = TiffTools.isLittleEndian(ifd);
        int width = (int)TiffTools.getImageWidth(ifd);
        int height = (int)TiffTools.getImageLength(ifd);
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int plane = width * height * bytesPerPixel;
        int nChannels = buf.length / plane;
        boolean bl = indexed = colorModel != null && colorModel instanceof IndexColorModel;
        if (ifd == null) {
            ifd = new Hashtable();
        }
        TiffTools.putIFDValue(ifd, 256, width);
        TiffTools.putIFDValue(ifd, 257, height);
        if (TiffTools.getIFDValue(ifd, 258) == null) {
            int bps = 8 * bytesPerPixel;
            int[] bpsArray = new int[nChannels];
            Arrays.fill(bpsArray, bps);
            TiffTools.putIFDValue(ifd, 258, bpsArray);
        }
        if (FormatTools.isFloatingPoint(pixelType)) {
            TiffTools.putIFDValue(ifd, 339, 3);
        }
        if (TiffTools.getIFDValue(ifd, 259) == null) {
            TiffTools.putIFDValue(ifd, 259, 1);
        }
        if (TiffTools.getIFDValue(ifd, 262) == null) {
            int photometricInterpretation = indexed ? 3 : (nChannels == 1 ? 1 : 2);
            TiffTools.putIFDValue(ifd, 262, photometricInterpretation);
        }
        if (TiffTools.getIFDValue(ifd, 277) == null) {
            TiffTools.putIFDValue(ifd, 277, nChannels);
        }
        if (TiffTools.getIFDValue(ifd, 282) == null) {
            TiffTools.putIFDValue(ifd, 282, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 283) == null) {
            TiffTools.putIFDValue(ifd, 283, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 296) == null) {
            TiffTools.putIFDValue(ifd, 296, 1);
        }
        if (TiffTools.getIFDValue(ifd, 305) == null) {
            TiffTools.putIFDValue(ifd, 305, "LOCI Bio-Formats");
        }
        if (TiffTools.getIFDValue(ifd, 270) == null) {
            TiffTools.putIFDValue(ifd, 270, "");
        }
        if (indexed && TiffTools.getIFDValue(ifd, 320) == null) {
            byte[][] lut = new byte[3][256];
            IndexColorModel model = (IndexColorModel)colorModel;
            model.getReds(lut[0]);
            model.getGreens(lut[1]);
            model.getBlues(lut[2]);
            int[] colorMap = new int[768];
            for (int i = 0; i < lut.length; ++i) {
                for (int j = 0; j < lut[0].length; ++j) {
                    colorMap[i * lut[0].length + j] = (lut[i][j] & 0xFF) << 8;
                }
            }
            TiffTools.putIFDValue(ifd, 320, colorMap);
        }
        int compression = TiffTools.getIFDIntValue(ifd, 259, false, 1);
        boolean fullImageCompression = false;
        if (compression == 33003 || compression == 7) {
            fullImageCompression = true;
        }
        int pixels = fullImageCompression ? width * height : width;
        int stripSize = Math.max(8192, pixels * bytesPerPixel * nChannels);
        int rowsPerStrip = stripSize / (width * bytesPerPixel * nChannels);
        int stripsPerImage = (height + rowsPerStrip - 1) / rowsPerStrip;
        int[] bps = (int[])TiffTools.getIFDValue(ifd, 258, true, int[].class);
        ByteArrayOutputStream[] stripBuf = new ByteArrayOutputStream[stripsPerImage];
        DataOutputStream[] stripOut = new DataOutputStream[stripsPerImage];
        for (int i = 0; i < stripsPerImage; ++i) {
            stripBuf[i] = new ByteArrayOutputStream(stripSize);
            stripOut[i] = new DataOutputStream(stripBuf[i]);
        }
        for (int y = 0; y < height; ++y) {
            int strip = y / rowsPerStrip;
            for (int x = 0; x < width; ++x) {
                int ndx = y * width * bytesPerPixel + x * bytesPerPixel;
                for (int c = 0; c < nChannels; ++c) {
                    for (int n = 0; n < bps[c] / 8; ++n) {
                        int off = interleaved ? ndx * nChannels + c * bytesPerPixel + n : c * plane + ndx + n;
                        stripOut[strip].writeByte(buf[off]);
                    }
                }
            }
        }
        int planarConfig = TiffTools.getPlanarConfiguration(ifd);
        int predictor = TiffTools.getIFDIntValue(ifd, 317, false, 1);
        byte[][] strips = new byte[stripsPerImage][];
        for (int i = 0; i < stripsPerImage; ++i) {
            strips[i] = stripBuf[i].toByteArray();
            TiffTools.difference(strips[i], bps, width, planarConfig, predictor);
            strips[i] = TiffTools.compress(strips[i], ifd);
        }
        long[] stripByteCounts = new long[stripsPerImage];
        long[] stripOffsets = new long[stripsPerImage];
        TiffTools.putIFDValue(ifd, 273, stripOffsets);
        TiffTools.putIFDValue(ifd, 278, rowsPerStrip);
        TiffTools.putIFDValue(ifd, 279, stripByteCounts);
        Object[] keys = ifd.keySet().toArray();
        Arrays.sort(keys);
        int keyCount = keys.length;
        if (ifd.containsKey(new Integer(0))) {
            --keyCount;
        }
        if (ifd.containsKey(new Integer(1))) {
            --keyCount;
        }
        int bytesPerEntry = bigTiff ? 20 : 12;
        int ifdBytes = (bigTiff ? 16 : 6) + bytesPerEntry * keyCount;
        long pixelBytes = 0L;
        for (int i = 0; i < stripsPerImage; ++i) {
            stripByteCounts[i] = strips[i].length;
            stripOffsets[i] = pixelBytes + offset + (long)ifdBytes;
            pixelBytes += stripByteCounts[i];
        }
        ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(ifdBytes);
        DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
        ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
        DataOutputStream extraOut = new DataOutputStream(extraBuf);
        offset += (long)ifdBytes + pixelBytes;
        if (bigTiff) {
            DataTools.writeLong(ifdOut, keyCount, little);
        } else {
            DataTools.writeShort(ifdOut, keyCount, little);
        }
        for (int k = 0; k < keys.length; ++k) {
            Object key = keys[k];
            if (!(key instanceof Integer)) {
                throw new FormatException("Malformed IFD tag (" + key + ")");
            }
            if ((Integer)key == 0 || (Integer)key == 1) continue;
            Object value = ifd.get(key);
            String sk = TiffTools.getIFDTagName((Integer)key);
            String sv = value instanceof int[] ? "int[" + ((int[])value).length + "]" : value.toString();
            TiffTools.debug("writeImage: writing " + sk + " (value=" + sv + ")");
            TiffTools.writeIFDValue(ifdOut, extraBuf, extraOut, offset, (Integer)key, value, bigTiff, little);
        }
        if (bigTiff) {
            DataTools.writeLong(ifdOut, last ? 0L : offset + (long)extraBuf.size(), little);
        } else {
            DataTools.writeInt(ifdOut, last ? 0 : (int)(offset + (long)extraBuf.size()), little);
        }
        byte[] ifdArray = ifdBuf.toByteArray();
        byte[] extraArray = extraBuf.toByteArray();
        long numBytes = ifdArray.length + extraArray.length;
        out.write(ifdArray);
        for (int i = 0; i < strips.length; ++i) {
            out.write(strips[i]);
            numBytes += (long)strips[i].length;
        }
        out.write(extraArray);
        return numBytes;
    }
}

