/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import loci.common.LogTools;
import loci.formats.cache.Cache;
import loci.formats.cache.CacheException;

public class CacheUpdater
extends Thread {
    private Cache cache;
    private boolean quit;

    public CacheUpdater(Cache cache) {
        super("Bio-Formats-Cache-Updater");
        this.setPriority(1);
        this.cache = cache;
        this.quit = false;
    }

    public void quit() {
        this.quit = true;
        try {
            this.join();
        }
        catch (InterruptedException exc) {
            LogTools.trace(exc);
        }
    }

    public void run() {
        int length = 0;
        try {
            length = this.cache.getStrategy().getLoadList(this.cache.getCurrentPos()).length;
            for (int i = 0; i < length && !this.quit; ++i) {
                this.cache.recache(i);
            }
        }
        catch (CacheException e) {
            LogTools.trace(e);
        }
    }
}

