/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.bufr.Descriptor;

final class BufrTables {
    private static final Pattern comment = Pattern.compile("^#");
    private static final Pattern category = Pattern.compile("^\\s*(\\d+)\\s+(.*)");
    private static final Pattern descriptor = Pattern.compile("^\\s+(\\d+);\\s+(\\d+);\\s+(\\d+);\\s+(-?\\d+);\\s+(-?\\d+);\\s+(\\d+);\\s+(.*);\\s+(.*)\\s*$");
    private static final Pattern threeInts = Pattern.compile("^\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)");
    private static final Pattern negOne = Pattern.compile("^\\s*-1");
    private static final boolean debugTable = false;
    public static final HashMap tablesA = new HashMap();
    public static final HashMap tablesB = new HashMap();
    public static final HashMap tablesD = new HashMap();
    private static final String RESOURCE_PATH = "resources/bufr/tables/";

    private BufrTables() {
    }

    private static InputStream open(String location) throws IOException {
        String tmp;
        InputStream ios = null;
        ClassLoader cl = BufrTables.class.getClassLoader();
        ios = cl.getResourceAsStream(tmp = RESOURCE_PATH + location);
        if (ios != null) {
            return ios;
        }
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return ios;
    }

    public static void readTableA(String tablename) throws IOException {
        String line;
        if (tablesA.containsKey(tablename)) {
            return;
        }
        InputStream ios = BufrTables.open(tablename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        HashMap<String, String> categories = new HashMap<String, String>();
        while ((line = dataIS.readLine()) != null) {
            Matcher m = comment.matcher(line);
            if (m.find() || !(m = category.matcher(line)).find() || m.group(2).equals("RESERVED")) continue;
            String cat = m.group(2).trim();
            categories.put(m.group(1), cat);
        }
        dataIS.close();
        tablesA.put(tablename, categories);
    }

    public static void readTableB(String tablename) throws IOException {
        String line;
        if (tablesB.containsKey(tablename)) {
            return;
        }
        InputStream ios = BufrTables.open(tablename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        HashMap<String, Descriptor> descriptors = new HashMap<String, Descriptor>();
        Descriptor d = new Descriptor("0-4-250", "0", "0", "0", "Numeric", "time observation");
        descriptors.put(d.getKey(), d);
        d = new Descriptor("0-0-7", "0", "0", "0", "CCITT_IA5", "bogus entry no width");
        descriptors.put(d.getKey(), d);
        d = new Descriptor("0-21-192", "0", "0", "7", "dB", "Spectral peak power 0th moment");
        descriptors.put(d.getKey(), d);
        d = new Descriptor("0-63-255", "0", "0", "1", "Numeric", "bit pad");
        descriptors.put(d.getKey(), d);
        while ((line = dataIS.readLine()) != null) {
            Matcher m = comment.matcher(line);
            if (m.find() || !(m = descriptor.matcher(line)).find()) continue;
            String f = m.group(1);
            String x = m.group(2);
            String y = m.group(3);
            String scale = m.group(4);
            String refVal = m.group(5);
            String width = m.group(6);
            String units = m.group(7);
            String name = m.group(8);
            String key = f + "-" + x + "-" + y;
            d = new Descriptor(key, scale, refVal, width, units, name);
            descriptors.put(d.getKey(), d);
        }
        dataIS.close();
        tablesB.put(tablename, descriptors);
    }

    public static void readTableD(String tablename) throws IOException {
        String line;
        if (tablesD.containsKey(tablename)) {
            return;
        }
        InputStream ios = BufrTables.open(tablename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        HashMap sequences = new HashMap();
        block0: while ((line = dataIS.readLine()) != null) {
            Matcher m = comment.matcher(line);
            if (m.find() || !(m = threeInts.matcher(line)).find()) continue;
            String key = m.group(1) + "-" + m.group(2) + "-" + m.group(3);
            ArrayList<String> al = new ArrayList<String>();
            while ((line = dataIS.readLine()) != null) {
                m = comment.matcher(line);
                if (m.find()) continue;
                m = threeInts.matcher(line);
                if (m.find()) {
                    String dkey = m.group(1) + "-" + m.group(2) + "-" + m.group(3);
                    al.add(dkey);
                    continue;
                }
                m = negOne.matcher(line);
                if (!m.find()) continue;
                sequences.put(key, al);
                continue block0;
            }
        }
        dataIS.close();
        tablesD.put(tablename, sequences);
    }

    public static void main(String[] args) throws IOException {
        BufrTables bt = new BufrTables();
        String tableName = args.length == 1 ? args[0] : "B3M-000-009";
        BufrTables.readTableA(tableName + "-A");
        BufrTables.readTableB(tableName + "-B");
        BufrTables.readTableD(tableName + "-D");
        HashMap tableB = (HashMap)tablesB.get(tableName + "-B");
        String dKey = "0-2-25";
        Descriptor d = (Descriptor)tableB.get(dKey);
        System.out.println("Descriptor key =" + d.getKey() + " name =" + d.getName() + "\n\t\tdescription =" + d.getDescription());
        HashMap tableD = (HashMap)tablesD.get(tableName + "-D");
        dKey = "3-4-11";
        System.out.println("descriptors of key " + dKey);
        ArrayList al = (ArrayList)tableD.get(dKey);
        System.out.println("list =" + al);
        for (int i = 10000; i < al.size(); ++i) {
            String key = (String)al.get(i);
            System.out.println("Descriptor =" + key);
            d = (Descriptor)tableB.get(key);
            System.out.println("Descriptor key =" + d.getKey() + " name =" + d.getName() + "\n\t\tdescription =" + d.getDescription());
        }
    }
}

