/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.HexDump;
import loci.poi.util.LittleEndian;

public class PaneRecord
extends Record {
    public static final short sid = 65;
    private short field_1_x;
    private short field_2_y;
    private short field_3_topRow;
    private short field_4_leftColumn;
    private short field_5_activePane;
    public static final short ACTIVE_PANE_LOWER_RIGHT = 0;
    public static final short ACTIVE_PANE_UPPER_RIGHT = 1;
    public static final short ACTIVE_PANE_LOWER_LEFT = 2;
    public static final short ACTIVE_PANE_UPER_LEFT = 3;

    public PaneRecord() {
    }

    public PaneRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 65) {
            throw new RecordFormatException("Not a Pane record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_x = in.readShort();
        this.field_2_y = in.readShort();
        this.field_3_topRow = in.readShort();
        this.field_4_leftColumn = in.readShort();
        this.field_5_activePane = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PANE]\n");
        buffer.append("    .x                    = ").append("0x").append(HexDump.toHex(this.getX())).append(" (").append(this.getX()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .y                    = ").append("0x").append(HexDump.toHex(this.getY())).append(" (").append(this.getY()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .topRow               = ").append("0x").append(HexDump.toHex(this.getTopRow())).append(" (").append(this.getTopRow()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .leftColumn           = ").append("0x").append(HexDump.toHex(this.getLeftColumn())).append(" (").append(this.getLeftColumn()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .activePane           = ").append("0x").append(HexDump.toHex(this.getActivePane())).append(" (").append(this.getActivePane()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/PANE]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)65);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_x);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_y);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_3_topRow);
        LittleEndian.putShort(data, 10 + offset + pos, this.field_4_leftColumn);
        LittleEndian.putShort(data, 12 + offset + pos, this.field_5_activePane);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 14;
    }

    public short getSid() {
        return 65;
    }

    public Object clone() {
        PaneRecord rec = new PaneRecord();
        rec.field_1_x = this.field_1_x;
        rec.field_2_y = this.field_2_y;
        rec.field_3_topRow = this.field_3_topRow;
        rec.field_4_leftColumn = this.field_4_leftColumn;
        rec.field_5_activePane = this.field_5_activePane;
        return rec;
    }

    public short getX() {
        return this.field_1_x;
    }

    public void setX(short field_1_x) {
        this.field_1_x = field_1_x;
    }

    public short getY() {
        return this.field_2_y;
    }

    public void setY(short field_2_y) {
        this.field_2_y = field_2_y;
    }

    public short getTopRow() {
        return this.field_3_topRow;
    }

    public void setTopRow(short field_3_topRow) {
        this.field_3_topRow = field_3_topRow;
    }

    public short getLeftColumn() {
        return this.field_4_leftColumn;
    }

    public void setLeftColumn(short field_4_leftColumn) {
        this.field_4_leftColumn = field_4_leftColumn;
    }

    public short getActivePane() {
        return this.field_5_activePane;
    }

    public void setActivePane(short field_5_activePane) {
        this.field_5_activePane = field_5_activePane;
    }
}

