/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.PackbitsCodec;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.LegacyQTTools;
import loci.formats.meta.FilterMetadata;

public class PictReader
extends FormatReader {
    private static final int PICT_CLIP_RGN = 1;
    private static final int PICT_BITSRECT = 144;
    private static final int PICT_BITSRGN = 145;
    private static final int PICT_PACKBITSRECT = 152;
    private static final int PICT_PACKBITSRGN = 153;
    private static final int PICT_9A = 154;
    private static final int PICT_END = 255;
    private static final int PICT_LONGCOMMENT = 161;
    private static final byte[] EXPANSION_TABLE = new byte[2048];
    protected int rowBytes;
    protected Vector strips;
    protected boolean versionOne;
    protected byte[][] lookup;
    protected LegacyQTTools qtTools = new LegacyQTTools();
    private boolean legacy = false;

    public PictReader() {
        super("PICT", new String[]{"pict", "pct"});
        this.blockCheckLen = 528;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lookup;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.legacy || this.strips.size() == 0) {
            this.in.seek(512L);
            byte[] pix = new byte[(int)(this.in.length() - this.in.getFilePointer())];
            this.in.read(pix);
            byte[][] b = AWTImageTools.getPixelBytes(AWTImageTools.makeBuffered(this.qtTools.pictToImage(pix)), this.isLittleEndian());
            pix = null;
            for (int i = 0; i < b.length; ++i) {
                System.arraycopy(b[i], 0, buf, i * b[i].length, b[i].length);
            }
            b = null;
            return buf;
        }
        if (this.getSizeY() * 4 < this.strips.size() && this.strips.size() / 3 % this.getSizeY() != 0) {
            this.core[0].sizeY = this.strips.size();
        }
        int plane = this.getSizeX() * this.getSizeY();
        if (this.lookup != null) {
            for (int i = y; i < y + h; ++i) {
                byte[] row = (byte[])this.strips.get(i);
                int len = Math.min(row.length, w);
                System.arraycopy(row, x, buf, (i - y) * w, len);
            }
        } else if (this.getSizeY() * 3 == this.strips.size() || this.getSizeY() * 4 == this.strips.size()) {
            int nc = this.strips.size() / this.getSizeY();
            byte[] c0 = null;
            byte[] c1 = null;
            byte[] c2 = null;
            for (int i = 0; i < this.getSizeY(); ++i) {
                c0 = (byte[])this.strips.get(i * nc + nc - 3);
                c1 = (byte[])this.strips.get(i * nc + nc - 2);
                c2 = (byte[])this.strips.get(i * nc + nc - 1);
                int baseOffset = i * this.getSizeX();
                System.arraycopy(c0, 0, buf, baseOffset, this.getSizeX());
                System.arraycopy(c1, 0, buf, plane + baseOffset, this.getSizeX());
                System.arraycopy(c2, 0, buf, 2 * plane + baseOffset, this.getSizeX());
            }
        } else {
            int[] row = null;
            for (int i = 0; i < this.getSizeY(); ++i) {
                row = (int[])this.strips.get(i);
                for (int j = 0; j < row.length; ++j) {
                    int base = i * row.length + j;
                    buf[base] = (byte)((row[j] & 0x7C00) >> 10);
                    buf[plane + base] = (byte)((row[j] & 0x3E0) >> 5);
                    buf[2 * plane + base] = (byte)(row[j] & 0x1F);
                }
            }
        }
        return buf;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return FormatTools.validStream(stream, this.blockCheckLen, false);
    }

    public void close() throws IOException {
        super.close();
        this.rowBytes = 0;
        this.strips = null;
        this.versionOne = false;
        this.lookup = null;
        this.legacy = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int opcode;
        this.debug("PictReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Populating metadata");
        this.core[0].littleEndian = false;
        this.in.seek(518L);
        this.core[0].sizeY = this.in.readShort();
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].imageCount = 1;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        this.core[0].interleaved = false;
        this.core[0].pixelType = 1;
        this.strips = new Vector();
        this.rowBytes = 0;
        this.versionOne = false;
        this.lookup = null;
        int verOpcode = this.in.read();
        int verNumber = this.in.read();
        if (verOpcode == 17 && verNumber == 1) {
            this.versionOne = true;
        } else if (verOpcode == 0 && verNumber == 17) {
            this.versionOne = false;
            short verNumber2 = this.in.readShort();
            if (verNumber2 != 767) {
                throw new FormatException("Invalid PICT file : " + verNumber2);
            }
            this.in.skipBytes(6);
            int pixelsPerInchX = this.in.readInt();
            int pixelsPerInchY = this.in.readInt();
            this.in.skipBytes(12);
        } else {
            throw new FormatException("Invalid PICT file");
        }
        do {
            if (this.versionOne) {
                opcode = this.in.read();
                continue;
            }
            if ((this.in.getFilePointer() & 1L) != 0L) {
                this.in.skipBytes(1);
            }
            opcode = this.in.readShort();
        } while (this.drivePictDecoder(opcode));
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].indexed = !this.isRGB() && this.lookup != null;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }

    private boolean drivePictDecoder(int opcode) throws FormatException, IOException {
        this.debug("drivePictDecoder(" + opcode + ") @ " + this.in.getFilePointer());
        switch (opcode) {
            case 144: 
            case 145: 
            case 152: 
            case 153: {
                this.rowBytes = this.in.readShort();
                if (this.versionOne || (this.rowBytes & 0x8000) == 0) {
                    this.handleBitmap(opcode);
                    break;
                }
                this.handlePixmap(opcode);
                break;
            }
            case 154: {
                this.handlePixmap(opcode);
                break;
            }
            case 1: {
                short x = this.in.readShort();
                this.in.skipBytes(x - 2);
                break;
            }
            case 161: {
                this.in.skipBytes(2);
                short x = this.in.readShort();
                this.in.skipBytes(x);
                break;
            }
            case 255: {
                return false;
            }
            default: {
                if (opcode >= 0) break;
                throw new FormatException("Invalid opcode: " + opcode);
            }
        }
        return this.in.getFilePointer() < this.in.length();
    }

    private void readImageHeader(int opcode) throws IOException {
        if (opcode == 154) {
            this.in.skipBytes(6);
        } else {
            this.rowBytes &= 0x3FFF;
        }
        short tlY = this.in.readShort();
        short tlX = this.in.readShort();
        short brY = this.in.readShort();
        short brX = this.in.readShort();
        this.core[0].sizeX = brX - tlX;
        this.core[0].sizeY = brY - tlY;
        this.in.skipBytes(18);
    }

    private void handleBitmap(int opcode) throws FormatException, IOException {
        this.readImageHeader(opcode);
        this.handlePixmap(this.rowBytes, 1, 1);
    }

    private void handlePixmap(int opcode) throws FormatException, IOException {
        short compCount;
        short pixelSize;
        block7: {
            block6: {
                this.readImageHeader(opcode);
                this.debug("handlePixmap(" + opcode + ")");
                pixelSize = this.in.readShort();
                compCount = this.in.readShort();
                this.in.skipBytes(14);
                if (opcode != 154) break block6;
                switch (pixelSize) {
                    case 32: {
                        this.rowBytes = this.getSizeX() * compCount;
                        break block7;
                    }
                    case 16: {
                        this.rowBytes = this.getSizeX() * 2;
                        break block7;
                    }
                    default: {
                        throw new FormatException("Sorry, vector data not supported.");
                    }
                }
            }
            this.in.skipBytes(4);
            short flags = this.in.readShort();
            int count = this.in.readShort();
            this.lookup = new byte[3][++count];
            for (int i = 0; i < count; ++i) {
                this.in.skipBytes(2);
                this.lookup[0][i] = this.in.readByte();
                this.in.skipBytes(1);
                this.lookup[1][i] = this.in.readByte();
                this.in.skipBytes(1);
                this.lookup[2][i] = this.in.readByte();
                this.in.skipBytes(1);
            }
        }
        this.in.skipBytes(18);
        if (opcode == 145 || opcode == 153) {
            this.in.skipBytes(2);
        }
        this.handlePixmap(this.rowBytes, pixelSize, compCount);
    }

    private void handlePixmap(int rBytes, int pixelSize, int compCount) throws FormatException, IOException {
        this.debug("handlePixmap(" + rBytes + ", " + pixelSize + ", " + compCount + ")");
        byte[] uBuf = null;
        int[] uBufI = null;
        byte[] outBuf = null;
        boolean compressed = rBytes >= 8 || pixelSize == 32;
        int bufSize = rBytes;
        int outBufSize = this.getSizeX();
        switch (pixelSize) {
            case 32: {
                if (!compressed) {
                    uBufI = new int[this.getSizeX()];
                    break;
                }
                uBuf = new byte[bufSize];
                break;
            }
            case 16: {
                uBufI = new int[this.getSizeX()];
                break;
            }
            case 8: {
                uBuf = new byte[bufSize];
                break;
            }
            default: {
                outBuf = new byte[outBufSize];
                uBuf = new byte[bufSize];
            }
        }
        if (!compressed) {
            this.debug("Pixel data is uncompressed (pixelSize=" + pixelSize + ").");
            byte[] buf = new byte[bufSize];
            block9: for (int row = 0; row < this.getSizeY(); ++row) {
                this.in.read(buf, 0, rBytes);
                switch (pixelSize) {
                    case 16: {
                        for (int i = 0; i < this.getSizeX(); ++i) {
                            uBufI[i] = DataTools.bytesToShort(buf, i * 2, 2, false);
                        }
                        this.strips.add(uBufI);
                        buf = null;
                        this.core[0].sizeC = 3;
                        continue block9;
                    }
                    case 8: {
                        this.strips.add(buf);
                        continue block9;
                    }
                    default: {
                        this.expandPixels(pixelSize, buf, outBuf, outBuf.length);
                        this.strips.add(outBuf);
                        buf = null;
                    }
                }
            }
        } else {
            this.debug("Pixel data is compressed (pixelSize=" + pixelSize + "; compCount=" + compCount + ").");
            byte[] buf = new byte[bufSize + 1 + bufSize / 128];
            for (int row = 0; row < this.getSizeY(); ++row) {
                int rawLen = rBytes > 250 ? this.in.readShort() : this.in.read();
                if (rawLen > buf.length) {
                    rawLen = buf.length;
                }
                if (this.in.length() - this.in.getFilePointer() <= (long)rawLen) {
                    rawLen = (int)(this.in.length() - this.in.getFilePointer() - 1L);
                }
                if (rawLen < 0) {
                    rawLen = 0;
                    this.in.seek(this.in.length() - 1L);
                }
                this.in.read(buf, 0, rawLen);
                if (pixelSize == 16) {
                    uBufI = new int[this.getSizeX()];
                    this.unpackBits(buf, uBufI);
                    this.strips.add(uBufI);
                    this.core[0].sizeC = 3;
                } else {
                    PackbitsCodec c = new PackbitsCodec();
                    CodecOptions options = new CodecOptions();
                    options.maxBytes = this.getSizeX() * 4;
                    uBuf = c.decompress(buf, options);
                }
                if (pixelSize < 8) {
                    this.expandPixels(pixelSize, uBuf, outBuf, outBuf.length);
                    this.strips.add(outBuf);
                    continue;
                }
                if (pixelSize == 8) {
                    this.strips.add(uBuf);
                    continue;
                }
                if (pixelSize != 24 && pixelSize != 32) continue;
                byte[] newBuf = null;
                for (int q = 0; q < compCount; ++q) {
                    int offset = q * this.getSizeX();
                    int len = Math.min(this.getSizeX(), uBuf.length - offset);
                    newBuf = new byte[this.getSizeX()];
                    if (offset < uBuf.length) {
                        System.arraycopy(uBuf, offset, newBuf, 0, len);
                    }
                    this.strips.add(newBuf);
                }
                this.core[0].sizeC = 3;
            }
        }
    }

    private void expandPixels(int bitSize, byte[] ib, byte[] ob, int outLen) throws FormatException {
        this.debug("expandPixels(" + bitSize + ", " + ib.length + ", " + ob.length + ", " + outLen + ")");
        if (bitSize == 1) {
            int remainder = outLen % 8;
            int max = outLen / 8;
            for (int i = 0; i < max; ++i) {
                if (i < ib.length) {
                    int look = (ib[i] & 0xFF) * 8;
                    System.arraycopy(EXPANSION_TABLE, look, ob, i * 8, 8);
                    continue;
                }
                i = max;
            }
            if (remainder != 0 && max < ib.length) {
                System.arraycopy(EXPANSION_TABLE, (ib[max] & 0xFF) * 8, ob, max * 8, remainder);
            }
            return;
        }
        int count = 8 / bitSize;
        int maskshift = bitSize;
        int pixelshift = 8 - bitSize;
        int tpixelshift = 0;
        int pixelshiftdelta = bitSize;
        if (bitSize != 1 && bitSize != 2 && bitSize != 4) {
            throw new FormatException("Can only expand 1, 2, and 4 bit values");
        }
        int mask = (int)Math.pow(2.0, bitSize) - 1 << 8 - bitSize;
        int i = 0;
        int o = 0;
        while (o < ob.length) {
            int tmask = mask;
            tpixelshift = pixelshift;
            byte v = ib[i];
            for (int t = 0; t < count && o < ob.length; ++t, ++o) {
                ob[o] = (byte)((v & tmask) >>> tpixelshift & 0xFF);
                tmask = (byte)((tmask & 0xFF) >>> maskshift);
                tpixelshift -= pixelshiftdelta;
            }
            ++i;
        }
    }

    private void unpackBits(byte[] ib, int[] ob) {
        this.debug("unpackBits(" + ib + ", " + ob + ")");
        int i = 0;
        int o = 0;
        while (o < ob.length) {
            if (i + 1 < ib.length) {
                int end;
                byte b;
                if ((b = ib[i++]) >= 0) {
                    end = o + b + 1;
                    while (o < end && o < ob.length && i + 1 < ib.length) {
                        ob[o++] = DataTools.bytesToShort(ib, i, 2, false);
                        i += 2;
                    }
                    continue;
                }
                if (b == -128) continue;
                short rep = DataTools.bytesToShort(ib, i, 2, false);
                i += 2;
                end = o - b + 1;
                while (o < end && o < ob.length) {
                    ob[o++] = rep;
                }
                continue;
            }
            o = ob.length;
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                PictReader.EXPANSION_TABLE[i * 8 + j] = (byte)((i & (int)Math.pow(2.0, 7 - j)) >> 7 - j);
            }
        }
    }
}

