/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.LeicaHandler;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.helpers.DefaultHandler;

public class LIFReader
extends FormatReader {
    private static final Hashtable CHANNEL_PRIORITIES = LIFReader.createChannelPriorities();
    private static final byte[][][] BYTE_LUTS = LIFReader.createByteLUTs();
    private static final short[][][] SHORT_LUTS = LIFReader.createShortLUTs();
    private Vector offsets;
    private int[] bitsPerPixel;
    private int[] extraDimensions;
    private int numDatasets;
    private int[][] channelMap;
    private int[][] realChannel;
    private int lastChannel = -1;

    private static Hashtable createChannelPriorities() {
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        h.put("red", new Integer(0));
        h.put("green", new Integer(1));
        h.put("blue", new Integer(2));
        h.put("cyan", new Integer(3));
        h.put("magenta", new Integer(4));
        h.put("yellow", new Integer(5));
        h.put("black", new Integer(6));
        h.put("gray", new Integer(7));
        h.put("", new Integer(8));
        return h;
    }

    private static byte[][][] createByteLUTs() {
        byte[][][] lut = new byte[6][3][256];
        for (int i = 0; i < 256; ++i) {
            lut[0][0][i] = (byte)(i & 0xFF);
            lut[1][1][i] = (byte)(i & 0xFF);
            lut[2][2][i] = (byte)(i & 0xFF);
            lut[3][1][i] = (byte)(i & 0xFF);
            lut[3][2][i] = (byte)(i & 0xFF);
            lut[4][0][i] = (byte)(i & 0xFF);
            lut[4][2][i] = (byte)(i & 0xFF);
            lut[5][0][i] = (byte)(i & 0xFF);
            lut[5][1][i] = (byte)(i & 0xFF);
        }
        return lut;
    }

    private static short[][][] createShortLUTs() {
        short[][][] lut = new short[6][3][65536];
        for (int i = 0; i < 65536; ++i) {
            lut[0][0][i] = (short)(i & 0xFFFF);
            lut[1][1][i] = (short)(i & 0xFFFF);
            lut[2][2][i] = (short)(i & 0xFFFF);
            lut[3][1][i] = (short)(i & 0xFFFF);
            lut[3][2][i] = (short)(i & 0xFFFF);
            lut[4][0][i] = (short)(i & 0xFFFF);
            lut[4][2][i] = (short)(i & 0xFFFF);
            lut[5][0][i] = (short)(i & 0xFFFF);
            lut[5][1][i] = (short)(i & 0xFFFF);
        }
        return lut;
    }

    public LIFReader() {
        super("Leica Image File Format", "lif");
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return stream.read() == 112;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || this.lastChannel == -1) {
            return null;
        }
        return this.lastChannel < BYTE_LUTS.length ? BYTE_LUTS[this.lastChannel] : (byte[][])null;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 3 || this.lastChannel == -1) {
            return null;
        }
        return this.lastChannel < SHORT_LUTS.length ? SHORT_LUTS[this.lastChannel] : (short[][])null;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (!this.isRGB()) {
            int[] pos = this.getZCTCoords(no);
            this.lastChannel = this.realChannel[this.series][pos[1]];
        }
        long offset = (Long)this.offsets.get(this.series);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int bpp = bytes * this.getRGBChannelCount();
        long nextOffset = this.series + 1 < this.offsets.size() ? ((Long)this.offsets.get(this.series + 1)).longValue() : this.in.length();
        int bytesToSkip = (int)(nextOffset - offset - (long)(bpp * this.getSizeX() * this.getSizeY() * this.getImageCount()));
        bytesToSkip /= this.getSizeY();
        if (this.getSizeX() % 4 == 0) {
            bytesToSkip = 0;
        }
        this.in.seek(offset + (long)(this.getSizeX() * this.getSizeY()) * (long)no * (long)bpp);
        this.in.skipBytes(bytesToSkip * this.getSizeY() * no);
        if (bytesToSkip == 0) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.in.skipBytes(y * this.getSizeX() * bpp + y * bytesToSkip);
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * bpp);
                this.in.read(buf, row * w * bpp, w * bpp);
                this.in.skipBytes(bpp * (this.getSizeX() - w - x) + bytesToSkip);
            }
        }
        if (this.getRGBChannelCount() == 3) {
            for (int i = 0; i < buf.length; i += bpp) {
                for (int b = 0; b < bytes; ++b) {
                    byte tmp = buf[i + b];
                    buf[i + b] = buf[i + bytes * 2];
                    buf[i + bytes * 2] = tmp;
                }
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.offsets = null;
        this.bitsPerPixel = null;
        this.extraDimensions = null;
        this.numDatasets = -1;
        this.channelMap = null;
        this.realChannel = null;
        this.lastChannel = -1;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("LIFReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.offsets = new Vector();
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.status("Reading header");
        byte checkOne = (byte)this.in.read();
        this.in.skipBytes(2);
        byte checkTwo = (byte)this.in.read();
        if (checkOne != 112 && checkTwo != 112) {
            throw new FormatException(id + " is not a valid Leica LIF file");
        }
        this.in.skipBytes(4);
        if (this.in.read() != 42) {
            throw new FormatException("Invalid XML description");
        }
        int nc = this.in.readInt();
        String xml = DataTools.stripString(this.in.readString(nc * 2));
        this.status("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            if (this.in.readInt() != 112) {
                throw new FormatException("Invalid Memory Block");
            }
            this.in.skipBytes(4);
            if (this.in.read() != 42) {
                throw new FormatException("Invalid Memory Description");
            }
            long blockLength = this.in.readInt();
            if (this.in.read() != 42) {
                this.in.seek(this.in.getFilePointer() - 5L);
                blockLength = this.in.readLong();
                if (this.in.read() != 42) {
                    throw new FormatException("Invalid Memory Description");
                }
            }
            int descrLength = this.in.readInt();
            this.in.skipBytes(descrLength * 2);
            if (blockLength > 0L) {
                this.offsets.add(new Long(this.in.getFilePointer()));
            }
            long skipped = 0L;
            while (skipped < blockLength) {
                if (blockLength - skipped > 4096L) {
                    skipped += (long)this.in.skipBytes(4096);
                    continue;
                }
                skipped += (long)this.in.skipBytes((int)(blockLength - skipped));
            }
        }
        this.initMetadata(xml);
    }

    private void initMetadata(String xml) throws FormatException, IOException {
        int i;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        LeicaHandler handler = new LeicaHandler(new DummyMetadata());
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>" + xml + "</LEICA>";
        xml = DataTools.sanitizeXML(xml);
        DataTools.parseXML(xml, (DefaultHandler)handler);
        Vector widths = handler.getWidths();
        Vector heights = handler.getHeights();
        Vector zs = handler.getZs();
        Vector ts = handler.getTs();
        Vector channels = handler.getChannels();
        Vector bps = handler.getBPS();
        Vector extraDims = handler.getExtraDims();
        this.metadata = handler.getGlobalMetadata();
        Vector containerNames = handler.getContainerNames();
        Vector containerCounts = handler.getContainerCounts();
        Vector seriesNames = handler.getSeriesNames();
        Vector xcal = handler.getXCal();
        Vector ycal = handler.getYCal();
        Vector zcal = handler.getZCal();
        Vector bits = handler.getBits();
        Vector lutNames = handler.getLutNames();
        Vector stageX = handler.getXPosition();
        Vector stageY = handler.getYPosition();
        Vector stageZ = handler.getZPosition();
        Hashtable timestamps = handler.getTimestamps();
        Vector<Hashtable> seriesMetadata = handler.getMetadata();
        this.numDatasets = widths.size();
        this.bitsPerPixel = new int[this.numDatasets];
        this.extraDimensions = new int[this.numDatasets];
        this.channelMap = new int[this.numDatasets][];
        this.realChannel = new int[this.numDatasets][];
        int nextLut = 0;
        for (i = 0; i < this.channelMap.length; ++i) {
            int q;
            int q2;
            this.channelMap[i] = new int[((Integer)channels.get(i)).intValue()];
            this.realChannel[i] = new int[((Integer)channels.get(i)).intValue()];
            String[] luts = new String[this.channelMap[i].length];
            for (q2 = 0; q2 < luts.length; ++q2) {
                luts[q2] = ((String)lutNames.get(nextLut++)).toLowerCase();
            }
            for (q2 = 0; q2 < this.channelMap[i].length; ++q2) {
                if (!CHANNEL_PRIORITIES.containsKey(luts[q2])) {
                    luts[q2] = "";
                }
                this.realChannel[i][q2] = (Integer)CHANNEL_PRIORITIES.get(luts[q2]);
            }
            int[] sorted = new int[this.channelMap[i].length];
            Arrays.fill(sorted, -1);
            for (q = 0; q < sorted.length; ++q) {
                int min = Integer.MAX_VALUE;
                int minIndex = -1;
                for (int n = 0; n < this.channelMap[i].length; ++n) {
                    if (this.realChannel[i][n] >= min || DataTools.containsValue(sorted, n)) continue;
                    min = this.realChannel[i][n];
                    minIndex = n;
                }
                sorted[q] = minIndex;
            }
            for (q = 0; q < this.channelMap[i].length; ++q) {
                this.channelMap[i][sorted[q]] = q;
            }
        }
        this.status("Populating metadata");
        this.core = new CoreMetadata[this.numDatasets];
        for (i = 0; i < this.numDatasets; ++i) {
            this.core[i] = new CoreMetadata();
            this.core[i].orderCertain = true;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].sizeX = (Integer)widths.get(i);
            this.core[i].sizeY = (Integer)heights.get(i);
            this.core[i].sizeZ = (Integer)zs.get(i);
            this.core[i].sizeC = (Integer)channels.get(i);
            this.core[i].sizeT = (Integer)ts.get(i);
            this.bitsPerPixel[i] = (Integer)bps.get(i);
            this.extraDimensions[i] = (Integer)extraDims.get(i);
            if (this.extraDimensions[i] > 1) {
                if (this.core[i].sizeZ == 1) {
                    this.core[i].sizeZ = this.extraDimensions[i];
                } else {
                    this.core[i].sizeT *= this.extraDimensions[i];
                }
                this.extraDimensions[i] = 1;
            }
            int nBits = (Integer)bits.get(i);
            this.core[i].metadataComplete = true;
            this.core[i].littleEndian = true;
            this.core[i].rgb = nBits == this.bitsPerPixel[i] * this.core[i].sizeC && this.core[i].sizeC > 1;
            this.core[i].interleaved = this.core[i].rgb;
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeT;
            if (!this.core[i].rgb) {
                this.core[i].imageCount *= this.core[i].sizeC;
            }
            this.core[i].indexed = this.realChannel[i][0] < BYTE_LUTS.length || this.realChannel[i][0] < SHORT_LUTS.length;
            this.core[i].falseColor = true;
            while (this.bitsPerPixel[i] % 8 != 0) {
                int n = i;
                this.bitsPerPixel[n] = this.bitsPerPixel[n] + 1;
            }
            switch (this.bitsPerPixel[i]) {
                case 8: {
                    this.core[i].pixelType = 1;
                    break;
                }
                case 16: {
                    this.core[i].pixelType = 3;
                    break;
                }
                case 32: {
                    this.core[i].pixelType = 6;
                }
            }
            this.core[i].seriesMetadata = seriesMetadata.get(i);
        }
        MetadataTools.populatePixels(store, this, true);
        store.setInstrumentID("Instrument:0", 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        store.setObjectiveCorrection("Unknown", 0, 0);
        for (i = 0; i < this.numDatasets; ++i) {
            int q;
            this.setSeries(i);
            Float xf = i < xcal.size() ? (Float)xcal.get(i) : null;
            Float yf = i < ycal.size() ? (Float)ycal.get(i) : null;
            Float zf = i < zcal.size() ? (Float)zcal.get(i) : null;
            store.setDimensionsPhysicalSizeX(xf, i, 0);
            store.setDimensionsPhysicalSizeY(yf, i, 0);
            store.setDimensionsPhysicalSizeZ(zf, i, 0);
            String seriesName = (String)seriesNames.get(i);
            if (seriesName == null || seriesName.trim().length() == 0) {
                seriesName = "Series " + (i + 1);
            }
            store.setImageName(seriesName, i);
            MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), i);
            boolean timestampPerPlane = timestamps.get("Series " + i + " Plane " + (this.getImageCount() - 1)) != null;
            for (int plane = 0; plane < this.getImageCount(); ++plane) {
                int[] coords = this.getZCTCoords(plane);
                int index = -1;
                if (timestampPerPlane) {
                    index = plane;
                } else if (coords[0] == 0 && coords[1] == 0) {
                    index = coords[2];
                }
                Float timestamp = (Float)timestamps.get("Series " + i + " Plane " + index);
                if (timestamp == null) continue;
                store.setPlaneTimingDeltaT(timestamp, i, 0, plane);
            }
            if (i < stageX.size()) {
                for (q = 0; q < this.getImageCount(); ++q) {
                    store.setStagePositionPositionX((Float)stageX.get(i), i, 0, q);
                }
            }
            if (i < stageY.size()) {
                for (q = 0; q < this.getImageCount(); ++q) {
                    store.setStagePositionPositionY((Float)stageY.get(i), i, 0, q);
                }
            }
            if (i < stageZ.size()) {
                for (q = 0; q < this.getImageCount(); ++q) {
                    store.setStagePositionPositionZ((Float)stageZ.get(i), i, 0, q);
                }
            }
            store.setImageInstrumentRef("Instrument:0", i);
            Enumeration keys = this.metadata.keys();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                if (!k.startsWith(seriesName + " ")) continue;
                this.core[i].seriesMetadata.put(k, this.metadata.get(k));
            }
        }
        this.setSeries(0);
        DataTools.parseXML(xml, (DefaultHandler)new LeicaHandler(store));
    }
}

