/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.NetcdfTools;
import loci.formats.meta.FilterMetadata;

public class ImarisHDFReader
extends FormatReader {
    private int previousSeries;
    private Object previousImage;
    private int previousImageNumber;
    private float pixelSizeX;
    private float pixelSizeY;
    private float pixelSizeZ;
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;
    private int seriesCount;
    private NetcdfTools netcdf;
    private Vector emWave;
    private Vector exWave;
    private Vector channelMin;
    private Vector channelMax;
    private Vector gain;
    private Vector pinhole;
    private Vector channelName;
    private Vector microscopyMode;

    public ImarisHDFReader() {
        super("Bitplane Imaris 5.5 (HDF)", "ims");
        this.blockCheckLen = 8;
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readString(8).indexOf("HDF") >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int[] oldZCT;
        int[] nArray;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] zct = FormatTools.getZCTCoords(this, no);
        if (this.previousImageNumber > this.getImageCount()) {
            this.previousImageNumber = -1;
        }
        if (this.previousImageNumber == -1) {
            int[] nArray2 = new int[3];
            nArray2[0] = -1;
            nArray2[1] = -1;
            nArray = nArray2;
            nArray2[2] = -1;
        } else {
            nArray = oldZCT = FormatTools.getZCTCoords(this, this.previousImageNumber);
        }
        if (zct[1] != oldZCT[1] || zct[2] != oldZCT[2] || this.series != this.previousSeries) {
            this.previousImage = this.netcdf.getVariableValue("/DataSet/ResolutionLevel_" + this.series + "/TimePoint_" + zct[2] + "/Channel_" + zct[1] + "/Data");
        }
        this.previousImageNumber = no;
        for (int row = 0; row < h; ++row) {
            if (this.previousImage instanceof byte[][][]) {
                System.arraycopy(((byte[][][])this.previousImage)[zct[0]][row + y], x, buf, row * w, w);
                continue;
            }
            if (this.previousImage instanceof short[][][]) {
                for (int i = 0; i < w; ++i) {
                    DataTools.unpackShort(((short[][][])this.previousImage)[zct[0]][row + y][x + i], buf, 2 * (row * w + i), !this.isLittleEndian());
                }
                continue;
            }
            if (this.previousImage instanceof int[][][]) {
                for (int i = 0; i < w; ++i) {
                    DataTools.unpackBytes(((int[][][])this.previousImage)[zct[0]][row + y][x + i], buf, 4 * (row * w + i), 4, !this.isLittleEndian());
                }
                continue;
            }
            if (!(this.previousImage instanceof float[][][])) continue;
            float[] s = ((float[][][])this.previousImage)[zct[0]][row + y];
            int base = row * w * 4;
            for (int i = 0; i < w; ++i) {
                int v = Float.floatToIntBits(s[x + i]);
                DataTools.unpackBytes(v, buf, base + i * 4, 4, !this.isLittleEndian());
            }
        }
        this.previousSeries = this.series;
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.previousSeries = -1;
        this.previousImageNumber = -1;
        this.previousImage = null;
        this.seriesCount = 0;
        this.pixelSizeZ = 0.0f;
        this.pixelSizeY = 0.0f;
        this.pixelSizeX = 0.0f;
        this.maxZ = 0.0f;
        this.maxY = 0.0f;
        this.maxX = 0.0f;
        this.minZ = 0.0f;
        this.minY = 0.0f;
        this.minX = 0.0f;
        if (this.netcdf != null) {
            this.netcdf.close();
        }
        this.netcdf = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.netcdf = new NetcdfTools(id);
        this.pixelSizeZ = 1.0f;
        this.pixelSizeY = 1.0f;
        this.pixelSizeX = 1.0f;
        this.emWave = new Vector();
        this.exWave = new Vector();
        this.channelMin = new Vector();
        this.channelMax = new Vector();
        this.gain = new Vector();
        this.pinhole = new Vector();
        this.channelName = new Vector();
        this.microscopyMode = new Vector();
        this.seriesCount = 0;
        this.previousImageNumber = -1;
        Vector attributes = this.netcdf.getAttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            int slash;
            int n;
            String attr = (String)attributes.get(i);
            String name = attr.substring(attr.lastIndexOf("/") + 1);
            String value = this.netcdf.getAttributeValue(attr);
            if (value == null) continue;
            value = value.trim();
            if (name.equals("X")) {
                this.core[0].sizeX = Integer.parseInt(value);
            } else if (name.equals("Y")) {
                this.core[0].sizeY = Integer.parseInt(value);
            } else if (name.equals("Z")) {
                this.core[0].sizeZ = Integer.parseInt(value);
            } else if (name.equals("FileTimePoints")) {
                this.core[0].sizeT = Integer.parseInt(value);
            } else if (name.equals("RecordingEntrySampleSpacing")) {
                this.pixelSizeX = Float.parseFloat(value);
            } else if (name.equals("RecordingEntryLineSpacing")) {
                this.pixelSizeY = Float.parseFloat(value);
            } else if (name.equals("RecordingEntryPlaneSpacing")) {
                this.pixelSizeZ = Float.parseFloat(value);
            } else if (name.equals("ExtMax0")) {
                this.maxX = Float.parseFloat(value);
            } else if (name.equals("ExtMax1")) {
                this.maxY = Float.parseFloat(value);
            } else if (name.equals("ExtMax2")) {
                this.maxZ = Float.parseFloat(value);
            } else if (name.equals("ExtMin0")) {
                this.minX = Float.parseFloat(value);
            } else if (name.equals("ExtMin1")) {
                this.minY = Float.parseFloat(value);
            } else if (name.equals("ExtMin2")) {
                this.minZ = Float.parseFloat(value);
            }
            if (attr.startsWith("/DataSet/ResolutionLevel_") && (n = Integer.parseInt(attr.substring(25, (slash = attr.indexOf("/", 25)) == -1 ? attr.length() : slash))) == this.seriesCount) {
                ++this.seriesCount;
            }
            if (attr.startsWith("/DataSetInfo/Channel_")) {
                int underscore;
                int cIndex;
                if (value.indexOf(" ") != -1) {
                    value = value.substring(value.indexOf(" ") + 1);
                }
                if (value.indexOf("-") != -1) {
                    value = value.substring(value.indexOf("-") + 1);
                }
                if (value.indexOf(".") != -1) {
                    value = value.substring(0, value.indexOf("."));
                }
                if ((cIndex = Integer.parseInt(attr.substring(underscore = attr.indexOf("_") + 1, attr.indexOf("/", underscore)))) == this.getSizeC()) {
                    ++this.core[0].sizeC;
                }
                if (name.equals("Gain")) {
                    this.gain.add(value);
                } else if (name.equals("LSMEmissionWavelength")) {
                    this.emWave.add(value);
                } else if (name.equals("LSMExcitationWavelength")) {
                    this.exWave.add(value);
                } else if (name.equals("Max")) {
                    this.channelMax.add(value);
                } else if (name.equals("Min")) {
                    this.channelMin.add(value);
                } else if (name.equals("Pinhole")) {
                    this.pinhole.add(value);
                } else if (name.equals("Name")) {
                    this.channelName.add(value);
                } else if (name.equals("MicroscopyMode")) {
                    this.microscopyMode.add(value);
                }
            }
            if (value == null) continue;
            this.addGlobalMeta(name, value);
        }
        if (this.seriesCount > 1) {
            int i;
            CoreMetadata oldCore = this.core[0];
            this.core = new CoreMetadata[this.seriesCount];
            this.core[0] = oldCore;
            for (i = 1; i < this.getSeriesCount(); ++i) {
                this.core[i] = new CoreMetadata();
            }
            for (i = 1; i < this.getSeriesCount(); ++i) {
                String groupPath = "/DataSet/ResolutionLevel_" + i + "/TimePoint_0/Channel_0";
                this.core[i].sizeX = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeX"));
                this.core[i].sizeY = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeY"));
                this.core[i].sizeZ = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeZ"));
                this.core[i].imageCount = this.core[i].sizeZ * this.getSizeC() * this.getSizeT();
                this.core[i].sizeC = this.getSizeC();
                this.core[i].sizeT = this.getSizeT();
                this.core[i].thumbnail = true;
            }
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        this.core[0].thumbnail = false;
        int type = -1;
        Object pix = this.netcdf.getVariableValue("/DataSet/ResolutionLevel_0/TimePoint_0/Channel_0/Data");
        if (pix instanceof byte[][][]) {
            type = 1;
        } else if (pix instanceof short[][][]) {
            type = 3;
        } else if (pix instanceof int[][][]) {
            type = 5;
        } else if (pix instanceof float[][][]) {
            type = 6;
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].pixelType = type;
            this.core[i].dimensionOrder = "XYZCT";
            this.core[i].rgb = false;
            this.core[i].thumbSizeX = 128;
            this.core[i].thumbSizeY = 128;
            this.core[i].orderCertain = true;
            this.core[i].littleEndian = true;
            this.core[i].interleaved = false;
            this.core[i].indexed = false;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            float px = this.pixelSizeX;
            float py = this.pixelSizeY;
            float pz = this.pixelSizeZ;
            if (px == 1.0f) {
                px = (this.maxX - this.minX) / (float)this.core[i].sizeX;
            }
            if (py == 1.0f) {
                py = (this.maxY - this.minY) / (float)this.core[i].sizeY;
            }
            if (pz == 1.0f) {
                pz = (this.maxZ - this.minZ) / (float)this.core[i].sizeZ;
            }
            store.setDimensionsPhysicalSizeX(new Float(px), i, 0);
            store.setDimensionsPhysicalSizeY(new Float(py), i, 0);
            store.setDimensionsPhysicalSizeZ(new Float(pz), i, 0);
        }
        int cIndex = 0;
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            store.setImageName("Resolution Level " + (s + 1), s);
            MetadataTools.setDefaultCreationDate(store, id, s);
            for (int i = 0; i < this.core[s].sizeC; ++i) {
                block87: {
                    Double maxValue;
                    block86: {
                        block85: {
                            block84: {
                                Integer emWaveValue;
                                block83: {
                                    Integer pinholeValue;
                                    block82: {
                                        Float gainValue = null;
                                        pinholeValue = null;
                                        emWaveValue = null;
                                        if (cIndex < this.gain.size()) {
                                            try {
                                                gainValue = new Float((String)this.gain.get(cIndex));
                                            }
                                            catch (NumberFormatException e) {
                                                if (!debug) break block82;
                                                this.trace(e);
                                            }
                                        }
                                    }
                                    if (cIndex < this.pinhole.size()) {
                                        try {
                                            pinholeValue = new Integer((String)this.pinhole.get(cIndex));
                                        }
                                        catch (NumberFormatException e) {
                                            if (!debug) break block83;
                                            this.trace(e);
                                        }
                                    }
                                }
                                if (cIndex < this.emWave.size()) {
                                    try {
                                        emWaveValue = new Integer((String)this.emWave.get(cIndex));
                                    }
                                    catch (NumberFormatException e) {
                                        if (!debug) break block84;
                                        this.trace(e);
                                    }
                                }
                            }
                            if (cIndex < this.exWave.size()) {
                                try {
                                    Integer exWaveValue = new Integer((String)this.exWave.get(cIndex));
                                }
                                catch (NumberFormatException e) {
                                    if (!debug) break block85;
                                    this.trace(e);
                                }
                            }
                        }
                        Double minValue = null;
                        maxValue = null;
                        if (cIndex < this.channelMin.size()) {
                            try {
                                minValue = new Double((String)this.channelMin.get(cIndex));
                            }
                            catch (NumberFormatException e) {
                                if (!debug) break block86;
                                this.trace(e);
                            }
                        }
                    }
                    if (cIndex < this.channelMax.size()) {
                        try {
                            maxValue = new Double((String)this.channelMax.get(cIndex));
                        }
                        catch (NumberFormatException e) {
                            if (!debug) break block87;
                            this.trace(e);
                        }
                    }
                }
                ++cIndex;
            }
        }
    }
}

