/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MDBParser;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;

public class APLReader
extends FormatReader {
    private String[] tiffFiles;
    private String[] xmlFiles;
    private MinimalTiffReader[] tiffReaders;
    private Vector<String> used;

    public APLReader() {
        super("Olympus APL", new String[]{"apl", "tnb", "mtb"});
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            Vector<String> files = new Vector<String>();
            for (String f : this.used) {
                String name = f.toLowerCase();
                if (name.endsWith(".tif") || name.endsWith(".tiff")) continue;
                files.add(f);
            }
            return files.toArray(new String[0]);
        }
        return this.used == null ? new String[]{} : this.used.toArray(new String[0]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.tiffReaders[this.series].openBytes(no, buf, x, y, w, h);
    }

    public void close() throws IOException {
        super.close();
        if (this.tiffReaders != null) {
            for (MinimalTiffReader reader : this.tiffReaders) {
                reader.close();
            }
        }
        this.tiffReaders = null;
        this.tiffFiles = null;
        this.xmlFiles = null;
        this.used = null;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] row3;
        this.debug("APLReader.initFile(" + id + ")");
        super.initFile(id);
        String name = id.toLowerCase();
        if (!name.endsWith(".mtb")) {
            String mtbFile;
            int underscore;
            int separator = id.lastIndexOf(File.separator);
            if (separator < 0) {
                separator = 0;
            }
            if ((underscore = id.lastIndexOf("_")) < separator) {
                underscore = id.lastIndexOf(".");
            }
            if (!new Location(mtbFile = id.substring(0, underscore) + "_d.mtb").exists()) {
                throw new FormatException(".mtb file not found");
            }
            this.currentId = new Location(mtbFile).getAbsolutePath();
        }
        String mtb = new Location(this.currentId).getAbsolutePath();
        Vector<String[]> rows = MDBParser.parseDatabase(mtb)[0];
        String[] columnNames = rows.get(0);
        for (int i = 1; i < rows.size(); ++i) {
            String[] row = rows.get(i);
            for (int q = 0; q < row.length; ++q) {
                this.addGlobalMeta(columnNames[q + 1] + " " + i, row[q]);
            }
        }
        this.used = new Vector();
        this.used.add(id);
        if (!id.equals(mtb)) {
            this.used.add(mtb);
        }
        int calibrationUnit = this.calculateIndex("Calibration Unit", columnNames);
        int colorChannels = this.calculateIndex("Color Channels", columnNames);
        int frames = this.calculateIndex("Frames", columnNames);
        int calibratedHeight = this.calculateIndex("Height", columnNames);
        int calibratedWidth = this.calculateIndex("Width", columnNames);
        int path = this.calculateIndex("Image Path", columnNames);
        int magnification = this.calculateIndex("Magnification", columnNames);
        int width = this.calculateIndex("X-Resolution", columnNames);
        int height = this.calculateIndex("Y-Resolution", columnNames);
        int imageName = this.calculateIndex("Image Name", columnNames);
        int seriesCount = (rows.size() - 1) / 3;
        this.core = new CoreMetadata[seriesCount];
        for (int i = 0; i < seriesCount; ++i) {
            this.core[i] = new CoreMetadata();
        }
        this.tiffFiles = new String[seriesCount];
        this.xmlFiles = new String[seriesCount];
        this.tiffReaders = new MinimalTiffReader[seriesCount];
        String parentDirectory = mtb.substring(0, mtb.lastIndexOf(File.separator));
        for (int i = 0; i < seriesCount; ++i) {
            String[] row2 = rows.get(i * 3 + 2);
            row3 = rows.get(i * 3 + 3);
            this.core[i].sizeZ = Integer.parseInt(row3[frames]);
            this.core[i].sizeT = 1;
            this.core[i].dimensionOrder = "XYCZT";
            this.xmlFiles[i] = row2[path];
            this.tiffFiles[i] = row3[path];
            this.xmlFiles[i] = this.xmlFiles[i].replaceAll("/", File.separator);
            while (this.xmlFiles[i].indexOf(92) != -1) {
                this.xmlFiles[i] = this.xmlFiles[i].replace('\\', File.separatorChar);
            }
            this.tiffFiles[i] = this.tiffFiles[i].replaceAll("/", File.separator);
            while (this.tiffFiles[i].indexOf(92) != -1) {
                this.tiffFiles[i] = this.tiffFiles[i].replace('\\', File.separatorChar);
            }
            int slash = this.xmlFiles[i].lastIndexOf(File.separator);
            slash = this.xmlFiles[i].lastIndexOf(slash - 1);
            slash = this.xmlFiles[i].lastIndexOf(slash - 1);
            this.xmlFiles[i] = parentDirectory + File.separator + this.xmlFiles[i].substring(slash + 1);
            slash = this.tiffFiles[i].lastIndexOf(File.separator);
            slash = this.tiffFiles[i].lastIndexOf(File.separator, slash - 1);
            this.tiffFiles[i] = parentDirectory + File.separator + this.tiffFiles[i].substring(slash + 1);
            this.used.add(this.xmlFiles[i]);
            this.used.add(this.tiffFiles[i]);
            this.tiffReaders[i] = new MinimalTiffReader();
            this.tiffReaders[i].setId(this.tiffFiles[i]);
            this.core[i].sizeX = this.tiffReaders[i].getSizeX();
            this.core[i].sizeY = this.tiffReaders[i].getSizeY();
            this.core[i].sizeC = this.tiffReaders[i].getSizeC();
            this.core[i].rgb = this.tiffReaders[i].isRGB();
            this.core[i].pixelType = this.tiffReaders[i].getPixelType();
            this.core[i].littleEndian = this.tiffReaders[i].isLittleEndian();
            this.core[i].indexed = this.tiffReaders[i].isIndexed();
            this.core[i].falseColor = this.tiffReaders[i].isFalseColor();
            this.core[i].imageCount = this.core[i].sizeZ * (this.core[i].rgb ? 1 : this.core[i].sizeC);
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < seriesCount; ++i) {
            row3 = rows.get(i * 3 + 3);
            MetadataTools.setDefaultCreationDate(store, mtb, i);
            store.setImageName(row3[imageName], i);
            float realWidth = Float.parseFloat(row3[calibratedWidth]);
            float realHeight = Float.parseFloat(row3[calibratedHeight]);
            String units = row3[calibrationUnit];
            float px = realWidth / (float)this.core[i].sizeX;
            float py = realHeight / (float)this.core[i].sizeY;
            if (units.equals("mm")) {
                px *= 1000.0f;
                py *= 1000.0f;
            }
            store.setDimensionsPhysicalSizeX(new Float(px), i, 0);
            store.setDimensionsPhysicalSizeY(new Float(py), i, 0);
        }
    }

    private int calculateIndex(String key, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!key.equals(array[i])) continue;
            return i - 1;
        }
        return -1;
    }
}

