/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;

public class POITools {
    private static final String NO_POI_MSG = "Jakarta POI is required to read Compix SimplePCI, Fluoview FV1000 OIB, ImagePro IPW, and Zeiss ZVI files.  Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html";
    private ReflectedUniverse r;
    private String id;
    private Vector filePath;
    private Vector fileList;
    private Hashtable fileSizes;

    public POITools(String id) throws FormatException, IOException {
        this.id = id;
        this.initialize(id);
    }

    public POITools(RandomAccessInputStream s) throws FormatException, IOException {
        this.id = String.valueOf(System.currentTimeMillis());
        this.initialize(s);
    }

    public RandomAccessInputStream getDocumentStream(String name) throws FormatException, IOException {
        byte[] buf = this.getDocumentBytes(name, this.getFileSize(name));
        return new RandomAccessInputStream(buf);
    }

    public byte[] getDocumentBytes(String name) throws FormatException {
        return this.getDocumentBytes(name, this.getFileSize(name));
    }

    public byte[] getDocumentBytes(String name, int count) throws FormatException {
        int availableBytes = this.getFileSize(name);
        int len = count > availableBytes ? availableBytes : count;
        this.setupFile(name);
        byte[] buf = new byte[len];
        try {
            String dataVar = this.makeVarName("data");
            this.r.setVar(dataVar, buf);
            this.r.exec(this.makeVarName("dis") + ".read(" + dataVar + ")");
        }
        catch (ReflectException e) {
            throw new FormatException(e);
        }
        return buf;
    }

    public int getFileSize(String name) throws FormatException {
        return (Integer)this.fileSizes.get(name);
    }

    public Vector getDocumentList() throws FormatException {
        return this.fileList;
    }

    public void close() {
        try {
            this.r.exec(this.makeVarName("dis") + ".close()");
            this.r.setVar(this.makeVarName("data"), null);
            this.r.setVar(this.makeVarName("dis"), null);
            this.r.setVar(this.makeVarName("data"), null);
            this.r.setVar(this.makeVarName("numBytes"), null);
            this.r.setVar(this.makeVarName("root"), null);
            this.r.setVar(this.makeVarName("file"), null);
            this.r.setVar(this.makeVarName("size"), null);
            this.r.setVar(this.makeVarName("littleEndian"), null);
            this.r.setVar(this.makeVarName("fis"), null);
            this.r.setVar(this.makeVarName("fs"), null);
            this.r.setVar(this.makeVarName("dir"), null);
            this.r.setVar(this.makeVarName("directory"), null);
            this.r.setVar(this.makeVarName("entry"), null);
            this.r.setVar(this.makeVarName("entryName"), null);
            this.r.setVar(this.makeVarName("tmp"), null);
        }
        catch (ReflectException reflectException) {
            // empty catch block
        }
    }

    private void initialize(String file2) throws FormatException, IOException {
        RandomAccessInputStream s = new RandomAccessInputStream(file2);
        this.initialize(s);
        s.close();
    }

    private void initialize(RandomAccessInputStream s) throws FormatException, IOException {
        try {
            this.r = new ReflectedUniverse();
            this.r.exec("import loci.poi.poifs.filesystem.POIFSFileSystem");
            this.r.exec("import loci.poi.poifs.filesystem.DirectoryEntry");
            this.r.exec("import loci.poi.poifs.filesystem.DocumentEntry");
            this.r.exec("import loci.poi.poifs.filesystem.DocumentInputStream");
            this.r.exec("import loci.common.RandomAccessInputStream");
            this.r.exec("import java.util.Iterator");
        }
        catch (ReflectException exc) {
            throw new FormatException(NO_POI_MSG, exc);
        }
        s.order(true);
        s.seek(30L);
        int size = (int)Math.pow(2.0, s.readShort());
        s.seek(0L);
        try {
            String sizeVar = this.makeVarName("size");
            String fsVar = this.makeVarName("fs");
            String fisVar = this.makeVarName("fis");
            this.r.setVar(sizeVar, size);
            this.r.setVar(this.makeVarName("littleEndian"), true);
            this.r.setVar(fisVar, s);
            this.r.exec(fsVar + " = new POIFSFileSystem(" + fisVar + ", " + sizeVar + ")");
            this.r.exec(this.makeVarName("root") + " = " + fsVar + ".getRoot()");
        }
        catch (ReflectException e) {
            throw new FormatException(e);
        }
        this.fileList = new Vector();
        this.filePath = new Vector();
        try {
            this.parseFile(this.r.getVar(this.makeVarName("root")), this.fileList);
        }
        catch (ReflectException e) {
            throw new FormatException(e);
        }
        this.fileSizes = new Hashtable();
        for (int i = 0; i < this.fileList.size(); ++i) {
            String name = (String)this.fileList.get(i);
            this.setupFile(name);
            try {
                this.fileSizes.put(name, this.r.getVar(this.makeVarName("numBytes")));
                continue;
            }
            catch (ReflectException e) {
                throw new FormatException(e);
            }
        }
    }

    private void setupFile(String name) throws FormatException {
        try {
            String directoryVar = this.makeVarName("directory");
            this.r.exec(directoryVar + " = " + this.makeVarName("root"));
            StringTokenizer path = new StringTokenizer(name, "/\\");
            int count = path.countTokens();
            path.nextToken();
            for (int i = 1; i < count - 1; ++i) {
                String dir = path.nextToken();
                this.r.setVar(this.makeVarName("dir"), dir);
                this.r.exec(directoryVar + " = " + directoryVar + ".getEntry(" + this.makeVarName("dir") + ")");
            }
            String filenameVar = this.makeVarName("filename");
            String fileVar = this.makeVarName("file");
            String disVar = this.makeVarName("dis");
            this.r.setVar(filenameVar, path.nextToken());
            this.r.exec(fileVar + " = " + directoryVar + ".getEntry(" + filenameVar + ")");
            this.r.exec(disVar + " = new DocumentInputStream(" + fileVar + ", " + this.makeVarName("fis") + ")");
            this.r.exec(this.makeVarName("numBytes") + " = " + disVar + ".available()");
        }
        catch (ReflectException e) {
            throw new FormatException(e);
        }
    }

    private void parseFile(Object root, Vector fileList) throws FormatException {
        try {
            String dirVar = this.makeVarName("dir");
            this.r.setVar(dirVar, root);
            this.r.exec(this.makeVarName("dirName") + " = " + dirVar + ".getName()");
            this.r.exec(this.makeVarName("iter") + " = " + dirVar + ".getEntries()");
            this.filePath.add(this.r.getVar(this.makeVarName("dirName")));
            Iterator iter = (Iterator)this.r.getVar(this.makeVarName("iter"));
            String entryVar = this.makeVarName("entry");
            while (iter.hasNext()) {
                this.r.setVar(entryVar, iter.next());
                boolean isInstance = (Boolean)this.r.exec(entryVar + ".isDirectoryEntry()");
                boolean isDocument = (Boolean)this.r.exec(entryVar + ".isDocumentEntry()");
                if (isInstance) {
                    this.parseFile(this.r.getVar(entryVar), fileList);
                    continue;
                }
                if (!isDocument) continue;
                this.r.exec(this.makeVarName("entryName") + " = " + entryVar + ".getName()");
                StringBuffer path = new StringBuffer();
                for (int i = 0; i < this.filePath.size(); ++i) {
                    path.append((String)this.filePath.get(i));
                    path.append(File.separator);
                }
                path.append((String)this.r.getVar(this.makeVarName("entryName")));
                fileList.add(path.toString());
            }
            this.filePath.removeElementAt(this.filePath.size() - 1);
        }
        catch (ReflectException e) {
            throw new FormatException(e);
        }
    }

    private String makeVarName(String var) {
        String file2 = this.id.replaceAll(" ", "");
        file2 = file2.replaceAll(".", "");
        return file2 + "-" + var;
    }
}

