/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.StringTokenizer;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.vertical.AtmosSigma;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class VAtmSigma
extends AbstractCoordTransBuilder {
    private String sigma = "";
    private String ps = "";
    private String ptop = "";

    public String getTransformName() {
        return "atmosphere_sigma_coordinate";
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        String formula_terms = this.getFormula(ds, ctv);
        if (null == formula_terms) {
            return null;
        }
        StringTokenizer stoke = new StringTokenizer(formula_terms);
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equalsIgnoreCase("sigma:")) {
                this.sigma = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("ps:")) {
                this.ps = stoke.nextToken();
                continue;
            }
            if (!toke.equalsIgnoreCase("ptop:")) continue;
            this.ptop = stoke.nextToken();
        }
        VerticalCT rs = new VerticalCT("AtmSigma_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.Sigma, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("formula", "pressure(x,y,z) = ptop + sigma(z)*(surfacePressure(x,y)-ptop)"));
        if (!this.addParameter(rs, "SurfacePressure_variableName", ds, this.ps)) {
            return null;
        }
        if (!this.addParameter(rs, "Sigma_variableName", ds, this.sigma)) {
            return null;
        }
        if (!this.addParameter(rs, "PressureTop_variableName", ds, this.ptop)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "Sigma:sigma:" + this.sigma + " ps:" + this.ps + " ptop:" + this.ptop;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new AtmosSigma(ds, timeDim, vCT);
    }
}

