/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.projection.McIDASAreaProjection;

public class McIDASArea
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "mcidas_area";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        int[] area = this.getIntArray(ctv, "AreaHeader");
        int[] nav = this.getIntArray(ctv, "NavHeader");
        McIDASAreaProjection proj = new McIDASAreaProjection(area, nav);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }

    private int[] getIntArray(Variable ctv, String attName) {
        Attribute att = ctv.findAttribute(attName);
        if (att == null) {
            throw new IllegalArgumentException("McIDASArea coordTransformVariable " + ctv.getName() + " must have " + attName + " attribute");
        }
        Array arr = att.getValues();
        return (int[])arr.get1DJavaArray(Integer.TYPE);
    }
}

