/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import ucar.bufr.BufrDataDescriptionSection;
import ucar.bufr.BufrIdentificationSection;
import ucar.bufr.BufrNumbers;
import ucar.bufr.BufrTables;
import ucar.bufr.Descriptor;
import ucar.unidata.io.RandomAccessFile;

final class BufrReadTables {
    private final RandomAccessFile raf;
    private HashMap tableA;
    private HashMap tableB;
    private HashMap tableD;
    private int bitBuf = 0;
    private int bitPos = 0;

    public BufrReadTables(RandomAccessFile raf, BufrIdentificationSection ids, BufrDataDescriptionSection dds, HashMap TableA, HashMap TableB, HashMap TableD) throws IOException {
        this.raf = raf;
        if (TableA == null) {
            this.tableA = (HashMap)BufrTables.tablesA.get(ids.getMasterTableFilename() + "-A");
            this.tableB = (HashMap)BufrTables.tablesB.get(ids.getMasterTableFilename() + "-B");
            this.tableD = (HashMap)BufrTables.tablesD.get(ids.getMasterTableFilename() + "-D");
        } else {
            this.tableA = TableA;
            this.tableB = TableB;
            this.tableD = TableD;
        }
        int length = BufrNumbers.uint3(raf);
        int reserved = raf.read();
        if (dds.getDataType() != 192 && dds.getDataType() != 64) {
            this.uncompressed(dds);
        }
    }

    private void uncompressed(BufrDataDescriptionSection dds) throws IOException {
        ArrayList dKeys = dds.getDescriptors();
        block0: for (int k = 0; k < dds.getNumberDataSets(); ++k) {
            for (int i = 0; i < dKeys.size(); ++i) {
                String dKey = (String)dKeys.get(i);
                if (dKey.equals("0-32-0")) continue;
                if (dKey.startsWith("0")) {
                    System.out.println("Bad table read");
                    continue block0;
                }
                if (dKey.startsWith("3")) {
                    System.out.println("Bad table read");
                    continue block0;
                }
                if (dKey.startsWith("1")) {
                    int rx = Integer.parseInt(dKey.substring(2, dKey.lastIndexOf("-")));
                    ArrayList<String> rl = new ArrayList<String>();
                    for (int r = 0; r <= rx; ++r) {
                        rl.add((String)dKeys.get(++i));
                    }
                    if (rl.hashCode() == -2124082406) {
                        this.tableAentry(rl);
                        continue;
                    }
                    if (rl.hashCode() == 1035908319) {
                        this.tableBentry(rl);
                        continue;
                    }
                    if (rl.hashCode() == -1645494115) {
                        this.tableDentry(rl);
                        continue;
                    }
                    System.out.println("Table not recognized");
                    continue block0;
                }
                if (dKey.startsWith("2-5-")) {
                    int numberChars = Integer.parseInt(dKey.substring(dKey.lastIndexOf("-") + 1));
                    String text = this.getString(numberChars).trim();
                    System.out.println(" Text = " + text);
                    continue block0;
                }
                if (!dKey.startsWith("2")) continue;
                System.out.println("F = 2, top level not implemented yet");
                continue block0;
            }
        }
    }

    private void tableAentry(ArrayList rl) throws IOException {
        int ry = 0;
        String dKey = (String)rl.get(0);
        ry = this.getRepetitions(dKey);
        for (int i = 0; i < ry; ++i) {
            dKey = (String)rl.get(1);
            Descriptor des = (Descriptor)this.tableB.get(dKey);
            String index = this.getString(des).trim();
            dKey = (String)rl.get(2);
            des = (Descriptor)this.tableB.get(dKey);
            String str = this.getString(des);
            dKey = (String)rl.get(3);
            des = (Descriptor)this.tableB.get(dKey);
            str = str + this.getString(des);
            str = str.replaceFirst("\\w+\\s+TABLE A ENTRY( - )?", "");
            str = str.trim();
            this.tableA.put(index, str);
        }
    }

    private void tableBentry(ArrayList rl) throws IOException {
        int ry = 0;
        String dKey = (String)rl.get(0);
        ry = this.getRepetitions(dKey);
        dKey = (String)rl.get(1);
        if (dKey.equals("3-0-4")) {
            rl = (ArrayList)this.tableD.get(dKey);
        }
        String F = "";
        String X = "";
        String Y = "";
        for (int i = 0; i < ry; ++i) {
            Descriptor des;
            dKey = (String)rl.get(0);
            if (dKey.equals("3-0-3")) {
                des = (Descriptor)this.tableB.get("0-0-10");
                F = this.getString(des);
                des = (Descriptor)this.tableB.get("0-0-11");
                X = this.getString(des);
                des = (Descriptor)this.tableB.get("0-0-12");
                Y = this.getString(des);
            }
            dKey = (String)rl.get(1);
            des = (Descriptor)this.tableB.get(dKey);
            String name = this.getString(des);
            dKey = (String)rl.get(2);
            des = (Descriptor)this.tableB.get(dKey);
            name = name + this.getString(des);
            dKey = (String)rl.get(3);
            des = (Descriptor)this.tableB.get(dKey);
            String units = this.getString(des);
            dKey = (String)rl.get(4);
            des = (Descriptor)this.tableB.get(dKey);
            String scaleSign = this.getString(des);
            dKey = (String)rl.get(5);
            des = (Descriptor)this.tableB.get(dKey);
            String scale = this.getString(des);
            dKey = (String)rl.get(6);
            des = (Descriptor)this.tableB.get(dKey);
            String refSign = this.getString(des);
            dKey = (String)rl.get(7);
            des = (Descriptor)this.tableB.get(dKey);
            String reference = this.getString(des);
            dKey = (String)rl.get(8);
            des = (Descriptor)this.tableB.get(dKey);
            String width = this.getString(des);
            des = new Descriptor(F, X, Y, scaleSign, scale, refSign, reference, width, units, name);
            this.tableB.put(des.getKey(), des);
        }
    }

    private void tableDentry(ArrayList rl) throws IOException {
        int ry = 0;
        String dKey = (String)rl.get(0);
        ry = this.getRepetitions(dKey);
        dKey = (String)rl.get(1);
        ArrayList rFXY = null;
        if (dKey.equals("3-0-3")) {
            rFXY = (ArrayList)this.tableD.get(dKey);
        }
        for (int i = 0; i < ry; ++i) {
            String Y;
            dKey = (String)rFXY.get(0);
            Descriptor des = (Descriptor)this.tableB.get(dKey);
            String F = this.getString(des);
            dKey = (String)rFXY.get(1);
            des = (Descriptor)this.tableB.get(dKey);
            String X = this.getString(des);
            if (X.length() == 2 && X.startsWith("0")) {
                X = X.substring(1);
            }
            if ((Y = this.getString(des = (Descriptor)this.tableB.get(dKey = (String)rFXY.get(2)))).length() == 3 && Y.startsWith("00")) {
                Y = Y.substring(2);
            } else if (Y.length() == 3 && Y.startsWith("0")) {
                Y = Y.substring(1);
            }
            dKey = (String)rl.get(2);
            if (dKey.startsWith("2-5-")) {
                int numberChars = Integer.parseInt(dKey.substring(dKey.lastIndexOf("-") + 1));
                String text = this.getString(numberChars).trim();
            }
            if (!(dKey = (String)rl.get(3)).equals("1-1-0") || !(dKey = (String)rl.get(4)).equals("0-31-1")) continue;
            int numberSeq = this.getRepetitions(dKey);
            ArrayList<String> al = new ArrayList<String>();
            dKey = (String)rl.get(5);
            des = (Descriptor)this.tableB.get(dKey);
            for (int j = 0; j < numberSeq; ++j) {
                String sY;
                String seq = this.getString(des);
                String sF = seq.substring(0, 1);
                String sX = seq.substring(1, 3);
                if (sX.length() == 2 && sX.startsWith("0")) {
                    sX = sX.substring(1);
                }
                if ((sY = seq.substring(3)).length() == 3 && sY.startsWith("00")) {
                    sY = sY.substring(2);
                } else if (sY.length() == 3 && sY.startsWith("0")) {
                    sY = sY.substring(1);
                }
                al.add(sF + "-" + sX + "-" + sY);
            }
            this.tableD.put(F + "-" + X + "-" + Y, al);
        }
    }

    private int getRepetitions(String dKey) throws IOException {
        int ry = -1;
        if (dKey.equals("0-31-0")) {
            System.out.println("0-31-0 not implemented yet");
        } else if (dKey.equals("0-31-1")) {
            ry = this.bits2UInt(8);
        } else if (dKey.equals("0-31-2")) {
            ry = this.bits2UInt(16);
        } else {
            System.out.println("bad repetitions key =" + dKey);
        }
        return ry;
    }

    private String getString(int count) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append((char)this.bits2UInt(8));
        }
        return sb.toString();
    }

    private String getString(Descriptor des) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < des.getWidth() / 8; ++i) {
            sb.append((char)this.bits2UInt(8));
        }
        return sb.toString();
    }

    private int bits2UInt(int nb) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = this.raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = this.raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public final HashMap getTableA() {
        return this.tableA;
    }

    public final HashMap getTableB() {
        return this.tableB;
    }

    public final HashMap getTableD() {
        return this.tableD;
    }
}

