/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import loci.common.DataTools;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.ReaderWrapper;
import loci.formats.in.ND2Reader;
import loci.formats.in.PictReader;
import loci.formats.in.QTReader;
import loci.formats.in.SDTReader;
import loci.plugins.util.LociPrefs;
import loci.plugins.util.LuraWave;

public class ImagePlusReader
extends ReaderWrapper {
    public static ImagePlusReader makeImagePlusReader(IFormatReader r) {
        if (r instanceof ImagePlusReader) {
            return (ImagePlusReader)r;
        }
        return new ImagePlusReader(r);
    }

    public static ImageReader makeImageReader() {
        Class[] c = null;
        try {
            ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
            c = defaultClasses.getClasses();
        }
        catch (IOException exc) {
            return new ImageReader();
        }
        ClassList enabledClasses = new ClassList(IFormatReader.class);
        for (int i = 0; i < c.length; ++i) {
            boolean on = LociPrefs.isReaderEnabled(c[i]);
            if (!on) continue;
            try {
                enabledClasses.addClass(c[i]);
                continue;
            }
            catch (FormatException exc) {
                exc.printStackTrace();
            }
        }
        ImageReader reader = new ImageReader(enabledClasses);
        boolean nd2Nikon = LociPrefs.isND2Nikon();
        boolean pictQTJava = LociPrefs.isPictQTJava();
        boolean qtQTJava = LociPrefs.isQTQTJava();
        boolean sdtIntensity = LociPrefs.isSDTIntensity();
        IFormatReader[] r = reader.getReaders();
        for (int i = 0; i < r.length; ++i) {
            if (r[i] instanceof ND2Reader) {
                ND2Reader nd2 = (ND2Reader)r[i];
                nd2.setLegacy(nd2Nikon);
                continue;
            }
            if (r[i] instanceof PictReader) {
                PictReader pict = (PictReader)r[i];
                pict.setLegacy(pictQTJava);
                continue;
            }
            if (r[i] instanceof QTReader) {
                QTReader qt = (QTReader)r[i];
                qt.setLegacy(qtQTJava);
                continue;
            }
            if (!(r[i] instanceof SDTReader)) continue;
            SDTReader sdt = (SDTReader)r[i];
            sdt.setIntensity(sdtIntensity);
        }
        return reader;
    }

    public ImagePlusReader() {
        super(ImagePlusReader.makeImageReader());
    }

    public ImagePlusReader(IFormatReader r) {
        super(r);
    }

    public ImageProcessor[] openProcessors(int no) throws FormatException, IOException {
        return this.openProcessors(no, null);
    }

    public ImageProcessor[] openProcessors(int no, Rectangle crop) throws FormatException, IOException {
        byte[] b = null;
        boolean first = true;
        if (crop == null) {
            crop = new Rectangle(0, 0, this.getSizeX(), this.getSizeY());
        }
        while (true) {
            String code = LuraWave.initLicenseCode();
            try {
                b = this.openBytes(no, crop.x, crop.y, crop.width, crop.height);
            }
            catch (FormatException exc) {
                if (LuraWave.isLicenseCodeException(exc)) {
                    if ((code = LuraWave.promptLicenseCode(code, first)) == null) {
                        return null;
                    }
                    if (!first) continue;
                    first = false;
                    continue;
                }
                throw exc;
            }
            break;
        }
        int w = crop.width;
        int h = crop.height;
        int c = this.getRGBChannelCount();
        int type = this.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(type);
        boolean interleave = this.isInterleaved();
        if (b.length != w * h * c * bpp && b.length != w * h * bpp) {
            throw new FormatException("Invalid byte array length: " + b.length + " (expected w=" + w + ", h=" + h + ", c=" + c + ", bpp=" + bpp + ")");
        }
        boolean isFloat = type == 6 || type == 7;
        boolean isLittle = this.isLittleEndian();
        boolean isSigned = type == 0 || type == 2 || type == 4;
        IndexColorModel cm = null;
        if (this.isIndexed()) {
            short[][] shortTable;
            byte[][] byteTable = this.get8BitLookupTable();
            if (byteTable != null) {
                cm = new IndexColorModel(8, byteTable[0].length, byteTable[0], byteTable[1], byteTable[2]);
            }
            if ((shortTable = this.get16BitLookupTable()) != null) {
                byteTable = new byte[3][256];
                for (int i = 0; i < byteTable[0].length; ++i) {
                    int index = (int)((float)i / (float)byteTable[0].length * 65535.0f);
                    byteTable[0][i] = (byte)((float)shortTable[0][index] / 65535.0f * 255.0f);
                    byteTable[1][i] = (byte)((float)shortTable[1][index] / 65535.0f * 255.0f);
                    byteTable[2][i] = (byte)((float)shortTable[2][index] / 65535.0f * 255.0f);
                }
                cm = new IndexColorModel(8, byteTable[0].length, byteTable[0], byteTable[1], byteTable[2]);
            }
        }
        ImageProcessor[] ip = new ImageProcessor[c];
        for (int i = 0; i < c; ++i) {
            Object[] tmp;
            Object[] q;
            byte[] channel = ImageTools.splitChannels(b, i, c, bpp, false, interleave);
            Object pixels = DataTools.makeDataArray(channel, bpp, isFloat, isLittle);
            if (pixels instanceof byte[]) {
                q = (byte[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new byte[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                if (isSigned) {
                    q = DataTools.makeSigned(q);
                }
                ip[i] = new ByteProcessor(w, h, q, null);
                if (cm == null) continue;
                ip[i].setColorModel((ColorModel)cm);
                continue;
            }
            if (pixels instanceof short[]) {
                q = (short[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new short[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                if (isSigned) {
                    q = DataTools.makeSigned((short[])q);
                }
                ip[i] = new ShortProcessor(w, h, (short[])q, (ColorModel)cm);
                continue;
            }
            if (pixels instanceof int[]) {
                q = (int[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new int[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                ip[i] = new FloatProcessor(w, h, (int[])q);
                continue;
            }
            if (pixels instanceof float[]) {
                q = (float[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new float[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                ip[i] = new FloatProcessor(w, h, (float[])q, null);
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            q = (double[])pixels;
            if (q.length != w * h) {
                tmp = q;
                q = new double[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            ip[i] = new FloatProcessor(w, h, (double[])q);
        }
        return ip;
    }
}

