/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.IJ;
import java.awt.Dialog;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.BufferedImageReader;

public class ThumbLoader
implements Runnable {
    private BufferedImageReader ir;
    private Panel[] p;
    private Dialog dialog;
    private boolean scale;
    private boolean stop;
    private Thread loader;

    public ThumbLoader(IFormatReader ir, Panel[] p, Dialog dialog, boolean scale) {
        this.ir = BufferedImageReader.makeBufferedImageReader(ir);
        this.p = p;
        this.dialog = dialog;
        this.scale = scale;
        this.loader = new Thread((Runnable)this, "BioFormats-ThumbLoader");
        this.loader.start();
    }

    public void stop() {
        if (this.loader == null) {
            return;
        }
        this.stop = true;
        IJ.showStatus((String)"Canceling thumbnail generation");
        try {
            this.loader.join();
            this.loader = null;
        }
        catch (InterruptedException exc) {
            exc.printStackTrace();
        }
        IJ.showStatus((String)"");
    }

    public void run() {
        try {
            int i;
            IJ.showStatus((String)"Gathering series information");
            int seriesCount = this.ir.getSeriesCount();
            Object[] info = new SeriesInfo[seriesCount];
            for (i = 0; i < seriesCount; ++i) {
                if (this.stop) {
                    return;
                }
                this.ir.setSeries(i);
                info[i] = new SeriesInfo(i, this.ir.getSizeX() * this.ir.getSizeY());
            }
            if (this.stop) {
                return;
            }
            Arrays.sort(info);
            for (i = 0; i < seriesCount; ++i) {
                if (this.stop) {
                    return;
                }
                int ii = ((SeriesInfo)info[i]).index;
                IJ.showStatus((String)("Reading thumbnail for series #" + (ii + 1)));
                this.ir.setSeries(ii);
                int z = this.ir.getSizeZ() / 2;
                int t = this.ir.getSizeT() / 2;
                int ndx = this.ir.getIndex(z, 0, t);
                BufferedImage thumb = this.ir.openThumbImage(ndx);
                if (this.scale && this.ir.getPixelType() != 6) {
                    thumb = AWTImageTools.autoscale(thumb);
                }
                ImageIcon icon = new ImageIcon(thumb);
                this.p[ii].removeAll();
                this.p[ii].add(new JLabel(icon));
                if (this.dialog == null) continue;
                this.dialog.validate();
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
    }

    public class SeriesInfo
    implements Comparable {
        private int index;
        private int size;

        public SeriesInfo(int index, int size) {
            this.index = index;
            this.size = size;
        }

        public int compareTo(Object o) {
            SeriesInfo info = (SeriesInfo)o;
            return this.size - info.size;
        }
    }
}

