/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;

public class ImporterDialog
extends OptionsDialog
implements FocusListener,
ItemListener,
MouseListener {
    public static final String INFO_DEFAULT = "<i>Select an option for a detailed explanation. Documentation written by Glen MacDonald and Curtis Rueden.</i>";
    protected ImporterOptions options;
    protected Checkbox autoscaleBox;
    protected Checkbox colorizeBox;
    protected Checkbox concatenateBox;
    protected Checkbox cropBox;
    protected Checkbox customColorizeBox;
    protected Checkbox groupFilesBox;
    protected Checkbox mergeChannelsBox;
    protected Checkbox openAllSeriesBox;
    protected Checkbox recordBox;
    protected Checkbox showMetadataBox;
    protected Checkbox showOMEXMLBox;
    protected Checkbox showROIsBox;
    protected Checkbox specifyRangesBox;
    protected Checkbox splitZBox;
    protected Checkbox splitTBox;
    protected Checkbox splitCBox;
    protected Choice stackFormatChoice;
    protected Choice stackOrderChoice;
    protected Checkbox swapDimsBox;
    protected Checkbox virtualBox;
    protected Hashtable infoTable;
    protected JEditorPane infoPane;

    public ImporterDialog(ImporterOptions options) {
        super(options);
        this.options = options;
    }

    public int showDialog() {
        GenericDialog gd = new GenericDialog("Bio-Formats Import Options");
        this.addCheckbox(gd, "autoscale");
        this.addCheckbox(gd, "colorize");
        this.addCheckbox(gd, "concatenate");
        this.addCheckbox(gd, "crop");
        this.addCheckbox(gd, "customColorize");
        this.addCheckbox(gd, "groupFiles");
        this.addCheckbox(gd, "mergeChannels");
        this.addCheckbox(gd, "openAllSeries");
        this.addCheckbox(gd, "quiet");
        this.addCheckbox(gd, "record");
        this.addCheckbox(gd, "showMetadata");
        this.addCheckbox(gd, "showOMEXML");
        this.addCheckbox(gd, "showROIs");
        this.addCheckbox(gd, "specifyRanges");
        this.addCheckbox(gd, "splitFocalPlanes");
        this.addCheckbox(gd, "splitTimepoints");
        this.addCheckbox(gd, "splitWindows");
        this.addChoice(gd, "stackFormat");
        this.addChoice(gd, "stackOrder");
        this.addCheckbox(gd, "swapDimensions");
        this.addCheckbox(gd, "virtual");
        Vector<Component> boxes = null;
        Vector<Component> choices = null;
        Vector<Label> labels = null;
        Label stackFormatLabel = null;
        Label stackOrderLabel = null;
        Component[] c = gd.getComponents();
        if (c != null) {
            boxes = new Vector<Component>();
            choices = new Vector<Component>();
            labels = new Vector<Label>();
            for (int i = 0; i < c.length; ++i) {
                Component item;
                if (c[i] instanceof Checkbox) {
                    item = (Checkbox)c[i];
                    item.addFocusListener(this);
                    ((Checkbox)item).addItemListener(this);
                    item.addMouseListener(this);
                    boxes.add(item);
                    continue;
                }
                if (c[i] instanceof Choice) {
                    item = (Choice)c[i];
                    item.addFocusListener(this);
                    ((Choice)item).addItemListener(this);
                    item.addMouseListener(this);
                    choices.add(item);
                    continue;
                }
                if (!(c[i] instanceof Label)) continue;
                labels.add((Label)c[i]);
            }
            this.autoscaleBox = (Checkbox)boxes.get(0);
            this.colorizeBox = (Checkbox)boxes.get(1);
            this.concatenateBox = (Checkbox)boxes.get(2);
            this.cropBox = (Checkbox)boxes.get(3);
            this.customColorizeBox = (Checkbox)boxes.get(4);
            this.groupFilesBox = (Checkbox)boxes.get(5);
            this.mergeChannelsBox = (Checkbox)boxes.get(6);
            this.openAllSeriesBox = (Checkbox)boxes.get(7);
            this.recordBox = (Checkbox)boxes.get(9);
            this.showMetadataBox = (Checkbox)boxes.get(10);
            this.showOMEXMLBox = (Checkbox)boxes.get(11);
            this.showROIsBox = (Checkbox)boxes.get(12);
            this.specifyRangesBox = (Checkbox)boxes.get(13);
            this.splitZBox = (Checkbox)boxes.get(14);
            this.splitTBox = (Checkbox)boxes.get(15);
            this.splitCBox = (Checkbox)boxes.get(16);
            this.stackFormatChoice = (Choice)choices.get(0);
            stackFormatLabel = (Label)labels.get(0);
            this.stackOrderChoice = (Choice)choices.get(1);
            stackOrderLabel = (Label)labels.get(1);
            this.swapDimsBox = (Checkbox)boxes.get(17);
            this.virtualBox = (Checkbox)boxes.get(18);
        }
        this.verifyOptions(null);
        this.infoTable = new Hashtable();
        this.infoTable.put(this.autoscaleBox, this.options.getAutoscaleInfo());
        this.infoTable.put(this.colorizeBox, this.options.getColorizeInfo());
        this.infoTable.put(this.concatenateBox, this.options.getConcatenateInfo());
        this.infoTable.put(this.cropBox, this.options.getCropInfo());
        this.infoTable.put(this.customColorizeBox, this.options.getCustomColorizeInfo());
        this.infoTable.put(this.groupFilesBox, this.options.getGroupFilesInfo());
        this.infoTable.put(this.mergeChannelsBox, this.options.getMergeChannelsInfo());
        this.infoTable.put(this.openAllSeriesBox, this.options.getOpenAllSeriesInfo());
        this.infoTable.put(this.recordBox, this.options.getRecordInfo());
        this.infoTable.put(this.showMetadataBox, this.options.getShowMetadataInfo());
        this.infoTable.put(this.showOMEXMLBox, this.options.getShowOMEXMLInfo());
        this.infoTable.put(this.showROIsBox, this.options.getShowROIsInfo());
        this.infoTable.put(this.specifyRangesBox, this.options.getSpecifyRangesInfo());
        this.infoTable.put(this.splitZBox, this.options.getSplitFocalPlanesInfo());
        this.infoTable.put(this.splitTBox, this.options.getSplitTimepointsInfo());
        this.infoTable.put(this.splitCBox, this.options.getSplitChannelsInfo());
        this.infoTable.put(this.stackFormatChoice, this.options.getStackFormatInfo());
        this.infoTable.put(stackFormatLabel, this.options.getStackFormatInfo());
        this.infoTable.put(this.stackOrderChoice, this.options.getStackOrderInfo());
        this.infoTable.put(stackOrderLabel, this.options.getStackOrderInfo());
        this.infoTable.put(this.swapDimsBox, this.options.getSwapDimensionsInfo());
        this.infoTable.put(this.virtualBox, this.options.getVirtualInfo());
        String cols = "pref, 3dlu, pref:grow, 10dlu, pref";
        String rows = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, fill:100dlu";
        PanelBuilder builder = new PanelBuilder(new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 1;
        builder.addSeparator("Stack viewing", cc.xyw(1, row, 3));
        builder.add((Component)stackFormatLabel, cc.xy(1, row += 2));
        builder.add((Component)this.stackFormatChoice, cc.xy(3, row));
        builder.add((Component)stackOrderLabel, cc.xy(1, row += 2));
        builder.add((Component)this.stackOrderChoice, cc.xy(3, row));
        builder.addSeparator("Dataset organization", cc.xyw(1, row += 4, 3));
        builder.add((Component)this.groupFilesBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.swapDimsBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.openAllSeriesBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.concatenateBox, this.xyw(cc, 1, row += 2, 3));
        builder.addSeparator("Color options", cc.xyw(1, row += 2, 3));
        builder.add((Component)this.mergeChannelsBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.colorizeBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.customColorizeBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.autoscaleBox, this.xyw(cc, 1, row += 2, 3));
        row += 2;
        row = 1;
        builder.addSeparator("Metadata viewing", cc.xy(5, row));
        builder.add((Component)this.showMetadataBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.showOMEXMLBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.showROIsBox, this.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Memory management", cc.xy(5, row += 2));
        builder.add((Component)this.virtualBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.recordBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.specifyRangesBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.cropBox, this.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Split into separate windows", cc.xy(5, row += 2));
        builder.add((Component)this.splitCBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.splitZBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.splitTBox, this.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Information", cc.xyw(1, row += 4, 5));
        this.infoPane = new JEditorPane();
        this.infoPane.setContentType("text/html");
        this.infoPane.setEditable(false);
        this.infoPane.setText("<html><i>Select an option for a detailed explanation. Documentation written by Glen MacDonald and Curtis Rueden.</i>");
        builder.add((Component)new JScrollPane(this.infoPane), cc.xyw(1, row += 2, 5));
        row += 2;
        gd.removeAll();
        gd.add((Component)builder.getPanel());
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        this.options.setAutoscale(gd.getNextBoolean());
        this.options.setColorize(gd.getNextBoolean());
        this.options.setConcatenate(gd.getNextBoolean());
        this.options.setCrop(gd.getNextBoolean());
        this.options.setCustomColorize(gd.getNextBoolean());
        this.options.setGroupFiles(gd.getNextBoolean());
        this.options.setMergeChannels(gd.getNextBoolean());
        this.options.setOpenAllSeries(gd.getNextBoolean());
        this.options.setQuiet(gd.getNextBoolean());
        this.options.setRecord(gd.getNextBoolean());
        this.options.setShowMetadata(gd.getNextBoolean());
        this.options.setShowOMEXML(gd.getNextBoolean());
        this.options.setShowROIs(gd.getNextBoolean());
        this.options.setSpecifyRanges(gd.getNextBoolean());
        this.options.setSplitFocalPlanes(gd.getNextBoolean());
        this.options.setSplitTimepoints(gd.getNextBoolean());
        this.options.setSplitChannels(gd.getNextBoolean());
        this.options.setStackFormat(this.options.getStackFormats()[gd.getNextChoiceIndex()]);
        this.options.setStackOrder(this.options.getStackOrders()[gd.getNextChoiceIndex()]);
        this.options.setSwapDimensions(gd.getNextBoolean());
        this.options.setVirtual(gd.getNextBoolean());
        return 0;
    }

    public void focusGained(FocusEvent e) {
        Object src = e.getSource();
        String text = (String)this.infoTable.get(src);
        this.infoPane.setText("<html>" + text);
        this.infoPane.setCaretPosition(0);
    }

    public void focusLost(FocusEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        this.verifyOptions(e.getSource());
    }

    public void mouseEntered(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof Component) {
            ((Component)src).requestFocusInWindow();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private CellConstraints xyw(CellConstraints cc, int x, int y, int w) {
        return cc.xyw(x, y, w, CellConstraints.LEFT, CellConstraints.CENTER);
    }

    private void verifyOptions(Object src) {
        boolean autoscaleEnabled = this.autoscaleBox.isEnabled();
        boolean colorizeEnabled = this.colorizeBox.isEnabled();
        boolean concatenateEnabled = this.concatenateBox.isEnabled();
        boolean cropEnabled = this.cropBox.isEnabled();
        boolean customColorizeEnabled = this.customColorizeBox.isEnabled();
        boolean groupFilesEnabled = this.groupFilesBox.isEnabled();
        boolean mergeChannelsEnabled = this.mergeChannelsBox.isEnabled();
        boolean openAllSeriesEnabled = this.openAllSeriesBox.isEnabled();
        boolean recordEnabled = this.recordBox.isEnabled();
        boolean showMetadataEnabled = this.showMetadataBox.isEnabled();
        boolean showOMEXMLEnabled = this.showOMEXMLBox.isEnabled();
        boolean specifyRangesEnabled = this.specifyRangesBox.isEnabled();
        boolean splitZEnabled = this.splitZBox.isEnabled();
        boolean splitTEnabled = this.splitTBox.isEnabled();
        boolean splitCEnabled = this.splitCBox.isEnabled();
        boolean stackOrderEnabled = this.stackOrderChoice.isEnabled();
        boolean swapDimsEnabled = this.swapDimsBox.isEnabled();
        boolean virtualEnabled = this.virtualBox.isEnabled();
        boolean isAutoscale = this.autoscaleBox.getState();
        boolean isColorize = this.colorizeBox.getState();
        boolean isConcatenate = this.concatenateBox.getState();
        boolean isCrop = this.cropBox.getState();
        boolean isCustomColorize = this.customColorizeBox.getState();
        boolean isGroupFiles = this.groupFilesBox.getState();
        boolean isMergeChannels = this.mergeChannelsBox.getState();
        boolean isOpenAllSeries = this.openAllSeriesBox.getState();
        boolean isRecord = this.recordBox.getState();
        boolean isShowMetadata = this.showMetadataBox.getState();
        boolean isShowOMEXML = this.showOMEXMLBox.getState();
        boolean isSpecifyRanges = this.specifyRangesBox.getState();
        boolean isSplitZ = this.splitZBox.getState();
        boolean isSplitT = this.splitTBox.getState();
        boolean isSplitC = this.splitCBox.getState();
        String stackFormatValue = this.stackFormatChoice.getSelectedItem();
        boolean isStackNone = stackFormatValue.equals("Metadata only");
        boolean isStackStandard = stackFormatValue.equals("Standard ImageJ");
        boolean isStackHyperstack = stackFormatValue.equals("Hyperstack");
        boolean isStackBrowser = stackFormatValue.equals("Data Browser");
        boolean isStackVisBio = stackFormatValue.equals("VisBio");
        boolean isStackImage5D = stackFormatValue.equals("Image5D");
        boolean isStackView5D = stackFormatValue.equals("View5D");
        String stackOrderValue = this.stackOrderChoice.getSelectedItem();
        boolean isSwap = this.swapDimsBox.getState();
        boolean isVirtual = this.virtualBox.getState();
        boolean bl = stackOrderEnabled = isStackStandard || isStackVisBio;
        if (src == this.stackFormatChoice) {
            stackOrderValue = isStackHyperstack || isStackBrowser || isStackImage5D ? "XYCZT" : (isStackView5D ? "XYZCT" : "Default");
        }
        boolean bl2 = showMetadataEnabled = !isStackNone;
        if (!showMetadataEnabled) {
            isShowMetadata = true;
        }
        boolean bl3 = groupFilesEnabled = !this.options.isOME() && !this.options.isOMERO();
        if (!groupFilesEnabled) {
            isGroupFiles = false;
        } else if (src == this.stackFormatChoice && isStackBrowser) {
            isGroupFiles = true;
        }
        boolean bl4 = virtualEnabled = !isStackNone && !isStackImage5D && !isStackView5D;
        if (!virtualEnabled) {
            isVirtual = false;
        } else if (src == this.stackFormatChoice && isStackBrowser) {
            isVirtual = true;
        }
        recordEnabled = isVirtual;
        if (!recordEnabled) {
            isRecord = false;
        }
        boolean bl5 = specifyRangesEnabled = !isStackNone && !isVirtual;
        if (!specifyRangesEnabled) {
            isSpecifyRanges = false;
        }
        boolean bl6 = cropEnabled = !isStackNone && !isVirtual;
        if (!cropEnabled) {
            isCrop = false;
        }
        boolean bl7 = mergeChannelsEnabled = !isStackImage5D;
        if (!mergeChannelsEnabled) {
            isMergeChannels = false;
        }
        boolean bl8 = colorizeEnabled = !isMergeChannels && !isStackBrowser && !isStackImage5D && !isStackView5D && !isCustomColorize;
        if (!colorizeEnabled) {
            isColorize = false;
        }
        boolean bl9 = customColorizeEnabled = !isMergeChannels && !isStackBrowser && !isStackImage5D && !isStackView5D && !isColorize;
        if (!customColorizeEnabled) {
            isCustomColorize = false;
        }
        boolean bl10 = autoscaleEnabled = !isVirtual;
        if (!autoscaleEnabled) {
            isAutoscale = false;
        }
        boolean splitEnabled = !isStackNone && !isStackBrowser && !isStackVisBio && !isStackImage5D && !isStackView5D && !isVirtual;
        boolean bl11 = splitCEnabled = splitEnabled && !isMergeChannels;
        if (!splitCEnabled) {
            isSplitC = false;
        }
        if (!(splitZEnabled = splitEnabled)) {
            isSplitZ = false;
        }
        if (!(splitTEnabled = splitEnabled)) {
            isSplitT = false;
        }
        this.autoscaleBox.setEnabled(autoscaleEnabled);
        this.colorizeBox.setEnabled(colorizeEnabled);
        this.concatenateBox.setEnabled(concatenateEnabled);
        this.cropBox.setEnabled(cropEnabled);
        this.customColorizeBox.setEnabled(customColorizeEnabled);
        this.groupFilesBox.setEnabled(groupFilesEnabled);
        this.mergeChannelsBox.setEnabled(mergeChannelsEnabled);
        this.openAllSeriesBox.setEnabled(openAllSeriesEnabled);
        this.recordBox.setEnabled(recordEnabled);
        this.showMetadataBox.setEnabled(showMetadataEnabled);
        this.showOMEXMLBox.setEnabled(showOMEXMLEnabled);
        this.specifyRangesBox.setEnabled(specifyRangesEnabled);
        this.splitZBox.setEnabled(splitZEnabled);
        this.splitTBox.setEnabled(splitTEnabled);
        this.splitCBox.setEnabled(splitCEnabled);
        this.stackOrderChoice.setEnabled(stackOrderEnabled);
        this.swapDimsBox.setEnabled(swapDimsEnabled);
        this.virtualBox.setEnabled(virtualEnabled);
        this.autoscaleBox.setState(isAutoscale);
        this.colorizeBox.setState(isColorize);
        this.concatenateBox.setState(isConcatenate);
        this.cropBox.setState(isCrop);
        this.customColorizeBox.setState(isCustomColorize);
        this.groupFilesBox.setState(isGroupFiles);
        this.mergeChannelsBox.setState(isMergeChannels);
        this.openAllSeriesBox.setState(isOpenAllSeries);
        this.recordBox.setState(isRecord);
        this.showMetadataBox.setState(isShowMetadata);
        this.showOMEXMLBox.setState(isShowOMEXML);
        this.specifyRangesBox.setState(isSpecifyRanges);
        this.splitZBox.setState(isSplitZ);
        this.splitTBox.setState(isSplitT);
        this.splitCBox.setState(isSplitC);
        this.stackOrderChoice.select(stackOrderValue);
        this.swapDimsBox.setState(isSwap);
        this.virtualBox.setState(isVirtual);
        if (IS_GLITCHED) {
            int i;
            Component[] c = new Component[]{this.autoscaleBox, this.colorizeBox, this.concatenateBox, this.cropBox, this.customColorizeBox, this.groupFilesBox, this.mergeChannelsBox, this.openAllSeriesBox, this.recordBox, this.showMetadataBox, this.showOMEXMLBox, this.specifyRangesBox, this.splitZBox, this.splitTBox, this.splitCBox, this.stackFormatChoice, this.stackOrderChoice, this.swapDimsBox, this.virtualBox};
            Component focused = null;
            for (i = 0; i < c.length; ++i) {
                if (!c[i].isFocusOwner()) continue;
                focused = c[i];
            }
            for (i = 0; i < c.length; ++i) {
                c[i].removeFocusListener(this);
            }
            for (i = 0; i < c.length; ++i) {
                c[i].requestFocusInWindow();
            }
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.clearGlobalFocusOwner();
            this.sleep(100L);
            if (focused != null) {
                focused.requestFocusInWindow();
            }
            for (int i2 = 0; i2 < c.length; ++i2) {
                c[i2].addFocusListener(this);
            }
        }
    }
}

