/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.meta.MetadataRetrieve;

public class JPEG2000Writer
extends FormatWriter {
    private RandomAccessOutputStream out;

    public JPEG2000Writer() {
        super("JPEG-2000", "jp2");
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(retrieve, series);
        boolean littleEndian = retrieve.getPixelsBigEndian(series, 0) == false;
        int width = retrieve.getPixelsSizeX(series, 0);
        int height = retrieve.getPixelsSizeY(series, 0);
        int bytesPerPixel = FormatTools.getBytesPerPixel(FormatTools.pixelTypeFromString(retrieve.getPixelsPixelType(series, 0)));
        int nChannels = retrieve.getLogicalChannelSamplesPerPixel(series, 0);
        this.out = new RandomAccessOutputStream(this.currentId);
        CodecOptions options = new CodecOptions();
        options.width = width;
        options.height = height;
        options.channels = nChannels;
        options.bitsPerSample = bytesPerPixel * 8;
        options.littleEndian = littleEndian;
        options.interleaved = this.interleaved;
        this.out.write(new JPEG2000Codec().compress(buf, options));
        this.out.close();
    }

    public boolean canDoStacks() {
        return false;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 2, 3};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
    }
}

