/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Vector;
import loci.common.Location;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.LegacyQTTools;
import loci.formats.meta.FilterMetadata;

public class LegacyQTReader
extends FormatReader {
    protected LegacyQTTools tools;
    protected ReflectedUniverse r;
    protected int[] times;
    protected Image image;

    public LegacyQTReader() {
        super("QuickTime", "mov");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] tmp = AWTImageTools.getBytes(this.openImage(no, x, y, w, h), false);
        System.arraycopy(tmp, 0, buf, 0, Math.min(tmp.length, buf.length));
        return buf;
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        try {
            this.r.setVar("time", this.times[no]);
            this.r.exec("moviePlayer.setTime(time)");
            this.r.exec("qtip.redraw(null)");
            this.r.exec("qtip.updateConsumers(null)");
        }
        catch (ReflectException re) {
            throw new FormatException("Open movie failed", re);
        }
        return AWTImageTools.makeBuffered(this.image).getSubimage(x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        try {
            if (this.r != null && this.r.getVar("openMovieFile") != null) {
                this.r.exec("openMovieFile.close()");
                if (!fileOnly) {
                    this.r.exec("m.disposeQTObject()");
                    this.r.exec("imageTrack.disposeQTObject()");
                    this.r.exec("QTSession.close()");
                }
            }
        }
        catch (ReflectException e) {
            this.traceDebug(e);
        }
        if (!fileOnly) {
            this.currentId = null;
            this.times = null;
            this.image = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("LegacyQTReader.initFile(" + id + ")");
        this.status("Checking for QuickTime Java");
        if (this.tools == null) {
            this.tools = new LegacyQTTools();
            this.r = this.tools.getUniverse();
        }
        if (this.tools.isQTExpired()) {
            throw new FormatException("Your version of QuickTime for Java has expired. Please reinstall QuickTime for Java from http://www.apple.com/quicktime/");
        }
        if (!this.tools.canDoQT()) {
            throw new FormatException("QuickTime for Java is required to read some QuickTime files. Please install QuickTime for Java from http://www.apple.com/quicktime/");
        }
        super.initFile(id);
        this.status("Reading movie dimensions");
        try {
            Integer w;
            this.r.exec("QTSession.open()");
            Location file2 = new Location(id);
            this.r.setVar("path", file2.getAbsolutePath());
            this.r.exec("qtf = new QTFile(path)");
            this.r.exec("openMovieFile = OpenMovieFile.asRead(qtf)");
            this.r.exec("m = Movie.fromFile(openMovieFile)");
            int numTracks = (Integer)this.r.exec("m.getTrackCount()");
            int trackMostLikely = 0;
            int trackNum = 0;
            while (++trackNum <= numTracks && trackMostLikely == 0) {
                this.r.setVar("trackNum", trackNum);
                this.r.exec("imageTrack = m.getTrack(trackNum)");
                this.r.exec("d = imageTrack.getSize()");
                w = (Integer)this.r.exec("d.getWidth()");
                if (w <= 0) continue;
                trackMostLikely = trackNum;
            }
            this.r.setVar("trackMostLikely", trackMostLikely);
            this.r.exec("imageTrack = m.getTrack(trackMostLikely)");
            this.r.exec("d = imageTrack.getSize()");
            w = (Integer)this.r.exec("d.getWidth()");
            Integer h = (Integer)this.r.exec("d.getHeight()");
            this.r.exec("moviePlayer = new MoviePlayer(m)");
            this.r.setVar("dim", new Dimension(w, h));
            ImageProducer qtip = (ImageProducer)this.r.exec("qtip = new QTImageProducer(moviePlayer, dim)");
            this.image = Toolkit.getDefaultToolkit().createImage(qtip);
            this.r.setVar("zero", 0);
            this.r.setVar("one", 1.0f);
            this.r.exec("timeInfo = new TimeInfo(zero, zero)");
            this.r.exec("moviePlayer.setTime(zero)");
            Vector<Integer> v = new Vector<Integer>();
            int time = 0;
            Integer q = new Integer(time);
            do {
                v.add(q);
                this.r.exec("timeInfo = imageTrack.getNextInterestingTime(StdQTConstants.nextTimeMediaSample, timeInfo.time, one)");
            } while ((time = (q = (Integer)this.r.getVar("timeInfo.time")).intValue()) >= 0);
            this.core[0].imageCount = v.size();
            this.times = new int[this.getImageCount()];
            for (int i = 0; i < this.times.length; ++i) {
                q = (Integer)v.elementAt(i);
                this.times[i] = q;
            }
            this.status("Populating metadata");
            BufferedImage img = AWTImageTools.makeBuffered(this.image);
            this.core[0].sizeX = img.getWidth();
            this.core[0].sizeY = img.getHeight();
            this.core[0].sizeZ = 1;
            this.core[0].sizeC = img.getRaster().getNumBands();
            this.core[0].sizeT = this.getImageCount();
            this.core[0].pixelType = AWTImageTools.getPixelType(img);
            this.core[0].dimensionOrder = "XYCTZ";
            this.core[0].rgb = true;
            this.core[0].interleaved = false;
            this.core[0].littleEndian = false;
            this.core[0].indexed = false;
            this.core[0].falseColor = false;
            FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            MetadataTools.populatePixels(store, this);
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        catch (ReflectException e) {
            throw new FormatException("Open movie failed", e);
        }
    }
}

