/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class AnalyzeReader
extends FormatReader {
    private int pixelOffset;
    private RandomAccessInputStream pixelFile;
    private String pixelsFilename;

    public AnalyzeReader() {
        super("Analyze 7.5", new String[]{"img", "hdr"});
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int planeSize = FormatTools.getPlaneSize(this);
        this.pixelFile.seek(this.pixelOffset + no * planeSize);
        this.readPlane(this.pixelFile, x, y, w, h, buf);
        return buf;
    }

    public String[] getUsedFiles(boolean noPixels) {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.currentId;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.currentId;
            stringArray = stringArray3;
            stringArray3[1] = this.pixelsFilename;
        }
        return stringArray;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.pixelFile != null) {
            this.pixelFile.close();
        }
        if (!fileOnly) {
            this.pixelOffset = 0;
            this.pixelFile = null;
            this.pixelsFilename = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("AnalyzeReader.initFile(" + id + ")");
        if (id.endsWith(".img")) {
            this.status("Looking for header file");
            String header = id.substring(0, id.lastIndexOf(".")) + ".hdr";
            if (new Location(header).exists()) {
                this.setId(header);
                return;
            }
            throw new FormatException("Header file not found.");
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.pixelsFilename = id.substring(0, id.lastIndexOf(".")) + ".img";
        this.pixelFile = new RandomAccessInputStream(this.pixelsFilename);
        this.status("Reading header");
        int fileSize = this.in.readInt();
        boolean little = (long)fileSize != this.in.length();
        this.in.order(little);
        this.pixelFile.order(little);
        this.in.skipBytes(10);
        String imageName = this.in.readString(18);
        this.addGlobalMeta("Database name", imageName);
        this.in.skipBytes(8);
        short ndims = this.in.readShort();
        this.addGlobalMeta("Number of dimensions", (int)ndims);
        short x = this.in.readShort();
        short y = this.in.readShort();
        short z = this.in.readShort();
        short t = this.in.readShort();
        this.in.skipBytes(20);
        short dataType = this.in.readShort();
        short nBitsPerPixel = this.in.readShort();
        this.addGlobalMeta("Data type", (int)dataType);
        this.addGlobalMeta("Number of bits per pixel", (int)nBitsPerPixel);
        this.in.skipBytes(6);
        float voxelWidth = this.in.readFloat();
        float voxelHeight = this.in.readFloat();
        float sliceThickness = this.in.readFloat();
        float deltaT = this.in.readFloat();
        this.addGlobalMeta("Voxel width", voxelWidth);
        this.addGlobalMeta("Voxel height", voxelHeight);
        this.addGlobalMeta("Slice thickness", sliceThickness);
        this.addGlobalMeta("Exposure time", deltaT);
        this.in.skipBytes(12);
        this.pixelOffset = (int)this.in.readFloat();
        this.addGlobalMeta("Pixel offset", this.pixelOffset);
        this.in.skipBytes(12);
        float calibratedMax = this.in.readFloat();
        float calibratedMin = this.in.readFloat();
        float compressed = this.in.readFloat();
        float verified = this.in.readFloat();
        float pixelMax = this.in.readFloat();
        float pixelMin = this.in.readFloat();
        this.addGlobalMeta("Calibrated maximum", calibratedMax);
        this.addGlobalMeta("Calibrated minimum", calibratedMin);
        this.addGlobalMeta("Compressed", compressed);
        this.addGlobalMeta("Verified", verified);
        this.addGlobalMeta("Pixel maximum", pixelMax);
        this.addGlobalMeta("Pixel minimum", pixelMin);
        String description = this.in.readString(80);
        String auxFile = this.in.readString(24);
        char orient = this.in.readChar();
        String originator = this.in.readString(10);
        String generated = this.in.readString(10);
        String scannum = this.in.readString(10);
        String patientID = this.in.readString(10);
        String expDate = this.in.readString(10);
        String expTime = this.in.readString(10);
        this.in.skipBytes(3);
        int views = this.in.readInt();
        int volsAdded = this.in.readInt();
        int startField = this.in.readInt();
        int fieldSkip = this.in.readInt();
        int omax = this.in.readInt();
        int omin = this.in.readInt();
        int smax = this.in.readInt();
        int smin = this.in.readInt();
        this.addGlobalMeta("Description", description);
        this.addGlobalMeta("Auxiliary file", auxFile);
        this.addGlobalMeta("Orientation", orient);
        this.addGlobalMeta("Originator", originator);
        this.addGlobalMeta("Generated", generated);
        this.addGlobalMeta("Scan Number", scannum);
        this.addGlobalMeta("Patient ID", patientID);
        this.addGlobalMeta("Acquisition Date", expDate);
        this.addGlobalMeta("Acquisition Time", expTime);
        this.status("Populating core metadata");
        this.core[0].sizeX = x;
        this.core[0].sizeY = y;
        this.core[0].sizeZ = z;
        this.core[0].sizeT = t;
        this.core[0].sizeC = 1;
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZTC";
        switch (dataType) {
            case 1: 
            case 2: {
                this.core[0].pixelType = 1;
                break;
            }
            case 4: {
                this.core[0].pixelType = 2;
                break;
            }
            case 8: {
                this.core[0].pixelType = 4;
                break;
            }
            case 16: {
                this.core[0].pixelType = 6;
                break;
            }
            case 64: {
                this.core[0].pixelType = 7;
                break;
            }
            case 128: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 3;
                this.core[0].rgb = true;
                this.core[0].interleaved = true;
                this.core[0].dimensionOrder = "XYCZT";
            }
            default: {
                throw new FormatException("Unsupported data type: " + dataType);
            }
        }
        this.status("Populating MetadataStore");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName(imageName, 0);
        store.setImageDescription(description, 0);
        store.setDimensionsPhysicalSizeX(new Float((double)voxelWidth * 0.001), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float((double)voxelHeight * 0.001), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float((double)sliceThickness * 0.001), 0, 0);
        store.setDimensionsTimeIncrement(new Float(deltaT * 1000.0f), 0, 0);
    }
}

