/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.ConverterImpl;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.MultiplyException;
import ucar.units.OperationException;
import ucar.units.RaiseException;
import ucar.units.Unit;
import ucar.units.UnitName;

public abstract class UnitImpl
implements Unit,
Serializable {
    private final UnitName id;

    protected UnitImpl() {
        this(null);
    }

    protected UnitImpl(UnitName id) {
        this.id = id;
    }

    public final UnitName getUnitName() {
        return this.id;
    }

    public final String getName() {
        return this.id == null ? null : this.id.getName();
    }

    public final String getPlural() {
        return this.id == null ? null : this.id.getPlural();
    }

    public final String getSymbol() {
        return this.id == null ? null : this.id.getSymbol();
    }

    public final Unit multiplyBy(Unit that) throws MultiplyException {
        return this.myMultiplyBy(that);
    }

    protected abstract Unit myMultiplyBy(Unit var1) throws MultiplyException;

    public final Unit divideBy(Unit that) throws OperationException {
        return this.myDivideBy(that);
    }

    protected abstract Unit myDivideBy(Unit var1) throws OperationException;

    public final Unit divideInto(Unit that) throws OperationException {
        return this.myDivideInto(that);
    }

    protected abstract Unit myDivideInto(Unit var1) throws OperationException;

    public final Unit raiseTo(int power) throws RaiseException {
        return this.myRaiseTo(power);
    }

    protected abstract Unit myRaiseTo(int var1) throws RaiseException;

    public Converter getConverterTo(Unit outputUnit) throws ConversionException {
        return new MyConverter(this, outputUnit);
    }

    public float convertTo(float amount, Unit outputUnit) throws ConversionException {
        return (float)this.convertTo((double)amount, outputUnit);
    }

    public double convertTo(double amount, Unit outputUnit) throws ConversionException {
        return this.getConverterTo(outputUnit).convert(amount);
    }

    public float[] convertTo(float[] amounts, Unit outputUnit) throws ConversionException {
        return this.convertTo(amounts, outputUnit, new float[amounts.length]);
    }

    public double[] convertTo(double[] amounts, Unit outputUnit) throws ConversionException {
        return this.convertTo(amounts, outputUnit, new double[amounts.length]);
    }

    public float[] convertTo(float[] input, Unit outputUnit, float[] output) throws ConversionException {
        return this.getConverterTo(outputUnit).convert(input, output);
    }

    public double[] convertTo(double[] input, Unit outputUnit, double[] output) throws ConversionException {
        return this.getConverterTo(outputUnit).convert(input, output);
    }

    public boolean isCompatible(Unit that) {
        DerivedUnit u1 = this.getDerivedUnit();
        return u1.equals(that.getDerivedUnit());
    }

    public boolean equals(Object object) {
        boolean equals;
        if (this == object) {
            equals = true;
        } else if (!(object instanceof Unit)) {
            equals = false;
        } else {
            Unit that = (Unit)object;
            equals = UnitImpl.equalsIgnoreCase(this.getName(), that.getName()) && UnitImpl.equalsIgnoreCase(this.getPlural(), that.getPlural()) && UnitImpl.equals(this.getSymbol(), that.getSymbol());
        }
        return equals;
    }

    private static final boolean equals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    private static final boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public String toString() {
        String string = this.getSymbol();
        return string != null ? string : this.getName();
    }

    public String makeLabel(String quantityID) {
        StringBuffer buf = new StringBuffer(quantityID);
        if (quantityID.indexOf(" ") != -1) {
            buf.insert(0, '(').append(')');
        }
        buf.append('/');
        int start = buf.length();
        buf.append(this.toString());
        if (buf.substring(start).indexOf(32) != -1) {
            buf.insert(start, '(').append(')');
        }
        return buf.toString();
    }

    protected static class MyConverter
    extends ConverterImpl {
        private final DerivableUnit fromUnit;
        private final DerivableUnit toUnit;

        protected MyConverter(Unit fromUnit, Unit toUnit) throws ConversionException {
            super(fromUnit, toUnit);
            if (!(fromUnit instanceof DerivableUnit) || !(toUnit instanceof DerivableUnit)) {
                throw new ConversionException(fromUnit, toUnit);
            }
            this.fromUnit = (DerivableUnit)((Object)fromUnit);
            this.toUnit = (DerivableUnit)((Object)toUnit);
        }

        public double convert(double amount) {
            double output;
            try {
                output = this.toUnit.fromDerivedUnit(this.fromUnit.toDerivedUnit(amount));
            }
            catch (ConversionException e) {
                output = 0.0;
            }
            return output;
        }

        public float[] convert(float[] input, float[] output) {
            try {
                this.toUnit.fromDerivedUnit(this.fromUnit.toDerivedUnit(input, output), output);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            return output;
        }

        public double[] convert(double[] input, double[] output) {
            try {
                this.toUnit.fromDerivedUnit(this.fromUnit.toDerivedUnit(input, output), output);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            return output;
        }
    }
}

