/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import loci.common.Location;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ome.OMEXML2003FCMetadata;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OmeisException;
import ome.xml.DOMUtil;
import ome.xml.r2003fc.ome.OMENode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OmeisImporter {
    private static final boolean DEBUG = false;
    private static final String OMEIS_PATH = "http://localhost/cgi-bin/omeis";
    private static boolean http = false;
    private IFormatReader reader;
    private OMEXMLMetadata omexmlMeta;
    private boolean stitch;

    public OmeisImporter() {
        this(true);
    }

    public OmeisImporter(boolean stitchFiles) {
        this.stitch = stitchFiles;
        this.reader = new ChannelSeparator(new ChannelFiller());
        if (this.stitch) {
            this.reader = new FileStitcher(this.reader);
        }
        this.omexmlMeta = new OMEXML2003FCMetadata();
        this.reader.setOriginalMetadataPopulated(true);
        this.reader.setMetadataStore(this.omexmlMeta);
    }

    public void printVersion() {
        if (http) {
            this.printHttpResponseHeader();
        }
        System.out.println("Bio-Formats OMEIS importer, built on 20 August 2009.");
    }

    public void testIds(int[] fileIds) throws OmeisException, FormatException, IOException {
        Arrays.sort(fileIds);
        String[] ids = new String[fileIds.length];
        for (int i = 0; i < fileIds.length; ++i) {
            Hashtable fileInfo2 = this.getFileInfo(fileIds[i]);
            ids[i] = (String)fileInfo2.get("Name");
            String path = this.getLocalFilePath(fileIds[i]);
            Location.mapId(ids[i], path);
        }
        if (http) {
            this.printHttpResponseHeader();
        }
        boolean[] done = new boolean[fileIds.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fileIds.length; ++i) {
            if (done[i] || ids[i] == null || !this.reader.isThisType(ids[i])) continue;
            this.reader.setId(ids[i]);
            String[] files = this.reader.getUsedFiles();
            if (files == null) continue;
            sb.setLength(0);
            block2: for (int j = files.length - 1; j >= 0; --j) {
                for (int ii = i; ii < fileIds.length; ++ii) {
                    if (files[j] == null) {
                        this.log("Warning: FileID " + fileIds[ii] + " ('" + ids[ii] + "') has null used file #" + j);
                        continue;
                    }
                    if (!files[j].equals(ids[ii])) continue;
                    if (done[ii]) {
                        this.log("Warning: FileID " + fileIds[ii] + " ('" + ids[ii] + "') already belongs to a group");
                    }
                    done[ii] = true;
                    if (j < files.length - 1) {
                        sb.append(" ");
                    }
                    sb.append(fileIds[ii]);
                    continue block2;
                }
            }
            System.out.println(sb.toString());
        }
    }

    public void importIds(int[] fileIds) throws OmeisException, FormatException, IOException {
        boolean doLittle = this.isLittleEndian();
        Arrays.sort(fileIds);
        String[] ids = new String[fileIds.length];
        for (int i = 0; i < fileIds.length; ++i) {
            Hashtable fileInfo2 = this.getFileInfo(fileIds[i]);
            ids[i] = (String)fileInfo2.get("Name");
            String path = this.getLocalFilePath(fileIds[i]);
            Location.mapId(ids[i], path);
        }
        String id = ids[0];
        String path = Location.getMappedId(id);
        this.reader.setId(id);
        String[] used = this.reader.getUsedFiles();
        if (used == null) {
            throw new FormatException("Invalid file list for " + path);
        }
        if (used.length != ids.length) {
            throw new FormatException("File list length mismatch for " + path + ": used=" + this.a2s(used) + "; ids=" + this.a2s(ids));
        }
        boolean[] done = new boolean[ids.length];
        int numLeft = ids.length;
        block13: for (int i = 0; i < used.length; ++i) {
            for (int j = 0; j < ids.length; ++j) {
                if (done[j] || !used[i].equals(ids[j])) continue;
                done[j] = true;
                --numLeft;
                continue block13;
            }
        }
        if (numLeft > 0) {
            throw new FormatException("File list does not correspond to ID list for " + path);
        }
        int seriesCount = this.reader.getSeriesCount();
        OMENode ome = (OMENode)this.omexmlMeta.getRoot();
        Document omeDoc = ome.getDOMElement().getOwnerDocument();
        Vector pix = DOMUtil.findElementList("Pixels", omeDoc);
        if (pix.size() != seriesCount) {
            throw new FormatException("Pixels element count (" + pix.size() + ") does not match series count (" + seriesCount + ") for '" + id + "'");
        }
        for (int s = 0; s < seriesCount; ++s) {
            boolean isFloat;
            boolean isSigned;
            int bytesPerPixel;
            this.reader.setSeries(s);
            int sizeX = this.reader.getSizeX();
            int sizeY = this.reader.getSizeY();
            int sizeZ = this.reader.getSizeZ();
            int sizeC = this.reader.getSizeC();
            int sizeT = this.reader.getSizeT();
            int pixelType = this.reader.getPixelType();
            switch (pixelType) {
                case 0: {
                    bytesPerPixel = 1;
                    isSigned = true;
                    isFloat = false;
                    break;
                }
                case 1: {
                    bytesPerPixel = 1;
                    isSigned = false;
                    isFloat = false;
                    break;
                }
                case 2: {
                    bytesPerPixel = 2;
                    isSigned = true;
                    isFloat = false;
                    break;
                }
                case 3: {
                    bytesPerPixel = 2;
                    isSigned = false;
                    isFloat = false;
                    break;
                }
                case 4: {
                    bytesPerPixel = 4;
                    isSigned = true;
                    isFloat = false;
                    break;
                }
                case 5: {
                    bytesPerPixel = 4;
                    isSigned = false;
                    isFloat = false;
                    break;
                }
                case 6: {
                    bytesPerPixel = 4;
                    isSigned = true;
                    isFloat = true;
                    break;
                }
                case 7: {
                    bytesPerPixel = 8;
                    isSigned = true;
                    isFloat = true;
                    break;
                }
                default: {
                    throw new FormatException("Unknown pixel type for '" + id + "' series #" + s + ": " + pixelType);
                }
            }
            boolean little = this.reader.isLittleEndian();
            boolean swap = doLittle != little && bytesPerPixel > 1 && !isFloat;
            int pixelsId = this.newPixels(sizeX, sizeY, sizeZ, sizeC, sizeT, bytesPerPixel, isSigned, isFloat);
            String pixelsPath = this.getLocalPixelsPath(pixelsId);
            FileOutputStream out = new FileOutputStream(pixelsPath);
            int imageCount = this.reader.getImageCount();
            for (int t = 0; t < sizeT; ++t) {
                for (int c = 0; c < sizeC; ++c) {
                    for (int z = 0; z < sizeZ; ++z) {
                        int ndx = this.reader.getIndex(z, c, t);
                        byte[] plane = this.reader.openBytes(ndx);
                        if (swap) {
                            for (int b = 0; b < plane.length; b += bytesPerPixel) {
                                for (int k = 0; k < bytesPerPixel / 2; ++k) {
                                    byte b2;
                                    int i1 = b + k;
                                    int i2 = b + bytesPerPixel - k - 1;
                                    byte b1 = plane[i1];
                                    plane[i1] = b2 = plane[i2];
                                    plane[i2] = b1;
                                }
                            }
                        }
                        out.write(plane);
                    }
                }
            }
            out.close();
            pixelsId = this.finishPixels(pixelsId);
            String sha1 = this.getPixelsSHA1(pixelsId);
            Element pixels = (Element)pix.elementAt(s);
            pixels.setAttribute("FileSHA1", sha1);
            pixels.setAttribute("ImageServerID", "" + pixelsId);
            pixels.setAttribute("DimensionOrder", "XYZCT");
            String pType = pixels.getAttribute("PixelType");
            if (!pType.startsWith("u")) continue;
            pixels.setAttribute("PixelType", pType.replace('u', 'U'));
        }
        this.reader.close();
        ByteArrayOutputStream xml = new ByteArrayOutputStream();
        try {
            DOMUtil.writeXML(xml, omeDoc);
        }
        catch (TransformerException exc) {
            throw new FormatException(exc);
        }
        xml.close();
        String xmlString = new String(xml.toByteArray());
        if (http) {
            this.printHttpResponseHeader();
        }
        System.out.println(xmlString);
    }

    public String getLocalFilePath(int fileId) throws OmeisException {
        String[] s;
        try {
            s = this.omeis("GetLocalPath", "FileID=" + fileId);
        }
        catch (IOException exc) {
            throw new OmeisException(exc);
        }
        if (s.length > 1) {
            this.log("Warning: ignoring " + (s.length - 1) + " extraneous lines in OMEIS GetLocalPath call");
        } else if (s.length < 1) {
            throw new OmeisException("Failed to obtain local path for file ID " + fileId);
        }
        return s[0];
    }

    public Hashtable getFileInfo(int fileId) throws OmeisException {
        String[] s;
        try {
            s = this.omeis("FileInfo", "FileID=" + fileId);
        }
        catch (IOException exc) {
            throw new OmeisException(exc);
        }
        Hashtable<String, String> info = new Hashtable<String, String>();
        for (int i = 0; i < s.length; ++i) {
            int equals = s[i].indexOf("=");
            if (equals < 0) {
                this.log("Warning: ignoring extraneous line in OMEIS FileInfo call: " + s[i]);
                continue;
            }
            String key = s[i].substring(0, equals);
            String value = s[i].substring(equals + 1);
            info.put(key, value);
        }
        return info;
    }

    public int newPixels(int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int bytesPerPixel, boolean isSigned, boolean isFloat) throws OmeisException {
        String[] s;
        try {
            s = this.omeis("NewPixels", "Dims=" + sizeX + "," + sizeY + "," + sizeZ + "," + sizeC + "," + sizeT + "," + bytesPerPixel + " IsSigned=" + (isSigned ? 1 : 0) + " IsFloat=" + (isFloat ? 1 : 0));
        }
        catch (IOException exc) {
            throw new OmeisException(exc);
        }
        if (s.length > 1) {
            this.log("Warning: ignoring " + (s.length - 1) + " extraneous lines in OMEIS NewPixels call output");
        } else if (s.length < 1) {
            throw new OmeisException("Failed to obtain pixels ID from NewPixels");
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(s[0]);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (pid <= 0) {
            throw new OmeisException("Invalid pixels ID from NewPixels: " + s[0]);
        }
        return pid;
    }

    public boolean isLittleEndian() throws OmeisException {
        String[] s;
        try {
            s = this.omeis("GetNativeEndian", "");
        }
        catch (IOException exc) {
            throw new OmeisException(exc);
        }
        if (s.length > 1) {
            this.log("Warning: ignoring " + (s.length - 1) + " extraneous lines in OMEIS GetLocalPath call output");
        } else if (s.length < 1) {
            throw new OmeisException("Failed to obtain endianness value");
        }
        if ("little".equalsIgnoreCase(s[0])) {
            return true;
        }
        if ("big".equalsIgnoreCase(s[0])) {
            return false;
        }
        throw new OmeisException("Invalid endianness value: " + s[0]);
    }

    public String getLocalPixelsPath(int pixelsId) throws OmeisException {
        String[] s;
        try {
            s = this.omeis("GetLocalPath", "PixelsID=" + pixelsId);
        }
        catch (IOException exc) {
            throw new OmeisException(exc);
        }
        if (s.length > 1) {
            this.log("Warning: ignoring " + (s.length - 1) + " extraneous lines in OMEIS GetLocalPath call");
        } else if (s.length < 1) {
            throw new OmeisException("Failed to obtain local path for pixels ID " + pixelsId);
        }
        return s[0];
    }

    public int finishPixels(int pixelsId) throws OmeisException {
        String[] s;
        try {
            s = this.omeis("FinishPixels", "PixelsID=" + pixelsId);
        }
        catch (IOException exc) {
            throw new OmeisException(exc);
        }
        if (s.length > 1) {
            this.log("Warning: ignoring " + (s.length - 1) + " extraneous lines in OMEIS FinishPixels call output");
        } else if (s.length < 1) {
            throw new OmeisException("Failed to obtain pixels ID from FinishPixels");
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(s[0]);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (pid <= 0) {
            throw new OmeisException("Invalid pixels ID from FinishPixels: " + s[0]);
        }
        return pid;
    }

    public String getPixelsSHA1(int pixelsId) throws OmeisException {
        String[] s;
        try {
            s = this.omeis("PixelsSHA1", "PixelsID=" + pixelsId);
        }
        catch (IOException exc) {
            throw new OmeisException(exc);
        }
        if (s.length > 1) {
            this.log("Warning: ignoring " + (s.length - 1) + " extraneous lines in OMEIS PixelsSHA1 call");
        } else if (s.length < 1) {
            throw new OmeisException("Failed to obtain SHA1 for pixels ID " + pixelsId);
        }
        return s[0];
    }

    private String[] omeis(String method, String params) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer(OMEIS_PATH);
        sb.append("?Method=");
        sb.append(method);
        StringTokenizer st = new StringTokenizer(params);
        while (st.hasMoreTokens()) {
            sb.append("&");
            sb.append(st.nextToken());
        }
        String url = sb.toString();
        BufferedReader in = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
        Vector<String> v = new Vector<String>();
        while ((line = in.readLine()) != null) {
            v.add(line);
        }
        Object[] results = new String[v.size()];
        v.copyInto(results);
        return results;
    }

    private void log(String msg) {
        System.err.println("Bio-Formats: " + msg);
    }

    private String a2s(String[] s) {
        StringBuffer sb = new StringBuffer();
        if (s == null) {
            return "null";
        }
        sb.append("[");
        if (s.length > 0) {
            sb.append(s[0]);
        }
        for (int i = 1; i < s.length; ++i) {
            sb.append(" ");
            sb.append(s[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    private void printHttpErrorHeader() {
        System.out.print("Status: 500 Server Error\r\n");
        System.out.print("Content-Type: text/plain\r\n\r\n");
    }

    private void printHttpResponseHeader() {
        System.out.print("Status: 200 OK\r\n");
        System.out.print("Content-Type: text/plain\r\n\r\n");
    }

    public static void main(String[] args) {
        boolean version = false;
        boolean test = false;
        boolean stitch = true;
        int[] fileIds = new int[args.length];
        int num = 0;
        for (int i = 0; i < args.length; ++i) {
            if ("-version".equalsIgnoreCase(args[i])) {
                version = true;
                continue;
            }
            if ("-test".equalsIgnoreCase(args[i])) {
                test = true;
                continue;
            }
            if ("-http-response".equalsIgnoreCase(args[i])) {
                http = true;
                continue;
            }
            if ("-nostitch".equalsIgnoreCase(args[i])) {
                stitch = false;
                continue;
            }
            try {
                int q = Integer.parseInt(args[i]);
                fileIds[num++] = q;
                continue;
            }
            catch (NumberFormatException exc) {
                System.err.println("Warning: ignoring parameter: " + args[i]);
            }
        }
        int[] trimIds = new int[num];
        System.arraycopy(fileIds, 0, trimIds, 0, num);
        fileIds = trimIds;
        OmeisImporter importer = new OmeisImporter(stitch);
        try {
            if (version) {
                importer.printVersion();
            } else if (test) {
                importer.testIds(fileIds);
            } else {
                importer.importIds(fileIds);
            }
        }
        catch (Throwable t) {
            if (http) {
                importer.printHttpErrorHeader();
                System.out.println("An exception occurred while processing FileIDs:");
                t.printStackTrace(System.out);
            }
            System.err.println("An exception occurred:");
            t.printStackTrace();
            System.exit(1);
        }
    }
}

