/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PrairieReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    public static final String[] PRAIRIE_SUFFIXES = new String[]{"cfg", "xml"};
    private static final int PRAIRIE_TAG_1 = 33628;
    private static final int PRAIRIE_TAG_2 = 33629;
    private static final int PRAIRIE_TAG_3 = 33630;
    private String[] files;
    private MinimalTiffReader tiff;
    private String xmlFile;
    private String cfgFile;
    private boolean readXML = false;
    private boolean readCFG = false;
    private int zt;
    private Vector f;
    private Vector gains;
    private Vector offsets;
    private boolean isZ;
    private float pixelSizeX;
    private float pixelSizeY;
    private String date;
    private String laserPower;

    public PrairieReader() {
        super("Prairie TIFF", new String[]{"tif", "tiff", "cfg", "xml"});
        this.blockCheckLen = 0x100020;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (PrairieReader.checkSuffix(name, CFG_SUFFIX)) {
            if (prefix.lastIndexOf("Config") == -1) {
                return false;
            }
            prefix = prefix.substring(0, prefix.lastIndexOf("Config"));
        }
        if (prefix.indexOf("_") != -1) {
            prefix = prefix.substring(0, prefix.indexOf("_"));
        }
        Location xml = new Location(prefix + ".xml");
        Location cfg = new Location(prefix + "Config.cfg");
        boolean hasMetadataFiles = xml.exists() && cfg.exists();
        return hasMetadataFiles && super.isThisType(name, false);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        String s = stream.readString(this.blockCheckLen);
        if (s.indexOf("xml") != -1 && s.indexOf("PV") != -1) {
            return true;
        }
        Hashtable ifd = TiffTools.getFirstIFD(stream);
        String software = (String)TiffTools.getIFDValue(ifd, 305);
        return software.indexOf("Prairie") != -1 && ifd.containsKey(new Integer(33628)) && ifd.containsKey(new Integer(33629)) && ifd.containsKey(new Integer(33630));
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.xmlFile, this.cfgFile};
        }
        String[] s = new String[this.files.length + 2];
        System.arraycopy(this.files, 0, s, 0, this.files.length);
        s[this.files.length] = this.xmlFile;
        s[this.files.length + 1] = this.cfgFile;
        return s;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        this.tiff.setId(this.files[no]);
        return this.tiff.openBytes(0, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly && this.tiff != null) {
            this.tiff.close(fileOnly);
        } else if (!fileOnly) {
            this.close();
        }
    }

    public void close() throws IOException {
        if (this.tiff != null) {
            this.tiff.close();
        }
        this.cfgFile = null;
        this.xmlFile = null;
        this.currentId = null;
        this.tiff = null;
        this.files = null;
        this.readXML = false;
        this.readCFG = false;
        this.isZ = false;
        this.zt = 0;
        this.f = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("PrairieReader.initFile(" + id + ")");
        if (this.metadata == null) {
            this.metadata = new Hashtable();
        }
        if (this.core == null) {
            this.core = new CoreMetadata[]{new CoreMetadata()};
        }
        if (PrairieReader.checkSuffix(id, PRAIRIE_SUFFIXES)) {
            this.status("Parsing XML");
            if (PrairieReader.checkSuffix(id, XML_SUFFIX)) {
                super.initFile(id);
                this.tiff = new MinimalTiffReader();
                this.xmlFile = id;
                this.readXML = true;
            } else if (PrairieReader.checkSuffix(id, CFG_SUFFIX)) {
                this.cfgFile = id;
                this.readCFG = true;
            }
            this.f = new Vector();
            this.gains = new Vector();
            this.offsets = new Vector();
            this.zt = 0;
            RandomAccessInputStream is = new RandomAccessInputStream(id);
            byte[] b = new byte[(int)is.length()];
            is.read(b);
            is.close();
            if (PrairieReader.checkSuffix(id, XML_SUFFIX)) {
                this.core[0].imageCount = 0;
            }
            PrairieHandler handler = new PrairieHandler();
            DataTools.parseXML(b, (DefaultHandler)handler);
            if (PrairieReader.checkSuffix(id, XML_SUFFIX)) {
                this.files = new String[this.f.size()];
                this.f.copyInto(this.files);
                this.tiff.setId(this.files[0]);
                this.status("Populating metadata");
                if (this.zt == 0) {
                    this.zt = 1;
                }
                this.core[0].sizeZ = this.isZ ? this.zt : 1;
                this.core[0].sizeT = this.isZ ? 1 : this.zt;
                this.core[0].sizeC = this.getImageCount() / (this.getSizeZ() * this.getSizeT());
                this.core[0].dimensionOrder = "XYC" + (this.isZ ? "ZT" : "TZ");
                this.core[0].pixelType = 3;
                this.core[0].rgb = false;
                this.core[0].interleaved = false;
                this.core[0].littleEndian = this.tiff.isLittleEndian();
                this.core[0].indexed = this.tiff.isIndexed();
                this.core[0].falseColor = false;
                FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
                MetadataTools.populatePixels(store, this);
                store.setInstrumentID("Instrument:0", 0);
                store.setImageInstrumentRef("Instrument:0", 0);
                store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), 0, 0);
                store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), 0, 0);
                for (int i = 0; i < this.getSizeC(); ++i) {
                    String offset;
                    String gain = i < this.gains.size() ? (String)this.gains.get(i) : null;
                    String string = offset = i < this.offsets.size() ? (String)this.offsets.get(i) : null;
                    if (offset != null) {
                        store.setDetectorSettingsOffset(new Float(offset), 0, i);
                    }
                    if (gain != null) {
                        store.setDetectorSettingsGain(new Float(gain), 0, i);
                    }
                    store.setDetectorID("Detector:" + i, 0, i);
                    store.setDetectorSettingsDetector("Detector:" + i, 0, i);
                    store.setDetectorType("Unknown", 0, i);
                }
                store.setImageName("", 0);
                if (this.date != null) {
                    SimpleDateFormat parse = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a");
                    Date d = parse.parse(this.date, new ParsePosition(0));
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    this.date = fmt.format(d);
                    store.setImageCreationDate(this.date, 0);
                } else {
                    MetadataTools.setDefaultCreationDate(store, id, 0);
                }
            }
            if (!this.readXML || !this.readCFG) {
                File file2 = new File(id).getAbsoluteFile();
                File parent = file2.getParentFile();
                String[] listing = file2.exists() ? parent.list() : Location.getIdMap().keySet().toArray(new String[0]);
                for (int i = 0; i < listing.length; ++i) {
                    if ((this.readXML || !PrairieReader.checkSuffix(listing[i], XML_SUFFIX)) && (!this.readXML || !PrairieReader.checkSuffix(listing[i], CFG_SUFFIX))) continue;
                    String dir = "";
                    if (file2.exists() && !(dir = parent.getPath()).endsWith(File.separator)) {
                        dir = dir + File.separator;
                    }
                    this.initFile(dir + listing[i]);
                }
            }
        } else {
            this.status("Finding XML file");
            Location file3 = new Location(id);
            file3 = file3.getAbsoluteFile();
            Location parent = file3.getParentFile();
            String[] listing = parent.list();
            for (int i = 0; i < listing.length; ++i) {
                if (!PrairieReader.checkSuffix(listing[i], PRAIRIE_SUFFIXES)) continue;
                this.initFile(new Location(parent, listing[i]).getAbsolutePath());
            }
        }
        if (this.currentId == null) {
            this.currentId = id;
        }
    }

    public class PrairieHandler
    extends DefaultHandler {
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("PVScan")) {
                PrairieReader.this.date = attributes.getValue("date");
            } else if (qName.equals("Frame")) {
                PrairieReader.this.zt++;
            } else if (qName.equals("Sequence")) {
                PrairieReader.this.isZ = attributes.getValue("type").equals("ZSeries");
            } else if (qName.equals("File")) {
                ++((PrairieReader)PrairieReader.this).core[0].imageCount;
                File current = new File(PrairieReader.this.currentId).getAbsoluteFile();
                String dir = "";
                if (current.exists()) {
                    dir = current.getPath();
                    dir = dir.substring(0, dir.lastIndexOf(File.separator) + 1);
                }
                PrairieReader.this.f.add(dir + attributes.getValue("filename"));
            } else if (qName.equals("Key")) {
                String key = attributes.getValue("key");
                String value = attributes.getValue("value");
                PrairieReader.this.addMeta(key, value);
                if (key.equals("pixelsPerLine")) {
                    ((PrairieReader)PrairieReader.this).core[0].sizeX = Integer.parseInt(value);
                } else if (key.equals("linesPerFrame")) {
                    ((PrairieReader)PrairieReader.this).core[0].sizeY = Integer.parseInt(value);
                } else if (key.equals("micronsPerPixel_XAxis")) {
                    PrairieReader.this.pixelSizeX = Float.parseFloat(value);
                } else if (key.equals("micronsPerPixel_YAxis")) {
                    PrairieReader.this.pixelSizeY = Float.parseFloat(value);
                } else if (key.startsWith("pmtGain_")) {
                    PrairieReader.this.gains.add(value);
                } else if (key.startsWith("pmtOffset_")) {
                    PrairieReader.this.offsets.add(value);
                } else if (key.equals("laserPower_0")) {
                    PrairieReader.this.laserPower = value;
                }
            }
        }
    }
}

