/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class LeicaHandler
extends DefaultHandler {
    private String series;
    private String fullSeries;
    private int count = 0;
    private int numChannels;
    private int extras;
    private boolean firstElement = true;
    private boolean dcroiOpen = false;
    private Vector extraDims = new Vector();
    private Vector channels = new Vector();
    private Vector widths = new Vector();
    private Vector heights = new Vector();
    private Vector zs = new Vector();
    private Vector ts = new Vector();
    private Vector bps = new Vector();
    private Vector seriesNames = new Vector();
    private Vector containerNames = new Vector();
    private Vector containerCounts = new Vector();
    private Vector xcal;
    private Vector ycal;
    private Vector zcal;
    private Vector bits;
    private Vector lutNames;
    private int numDatasets;
    private Hashtable metadata = new Hashtable();
    private MetadataStore store;
    private Vector nextPlane;
    private int nextLaser;
    private int nextDetector;
    private Vector laserNames;
    private Vector detectorNames;
    private Vector xPosition;
    private Vector yPosition;
    private Vector zPosition;
    private Hashtable timestamps;

    public LeicaHandler(MetadataStore store) {
        this.xcal = new Vector();
        this.ycal = new Vector();
        this.zcal = new Vector();
        this.bits = new Vector();
        this.lutNames = new Vector();
        this.nextPlane = new Vector();
        this.laserNames = new Vector();
        this.detectorNames = new Vector();
        this.xPosition = new Vector();
        this.yPosition = new Vector();
        this.zPosition = new Vector();
        this.timestamps = new Hashtable();
        this.store = store;
    }

    public Vector getExtraDims() {
        return this.extraDims;
    }

    public Vector getChannels() {
        return this.channels;
    }

    public Vector getWidths() {
        return this.widths;
    }

    public Vector getHeights() {
        return this.heights;
    }

    public Vector getZs() {
        return this.zs;
    }

    public Vector getTs() {
        return this.ts;
    }

    public Vector getBPS() {
        return this.bps;
    }

    public Vector getSeriesNames() {
        return this.seriesNames;
    }

    public Vector getContainerNames() {
        return this.containerNames;
    }

    public Vector getContainerCounts() {
        return this.containerCounts;
    }

    public Hashtable getMetadata() {
        return this.metadata;
    }

    public int getNumDatasets() {
        return this.numDatasets;
    }

    public Vector getXCal() {
        return this.xcal;
    }

    public Vector getYCal() {
        return this.ycal;
    }

    public Vector getZCal() {
        return this.zcal;
    }

    public Vector getBits() {
        return this.bits;
    }

    public Vector getLutNames() {
        return this.lutNames;
    }

    public Vector getXPosition() {
        return this.xPosition;
    }

    public Vector getYPosition() {
        return this.yPosition;
    }

    public Vector getZPosition() {
        return this.zPosition;
    }

    public Hashtable getTimestamps() {
        return this.timestamps;
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("Element")) {
            if (this.dcroiOpen) {
                this.dcroiOpen = false;
                return;
            }
            this.fullSeries = this.fullSeries.indexOf("/") != -1 ? this.fullSeries.substring(0, this.fullSeries.indexOf("/")) : "";
            this.extraDims.add(new Integer(this.extras));
            if (this.numChannels == 0) {
                this.numChannels = 1;
            }
            this.channels.add(new Integer(this.numChannels));
            if (this.widths.size() < this.numDatasets && this.heights.size() < this.numDatasets) {
                --this.numDatasets;
            } else if (this.widths.size() > this.numDatasets) {
                this.numDatasets = this.widths.size();
            }
            if (this.widths.size() < this.numDatasets) {
                this.widths.add(new Integer(1));
            }
            if (this.heights.size() < this.numDatasets) {
                this.heights.add(new Integer(0));
            }
            if (this.zs.size() < this.numDatasets) {
                this.zs.add(new Integer(1));
            }
            if (this.ts.size() < this.numDatasets) {
                this.ts.add(new Integer(1));
            }
            if (this.bps.size() < this.numDatasets) {
                this.bps.add(new Integer(8));
            }
            this.numChannels = 0;
            this.extras = 1;
            this.nextLaser = 0;
            this.nextDetector = 0;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("Element")) {
            if (!attributes.getValue("Name").equals("DCROISet") && !this.firstElement) {
                this.series = attributes.getValue("Name");
                this.containerNames.add(this.series);
                this.fullSeries = this.fullSeries == null || this.fullSeries.equals("") ? this.series : this.fullSeries + "/" + this.series;
            } else if (this.firstElement) {
                this.firstElement = false;
            }
            if (attributes.getValue("Name").equals("DCROISet")) {
                this.dcroiOpen = true;
            }
            ++this.numDatasets;
            int idx = this.numDatasets - 1;
            if (idx >= this.seriesNames.size()) {
                this.numDatasets = this.seriesNames.size();
            }
            if (!this.dcroiOpen) {
                this.numChannels = 0;
                this.extras = 1;
            }
        } else if (qName.equals("Experiment")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.metadata.put(attributes.getQName(i), attributes.getValue(i));
            }
        } else if (qName.equals("Image")) {
            this.containerNames.remove(this.series);
            if (this.containerCounts.size() < this.containerNames.size()) {
                this.containerCounts.add(new Integer(1));
            } else if (this.containerCounts.size() > 0) {
                int ndx = this.containerCounts.size() - 1;
                int n = (Integer)this.containerCounts.get(ndx);
                this.containerCounts.setElementAt(new Integer(n + 1), ndx);
            }
            if (this.fullSeries == null || this.fullSeries.equals("")) {
                this.fullSeries = this.series;
            }
            this.seriesNames.add(this.fullSeries);
            this.nextPlane.add(new Integer(0));
        } else if (qName.equals("ChannelDescription")) {
            String prefix = "Channel " + this.count + " - ";
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.metadata.put(prefix + attributes.getQName(i), attributes.getValue(i));
            }
            ++this.count;
            ++this.numChannels;
            if (this.channels.size() > this.seriesNames.size() - 1) {
                this.channels.setElementAt(new Integer(this.count), this.seriesNames.size() - 1);
            } else {
                this.channels.add(new Integer(this.count));
            }
            if (this.numChannels == 1) {
                this.bps.add(new Integer(attributes.getValue("Resolution")));
            }
            this.lutNames.add(attributes.getValue("LUTName"));
        } else if (qName.equals("DimensionDescription")) {
            String prefix = "Dimension " + this.count + " - ";
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.metadata.put(prefix + attributes.getQName(i), attributes.getValue(i));
            }
            int len = Integer.parseInt(attributes.getValue("NumberOfElements"));
            int id = Integer.parseInt(attributes.getValue("DimID"));
            switch (id) {
                case 1: {
                    this.widths.add(new Integer(len));
                    int b = Integer.parseInt(attributes.getValue("BytesInc"));
                    this.bits.add(new Integer(b * 8));
                    break;
                }
                case 2: {
                    if (this.widths.size() == this.heights.size()) {
                        if (this.zs.size() == this.heights.size()) {
                            this.zs.setElementAt(new Integer(len), this.zs.size() - 1);
                            break;
                        }
                        if (this.ts.size() != this.heights.size()) break;
                        this.ts.setElementAt(new Integer(len), this.ts.size() - 1);
                        break;
                    }
                    this.heights.add(new Integer(len));
                    break;
                }
                case 3: {
                    if (this.heights.size() < this.widths.size()) {
                        this.heights.add(new Integer(len));
                        this.zs.add(new Integer(1));
                        break;
                    }
                    this.zs.add(new Integer(len));
                    break;
                }
                case 4: {
                    if (this.heights.size() < this.widths.size()) {
                        this.heights.add(new Integer(len));
                        this.ts.add(new Integer(1));
                        break;
                    }
                    this.ts.add(new Integer(len));
                    break;
                }
                default: {
                    this.extras *= len;
                }
            }
            ++this.count;
        } else if (qName.equals("ScannerSettingRecord")) {
            String identifier = attributes.getValue("Identifier");
            String key = identifier + " - " + attributes.getValue("Description");
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                key = this.fullSeries + " - " + key;
            }
            this.metadata.put(key, attributes.getValue("Variant"));
            if (identifier.startsWith("dblVoxel")) {
                String size = attributes.getValue("Variant");
                float cal = Float.parseFloat(size) * 1000000.0f;
                if (identifier.endsWith("X")) {
                    this.xcal.add(new Float(cal));
                } else if (identifier.endsWith("Y")) {
                    this.ycal.add(new Float(cal));
                } else if (identifier.endsWith("Z")) {
                    this.zcal.add(new Float(cal));
                }
            }
        } else if (qName.equals("FilterSettingRecord")) {
            String object = attributes.getValue("ObjectName");
            String key = object + " - " + attributes.getValue("Description") + " - " + attributes.getValue("Attribute");
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                key = this.fullSeries + " - " + key;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.metadata.put(key + " - " + name, value);
                if (!name.equals("Variant")) continue;
                if (key.endsWith("NumericalAperture")) {
                    this.store.setObjectiveLensNA(new Float(value), 0, 0);
                    continue;
                }
                if (key.endsWith("HighVoltage")) {
                    if (!this.detectorNames.contains(object)) {
                        this.detectorNames.add(object);
                    }
                    int detector = this.detectorNames.indexOf(object);
                    this.store.setDetectorID("Detector:" + detector, 0, detector);
                    this.store.setDetectorVoltage(new Float(value), 0, detector);
                    this.store.setDetectorType("Unknown", 0, detector);
                    this.store.setDetectorSettingsDetector("Detector:" + detector, this.seriesNames.size() - 1, this.nextDetector);
                    ++this.nextDetector;
                    continue;
                }
                if (key.endsWith("VideoOffset")) {
                    this.store.setDetectorOffset(new Float(value), 0, 0);
                    this.store.setDetectorType("Unknown", 0, 0);
                    continue;
                }
                if (key.endsWith("OrderNumber")) {
                    this.store.setObjectiveSerialNumber(value, 0, 0);
                    continue;
                }
                if (key.endsWith("Objective")) {
                    StringTokenizer tokens = new StringTokenizer(value, " ");
                    boolean foundMag = false;
                    StringBuffer model = new StringBuffer();
                    while (!foundMag) {
                        String token = tokens.nextToken();
                        if (token.indexOf("x") != -1) {
                            foundMag = true;
                            String mag = token.substring(0, token.indexOf("x"));
                            String na = token.substring(token.indexOf("x") + 1);
                            this.store.setObjectiveNominalMagnification(new Integer((int)Float.parseFloat(mag)), 0, 0);
                            this.store.setObjectiveLensNA(new Float(na), 0, 0);
                            break;
                        }
                        model.append(token);
                        model.append(" ");
                    }
                    if (tokens.hasMoreTokens()) {
                        String immersion = tokens.nextToken();
                        if (immersion == null || immersion.trim().equals("")) {
                            immersion = "Unknown";
                        }
                        this.store.setObjectiveImmersion(immersion, 0, 0);
                    }
                    if (tokens.countTokens() > 1) {
                        Float temperature = new Float(tokens.nextToken());
                        tokens.nextToken();
                    }
                    if (tokens.hasMoreTokens()) {
                        this.store.setObjectiveCorrection(tokens.nextToken(), 0, 0);
                    }
                    this.store.setObjectiveModel(model.toString(), 0, 0);
                    continue;
                }
                if (key.endsWith("RefractionIndex")) {
                    this.store.setObjectiveID("Objective:0", 0, 0);
                    this.store.setObjectiveSettingsObjective("Objective:0", this.seriesNames.size() - 1);
                    this.store.setObjectiveSettingsRefractiveIndex(new Float(value), this.seriesNames.size() - 1);
                    continue;
                }
                if (key.endsWith("Laser wavelength - Wavelength")) {
                    if (this.laserNames.contains(object)) continue;
                    int index = this.laserNames.size();
                    this.store.setLightSourceID("LightSource:" + index, 0, index);
                    this.store.setLaserType("Unknown", 0, index);
                    this.store.setLaserWavelength(new Integer(value), 0, index);
                    this.store.setLaserLaserMedium("Unknown", 0, index);
                    this.laserNames.add(object);
                    continue;
                }
                if (key.endsWith("Laser output power - Output Power")) {
                    if (!this.laserNames.contains(object)) {
                        this.laserNames.add(object);
                    }
                    int laser = this.laserNames.indexOf(object);
                    this.store.setLightSourcePower(new Float(value), 0, laser);
                    this.store.setLightSourceSettingsLightSource("LightSource:" + laser, this.seriesNames.size() - 1, this.nextLaser);
                    ++this.nextLaser;
                    continue;
                }
                if (key.endsWith("Stage Pos x - XPos")) {
                    while (this.xPosition.size() < this.seriesNames.size() - 1) {
                        this.xPosition.add(null);
                    }
                    this.xPosition.add(new Float(value));
                    continue;
                }
                if (key.endsWith("Stage Pos y - YPos")) {
                    while (this.yPosition.size() < this.seriesNames.size() - 1) {
                        this.yPosition.add(null);
                    }
                    this.yPosition.add(new Float(value));
                    continue;
                }
                if (!key.endsWith("Stage Pos z - ZPos")) continue;
                while (this.zPosition.size() < this.seriesNames.size() - 1) {
                    this.zPosition.add(null);
                }
                this.zPosition.add(new Float(value));
            }
        } else if (qName.equals("ATLConfocalSettingDefinition")) {
            if (this.fullSeries == null) {
                this.fullSeries = "";
            }
            if (this.fullSeries.endsWith(" - Master sequential setting")) {
                this.fullSeries = this.fullSeries.replaceAll("Master sequential setting", "Sequential Setting 0");
            }
            if (this.fullSeries.indexOf("Sequential Setting ") == -1) {
                this.fullSeries = this.fullSeries.equals("") ? "Master sequential setting" : this.fullSeries + " - Master sequential setting";
            } else {
                int ndx = this.fullSeries.indexOf("Sequential Setting ") + 19;
                try {
                    int n = Integer.parseInt(this.fullSeries.substring(ndx)) + 1;
                    this.fullSeries = this.fullSeries.substring(0, ndx) + String.valueOf(n);
                }
                catch (NumberFormatException exc) {
                    this.fullSeries = this.fullSeries.substring(0, this.fullSeries.indexOf("-")).trim();
                }
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.metadata.put(this.fullSeries + " - " + name, value);
                int s = this.seriesNames.size() - 1;
                if (name.equals("StagePosX")) {
                    this.store.setStagePositionPositionX(new Float(value), s, 0, 0);
                    continue;
                }
                if (name.equals("StagePosY")) {
                    this.store.setStagePositionPositionY(new Float(value), s, 0, 0);
                    continue;
                }
                if (!name.equals("StagePosZ")) continue;
                this.store.setStagePositionPositionZ(new Float(value), s, 0, 0);
            }
        } else if (qName.equals("Wheel")) {
            String prefix = qName + " " + this.count + " - ";
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.metadata.put(prefix + attributes.getQName(i), attributes.getValue(i));
            }
            ++this.count;
        } else if (qName.equals("WheelName")) {
            String prefix = "Wheel " + (this.count - 1) + " - WheelName ";
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            int ndx = 0;
            while (this.metadata.get(prefix + ndx) != null) {
                ++ndx;
            }
            this.metadata.put(prefix + ndx, attributes.getValue("FilterName"));
        } else if (qName.equals("MultiBand")) {
            String prefix = qName + " Channel " + attributes.getValue("Channel");
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            int s = this.seriesNames.size() - 1;
            int channel = Integer.parseInt(attributes.getValue("Channel")) - 1;
            int channelCount = s < this.channels.size() ? (Integer)this.channels.get(s) : 1;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.metadata.put(prefix + " - " + name, value);
                if (name.equals("LeftWorld") && channel < channelCount) {
                    this.store.setLogicalChannelEmWave(new Integer((int)Float.parseFloat(value)), s, channel);
                    continue;
                }
                if (name.equals("RightWorld") && channel < channelCount) {
                    this.store.setLogicalChannelExWave(new Integer((int)Float.parseFloat(value)), s, channel);
                    continue;
                }
                if (!name.equals("DyeName") || channel >= channelCount) continue;
                this.store.setLogicalChannelName(value, s, channel);
            }
        } else if (qName.equals("LaserLineSetting")) {
            String prefix = "LaserLine " + attributes.getValue("LaserLine");
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                if (name.equals("LaserLine")) continue;
                this.metadata.put(prefix + " - " + name, attributes.getValue(i));
                this.store.setLaserWavelength(new Integer(attributes.getValue("LaserLine")), 0, Integer.parseInt(attributes.getValue("LineIndex")));
            }
        } else if (qName.equals("Detector")) {
            String prefix = qName + " Channel " + attributes.getValue("Channel");
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                if (name.equals("Channel")) continue;
                this.metadata.put(prefix + " - " + name, attributes.getValue(i));
            }
        } else if (qName.equals("Laser")) {
            String prefix = qName + " " + attributes.getValue("LaserName");
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                if (name.equals("LaserName")) continue;
                this.metadata.put(prefix + " - " + name, attributes.getValue(i));
            }
        } else if (qName.equals("TimeStamp")) {
            long high = Long.parseLong(attributes.getValue("HighInteger"));
            long low = Long.parseLong(attributes.getValue("LowInteger"));
            high <<= 32;
            if ((int)low < 0) {
                low &= 0xFFFFFFFFL;
            }
            long stamp = high + low;
            long ms = stamp / 10000L;
            String n = String.valueOf(this.count);
            while (n.length() < 4) {
                n = "0" + n;
            }
            this.metadata.put(this.fullSeries + " - " + qName + n, DataTools.convertDate(ms, 1));
            ++this.count;
        } else if (qName.equals("ChannelScalingInfo")) {
            String prefix = qName + this.count;
            if (this.fullSeries != null && !this.fullSeries.equals("")) {
                prefix = this.fullSeries + " - " + prefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                this.metadata.put(prefix + " - " + name, attributes.getValue(i));
            }
        } else if (qName.equals("RelTimeStamp")) {
            String frame = attributes.getValue("Frame");
            String time = attributes.getValue("Time");
            this.metadata.put(this.fullSeries + " - " + qName + " - " + frame, time);
            int originalPlane = Integer.parseInt(frame);
            int planeNum = (Integer)this.nextPlane.get(this.seriesNames.size() - 1);
            if (originalPlane < planeNum) {
                return;
            }
            this.timestamps.put("Series " + (this.seriesNames.size() - 1) + " Plane " + planeNum, new Float(time));
            this.nextPlane.setElementAt(new Integer(++planeNum), this.seriesNames.size() - 1);
        } else {
            this.count = 0;
        }
    }
}

