/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;

public class EPSReader
extends FormatReader {
    private int bps;
    private int start;
    private boolean binary;
    private boolean isTiff;
    private Hashtable[] ifds;

    public EPSReader() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi", "ps"});
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        if (this.isTiff) {
            long[] offsets = TiffTools.getStripOffsets(this.ifds[0]);
            this.in.seek(offsets[0]);
            int[] map = TiffTools.getIFDIntArray(this.ifds[0], 320, false);
            if (map == null) {
                this.readPlane(this.in, x, y, w, h, buf);
                return buf;
            }
            byte[] b = new byte[w * h];
            this.in.skipBytes(2 * y * this.getSizeX());
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * 2);
                for (int col = 0; col < w; ++col) {
                    b[row * w + col] = (byte)(this.in.readShort() & 0xFF);
                }
                this.in.skipBytes(2 * (this.getSizeX() - w - x));
            }
            for (int i = 0; i < b.length; ++i) {
                int ndx = b[i] & 0xFF;
                for (int j = 0; j < this.getSizeC(); ++j) {
                    buf[i * this.getSizeC() + j] = (byte)map[ndx + j * 256];
                }
            }
            return buf;
        }
        if (this.start == 0) {
            throw new FormatException("Vector data not supported.");
        }
        this.in.seek(0L);
        for (int line = 0; line <= this.start; ++line) {
            this.in.readLine();
        }
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        if (this.binary) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            String pix = this.in.readString((int)(this.in.length() - this.in.getFilePointer()));
            pix = pix.replaceAll("\n", "");
            pix = pix.replaceAll("\r", "");
            int ndx = this.getSizeC() * y * bytes * this.getSizeX();
            int destNdx = 0;
            for (int row = 0; row < h; ++row) {
                ndx += x * this.getSizeC() * bytes;
                for (int col = 0; col < w * this.getSizeC() * bytes; ++col) {
                    buf[destNdx++] = (byte)Integer.parseInt(pix.substring(2 * ndx, 2 * (ndx + 1)), 16);
                    ++ndx;
                }
                ndx += this.getSizeC() * bytes * (this.getSizeX() - w - x);
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.start = 0;
        this.bps = 0;
        this.isTiff = false;
        this.binary = false;
        this.ifds = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("EPSReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Verifying EPS format");
        String line = this.in.readLine();
        if (!line.trim().startsWith("%!PS")) {
            this.isTiff = true;
            this.in.order(true);
            this.in.seek(20L);
            int offset = this.in.readInt();
            int len = this.in.readInt();
            byte[] b = new byte[len];
            this.in.seek(offset);
            this.in.read(b);
            this.in = new RandomAccessInputStream(b);
            this.ifds = TiffTools.getIFDs(this.in);
            this.core[0].sizeX = (int)TiffTools.getImageWidth(this.ifds[0]);
            this.core[0].sizeY = (int)TiffTools.getImageLength(this.ifds[0]);
            this.core[0].sizeZ = 1;
            this.core[0].sizeT = 1;
            this.core[0].sizeC = TiffTools.getSamplesPerPixel(this.ifds[0]);
            this.core[0].littleEndian = TiffTools.isLittleEndian(this.ifds[0]);
            this.core[0].interleaved = true;
            this.core[0].rgb = this.getSizeC() > 1;
            this.bps = TiffTools.getBitsPerSample(this.ifds[0])[0];
            switch (this.bps) {
                case 16: {
                    this.core[0].pixelType = 3;
                    break;
                }
                case 32: {
                    this.core[0].pixelType = 5;
                    break;
                }
                default: {
                    this.core[0].pixelType = 1;
                }
            }
            this.core[0].imageCount = 1;
            this.core[0].dimensionOrder = "XYCZT";
            this.core[0].metadataComplete = true;
            this.core[0].indexed = false;
            this.core[0].falseColor = false;
            FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            MetadataTools.populatePixels(store, this);
            store.setImageName("", 0);
            MetadataTools.setDefaultCreationDate(store, id, 0);
            return;
        }
        this.status("Finding image data");
        this.binary = false;
        String image = "image";
        int lineNum = 1;
        line = this.in.readLine().trim();
        while (line != null && !line.equals("%%EOF")) {
            block18: {
                block16: {
                    block19: {
                        block17: {
                            if (line.endsWith(image)) {
                                if (!line.startsWith(image)) {
                                    if (line.indexOf("colorimage") != -1) {
                                        this.core[0].sizeC = 3;
                                    }
                                    StringTokenizer t = new StringTokenizer(line, " ");
                                    try {
                                        this.core[0].sizeX = Integer.parseInt(t.nextToken());
                                        this.core[0].sizeY = Integer.parseInt(t.nextToken());
                                        this.bps = Integer.parseInt(t.nextToken());
                                    }
                                    catch (NumberFormatException exc) {
                                        if (debug) {
                                            this.trace(exc);
                                        }
                                        this.core[0].sizeC = Integer.parseInt(t.nextToken());
                                    }
                                }
                                this.start = lineNum;
                                break;
                            }
                            if (!line.startsWith("%%")) break block16;
                            if (!line.startsWith("%%BoundingBox:")) break block17;
                            line = line.substring(14);
                            StringTokenizer t = new StringTokenizer(line, " ");
                            int originX = Integer.parseInt(t.nextToken().trim());
                            int originY = Integer.parseInt(t.nextToken().trim());
                            this.core[0].sizeX = Integer.parseInt(t.nextToken().trim()) - originX;
                            this.core[0].sizeY = Integer.parseInt(t.nextToken().trim()) - originY;
                            this.addMeta("X-coordinate of origin", originX);
                            this.addMeta("Y-coordinate of origin", originY);
                            break block18;
                        }
                        if (!line.startsWith("%%BeginBinary")) break block19;
                        this.binary = true;
                        break block18;
                    }
                    int ndx = line.indexOf(":");
                    if (ndx == -1) break block18;
                    String key = line.substring(0, ndx);
                    String value = line.substring(ndx + 1);
                    this.addMeta(key, value);
                    break block18;
                }
                if (line.startsWith("%ImageData:")) {
                    line = line.substring(11);
                    StringTokenizer t = new StringTokenizer(line, " ");
                    this.core[0].sizeX = Integer.parseInt(t.nextToken());
                    this.core[0].sizeY = Integer.parseInt(t.nextToken());
                    this.bps = Integer.parseInt(t.nextToken());
                    this.core[0].sizeC = Integer.parseInt(t.nextToken());
                    while (t.hasMoreTokens()) {
                        image = t.nextToken().trim();
                        if (image.length() <= 1) continue;
                        image = image.substring(1, image.length() - 1);
                    }
                }
            }
            ++lineNum;
            line = this.in.readLine().trim();
        }
        this.status("Populating metadata");
        if (this.bps == 0) {
            this.bps = 8;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = 1;
        this.core[0].rgb = this.getSizeC() == 3;
        this.core[0].interleaved = true;
        this.core[0].littleEndian = true;
        this.core[0].imageCount = 1;
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
    }
}

