/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class JPEG2000Codec
extends BaseCodec {
    private static final String NO_J2K_MSG = "The JAI Image I/O Tools are required to read JPEG-2000 files. Please obtain jai_imageio.jar from http://loci.wisc.edu/ome/formats-library.html";
    private static final String J2K_READER = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader";
    private static final String J2K_WRITER = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter";
    private static boolean noJ2k = false;
    private static ReflectedUniverse r = JPEG2000Codec.createReflectedUniverse();

    private static void registerClass(String className) {
        String spi = className + "Spi";
        Class<?> spiClass = null;
        try {
            spiClass = Class.forName(spi);
        }
        catch (ClassNotFoundException exc) {
            LogTools.trace(exc);
            noJ2k = true;
            return;
        }
        catch (NoClassDefFoundError err) {
            LogTools.trace(err);
            noJ2k = true;
            return;
        }
        catch (RuntimeException exc) {
            String msg = exc.getMessage();
            if (msg != null && msg.indexOf("ClassNotFound") < 0) {
                throw exc;
            }
            LogTools.trace(exc);
            noJ2k = true;
            return;
        }
        IIORegistry registry = IIORegistry.getDefaultInstance();
        if (spiClass != null) {
            Iterator<?> providers = ServiceRegistry.lookupProviders(spiClass);
            registry.registerServiceProviders(providers);
        }
    }

    private static ReflectedUniverse createReflectedUniverse() {
        ReflectedUniverse ru = null;
        try {
            JPEG2000Codec.registerClass(J2K_READER);
            if (noJ2k) {
                throw new FormatException("Could not compress JPEG-2000 data.\nThe JAI Image I/O Tools are required to read JPEG-2000 files. Please obtain jai_imageio.jar from http://loci.wisc.edu/ome/formats-library.html");
            }
            IIORegistry registry = IIORegistry.getDefaultInstance();
            Class<?> j2kSpiClass = Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi");
            Object j2kSpi = registry.getServiceProviderByClass(j2kSpiClass);
            ru = new ReflectedUniverse();
            ru.exec("import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader");
            ru.setVar("j2kSpi", j2kSpi);
            ru.exec("j2kReader = new J2KImageReader(j2kSpi)");
            JPEG2000Codec.registerClass(J2K_WRITER);
            j2kSpiClass = Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterSpi");
            j2kSpi = registry.getServiceProviderByClass(j2kSpiClass);
            ru.exec("import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter");
            ru.setVar("j2kSpi", j2kSpi);
            ru.exec("j2kWriter = new J2KImageWriter(j2kSpi)");
        }
        catch (Throwable t) {
            noJ2k = true;
            LogTools.trace(t);
        }
        return ru;
    }

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = null;
        int next = 0;
        int plane = options.width * options.height;
        if (options.bitsPerSample == 8) {
            byte[][] b = new byte[options.channels][plane];
            if (options.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < options.channels; ++c) {
                        b[c][q] = data[next++];
                    }
                }
            } else {
                for (int c = 0; c < options.channels; ++c) {
                    System.arraycopy(data, c * plane, b[c], 0, plane);
                }
            }
            DataBufferByte buffer = new DataBufferByte(b, plane);
            img = AWTImageTools.constructImage(b.length, 0, options.width, options.height, false, true, buffer);
        } else if (options.bitsPerSample == 16) {
            short[][] s = new short[options.channels][plane];
            if (options.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < options.channels; ++c) {
                        s[c][q] = DataTools.bytesToShort(data, next, 2, options.littleEndian);
                        next += 2;
                    }
                }
            } else {
                for (int c = 0; c < options.channels; ++c) {
                    for (int q = 0; q < plane; ++q) {
                        s[c][q] = DataTools.bytesToShort(data, next, 2, options.littleEndian);
                        next += 2;
                    }
                }
            }
            DataBufferUShort buffer = new DataBufferUShort(s, plane);
            img = AWTImageTools.constructImage(s.length, 1, options.width, options.height, false, true, buffer);
        }
        try {
            ImageOutputStream ios = ImageIO.createImageOutputStream(out);
            r.setVar("img", img);
            r.setVar("out", ios);
            r.exec("j2kWriter.setOutput(out)");
            r.exec("j2kWriter.write(img)");
            ios.close();
        }
        catch (ReflectException e) {
            throw new FormatException("Could not compress JPEG-2000 data.", e);
        }
        catch (IOException e) {
            throw new FormatException("Could not compress JPEG-2000 data.", e);
        }
        return out.toByteArray();
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[][] single = null;
        byte[][] half = null;
        BufferedImage b = null;
        Exception exception = null;
        long fp = in.getFilePointer();
        try {
            byte[] buf = null;
            buf = options.maxBytes == 0 ? new byte[(int)(in.length() - fp)] : new byte[(int)((long)options.maxBytes - fp)];
            in.read(buf);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(bis);
            r.setVar("mciis", mciis);
            r.exec("j2kReader.setInput(mciis)");
            r.setVar("zero", 0);
            b = (BufferedImage)r.exec("j2kReader.read(zero)");
            single = AWTImageTools.getPixelBytes(b, options.littleEndian);
            bis.close();
            mciis.close();
            buf = null;
            b = null;
        }
        catch (ReflectException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            throw new FormatException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", exception);
        }
        if (single.length == 1) {
            return single[0];
        }
        byte[] rtn = new byte[single.length * single[0].length];
        if (options.interleaved) {
            int next = 0;
            for (int i = 0; i < single[0].length; ++i) {
                for (int j = 0; j < single.length; ++j) {
                    rtn[next++] = single[j][i];
                }
            }
        } else {
            for (int i = 0; i < single.length; ++i) {
                System.arraycopy(single[i], 0, rtn, i * single[0].length, single[i].length);
            }
        }
        single = null;
        return rtn;
    }
}

