/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import ucar.grib.Index;
import ucar.grib.grib1.Grib1IndexExtender;
import ucar.grib.grib1.Grib1Indexer;
import ucar.grib.grib2.Grib2IndexExtender;
import ucar.grib.grib2.Grib2Indexer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grib.Grib1ServiceProvider;
import ucar.nc2.iosp.grib.GribHorizCoordSys;
import ucar.nc2.iosp.grib.GribVariable;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;

public abstract class GribServiceProvider
extends AbstractIOServiceProvider {
    protected NetcdfFile ncfile;
    protected RandomAccessFile raf;
    protected StringBuffer parseInfo = new StringBuffer();
    protected FmrcCoordSys fmrcCoordSys;
    private Index saveIndex = null;
    private File saveIndexFile = null;
    private int saveEdition = 0;
    private String saveLocation;
    static boolean debugOpen = false;
    static boolean debugMissing = false;
    static boolean debugMissingDetails = false;
    static boolean debugProj = false;
    static boolean debugTiming = false;
    static boolean debugVert = false;
    private static boolean alwaysInCache = false;
    public static boolean addLatLon = false;
    public static boolean forceNewIndex = false;
    public static boolean useMaximalCoordSys = false;
    public static boolean extendIndex = true;

    public static void useMaximalCoordSys(boolean b) {
        useMaximalCoordSys = b;
    }

    public static void setExtendIndex(boolean b) {
        extendIndex = b;
    }

    public static void setIndexAlwaysInCache(boolean b) {
        alwaysInCache = b;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("Grib/open");
        debugMissing = debugFlag.isSet("Grib/missing");
        debugMissingDetails = debugFlag.isSet("Grib/missingDetails");
        debugProj = debugFlag.isSet("Grib/projection");
        debugVert = debugFlag.isSet("Grib/vertical");
        debugTiming = debugFlag.isSet("Grib/timing");
    }

    protected abstract void open(Index var1, CancelTask var2) throws IOException;

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
        long start = System.currentTimeMillis();
        int edition = this instanceof Grib1ServiceProvider ? 1 : 2;
        Index index = this.getIndex(edition, ncfile.getLocation(), cancelTask);
        this.open(index, cancelTask);
        if (debugOpen) {
            System.out.println(" GribServiceProvider.open " + ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
        }
    }

    protected Index getIndex(int edition, String location, CancelTask cancelTask) throws IOException {
        this.saveEdition = edition;
        this.saveLocation = location;
        String indexLocation = location + ".gbx";
        if (indexLocation.startsWith("http:")) {
            InputStream ios = this.indexExistsAsURL(indexLocation);
            if (ios != null) {
                this.saveIndex = new Index();
                this.saveIndex.open(indexLocation, ios);
                if (debugOpen) {
                    System.out.println("  opened HTTP index = " + indexLocation);
                }
                return this.saveIndex;
            }
            this.saveIndexFile = DiskCache.getCacheFile(indexLocation);
            if (debugOpen) {
                System.out.println("  HTTP index = " + this.saveIndexFile.getPath());
            }
        } else {
            this.saveIndexFile = new File(indexLocation);
            if (!this.saveIndexFile.exists()) {
                this.saveIndexFile = DiskCache.getFile(indexLocation, alwaysInCache);
            }
        }
        if (!forceNewIndex && this.saveIndexFile.exists()) {
            this.saveIndex = new Index();
            boolean ok = this.saveIndex.open(this.saveIndexFile.getPath());
            if (ok) {
                if (debugOpen) {
                    System.out.println("  opened index = " + this.saveIndexFile.getPath());
                }
                if (extendIndex) {
                    long length;
                    HashMap attrHash = this.saveIndex.getGlobalAttributes();
                    String lengthS = (String)attrHash.get("length");
                    long l = length = lengthS == null ? 0L : Long.parseLong(lengthS);
                    if (length < this.raf.length()) {
                        if (debugOpen) {
                            System.out.println("  calling extendIndex");
                        }
                        this.saveIndex = this.extendIndex(edition, this.raf, this.saveIndexFile, this.saveIndex);
                    }
                }
            } else {
                this.saveIndex = this.writeIndex(edition, this.saveIndexFile, this.raf);
                if (debugOpen) {
                    System.out.println("  rewrite index = " + this.saveIndexFile.getPath());
                }
            }
        } else {
            this.saveIndex = this.writeIndex(edition, this.saveIndexFile, this.raf);
            if (debugOpen) {
                System.out.println("  write index = " + this.saveIndexFile.getPath());
            }
        }
        return this.saveIndex;
    }

    private Index writeIndex(int edition, File indexFile, RandomAccessFile raf) throws IOException {
        Index index = null;
        raf.seek(0L);
        if (edition == 1) {
            Grib1Indexer indexer = new Grib1Indexer();
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            index = indexer.writeFileIndex(raf, ps, true);
        } else if (edition == 2) {
            Grib2Indexer indexer2 = new Grib2Indexer();
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            index = indexer2.writeFileIndex(raf, ps, true);
        }
        return index;
    }

    public boolean syncExtend() {
        return false;
    }

    public boolean sync() throws IOException {
        long length;
        HashMap attrHash = this.saveIndex.getGlobalAttributes();
        String lengthS = (String)attrHash.get("length");
        long l = length = lengthS == null ? 0L : Long.parseLong(lengthS);
        if (length < this.raf.length()) {
            if (extendIndex && this.saveIndexFile != null) {
                if (debugOpen) {
                    System.out.println("calling IndexExtender");
                }
                this.saveIndex = this.extendIndex(this.saveEdition, this.raf, this.saveIndexFile, this.saveIndex);
            } else {
                if (debugOpen) {
                    System.out.println("sync reopen Index");
                }
                this.saveIndex = this.getIndex(this.saveEdition, this.saveLocation, null);
            }
            this.ncfile.empty();
            this.open(this.saveIndex, null);
            return true;
        }
        return false;
    }

    private Index extendIndex(int edition, RandomAccessFile raf, File indexFile, Index index) throws IOException {
        if (edition == 1) {
            Grib1IndexExtender indexExt = new Grib1IndexExtender();
            index = indexExt.extendIndex(raf, indexFile, index);
        } else if (edition == 2) {
            Grib2IndexExtender indexExt = new Grib2IndexExtender();
            index = indexExt.extendIndex(raf, indexFile, index);
        }
        return index;
    }

    private InputStream indexExistsAsURL(String indexLocation) {
        try {
            URL url = new URL(indexLocation);
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        Array dataArray = Array.factory(DataType.FLOAT.getClassType(), section.getShape());
        GribVariable pv = (GribVariable)v2.getSPobject();
        int count = 0;
        Range timeRange = section.getRange(count++);
        Range levRange = pv.hasVert() ? section.getRange(count++) : null;
        Range yRange = section.getRange(count++);
        Range xRange = section.getRange(count);
        IndexIterator ii = dataArray.getIndexIteratorFast();
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            if (pv.hasVert()) {
                this.readLevel(v2, timeIdx, levRange, yRange, xRange, ii);
                continue;
            }
            this.readXY(v2, timeIdx, 0, yRange, xRange, ii);
        }
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println("  read data took=" + took + " msec ");
        }
        return dataArray;
    }

    public void readLevel(Variable v2, int timeIdx, Range levelRange, Range yRange, Range xRange, IndexIterator ii) throws IOException, InvalidRangeException {
        for (int levIdx = levelRange.first(); levIdx <= levelRange.last(); levIdx += levelRange.stride()) {
            this.readXY(v2, timeIdx, levIdx, yRange, xRange, ii);
        }
    }

    public void readXY(Variable v2, int timeIdx, int levIdx, Range yRange, Range xRange, IndexIterator ii) throws IOException, InvalidRangeException {
        float[] data;
        Attribute att = v2.findAttribute("missing_value");
        float missing_value = att == null ? -9999.0f : att.getNumericValue().floatValue();
        GribVariable pv = (GribVariable)v2.getSPobject();
        GribHorizCoordSys hsys = pv.getHorizCoordSys();
        int nx = hsys.getNx();
        Index.GribRecord record = pv.findRecord(timeIdx, levIdx);
        if (record == null) {
            int xyCount = yRange.length() * xRange.length();
            for (int j = 0; j < xyCount; ++j) {
                ii.setFloatNext(missing_value);
            }
            return;
        }
        try {
            data = this._readData(record.offset1, record.offset2, record.decimalScale, record.bmsExists);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                int index = y * nx + x;
                ii.setFloatNext(data[index]);
            }
        }
    }

    public boolean isMissingXY(Variable v2, int timeIdx, int levIdx) throws InvalidRangeException {
        GribVariable pv = (GribVariable)v2.getSPobject();
        if (null == pv) {
            System.out.println("HEY");
        }
        if (timeIdx < 0 || timeIdx >= pv.getNTimes()) {
            throw new InvalidRangeException("timeIdx=" + timeIdx);
        }
        if (levIdx < 0 || levIdx >= pv.getVertNlevels()) {
            throw new InvalidRangeException("levIdx=" + levIdx);
        }
        return null == pv.findRecord(timeIdx, levIdx);
    }

    protected abstract float[] _readData(long var1, long var3, int var5, boolean var6) throws IOException;

    public void close() throws IOException {
        this.raf.close();
    }

    public Object sendIospMessage(Object special) {
        if (special instanceof FmrcCoordSys) {
            this.fmrcCoordSys = (FmrcCoordSys)special;
        }
        return null;
    }

    public String getDetailInfo() {
        return this.parseInfo.toString();
    }
}

