/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class AlbersEqualArea
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "albers_conical_equal_area";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double[] pars = this.readAttributeDouble2(ctv.findAttribute("standard_parallel"));
        if (pars == null) {
            return null;
        }
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_central_meridian");
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin");
        double false_easting = this.readAttributeDouble(ctv, "false_easting");
        double false_northing = this.readAttributeDouble(ctv, "false_northing");
        ucar.unidata.geoloc.projection.AlbersEqualArea proj = new ucar.unidata.geoloc.projection.AlbersEqualArea(lat0, lon0, pars[0], pars[1]);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

