/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;

public class ArrayByte
extends Array {
    protected byte[] storage;

    static ArrayByte factory(Index index) {
        return ArrayByte.factory(index, null);
    }

    static ArrayByte factory(Index index, byte[] storage) {
        switch (index.getRank()) {
            case 0: {
                return new D0(index, storage);
            }
            case 1: {
                return new D1(index, storage);
            }
            case 2: {
                return new D2(index, storage);
            }
            case 3: {
                return new D3(index, storage);
            }
            case 4: {
                return new D4(index, storage);
            }
            case 5: {
                return new D5(index, storage);
            }
            case 6: {
                return new D6(index, storage);
            }
            case 7: {
                return new D7(index, storage);
            }
        }
        return new ArrayByte(index, storage);
    }

    public ArrayByte(int[] dimensions) {
        super(dimensions);
        this.storage = new byte[(int)this.indexCalc.getSize()];
    }

    ArrayByte(Index ima, byte[] data) {
        super(ima);
        this.storage = data != null ? data : new byte[(int)ima.getSize()];
    }

    Array createView(Index index) {
        return ArrayByte.factory(index, this.storage);
    }

    public Object getStorage() {
        return this.storage;
    }

    void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        byte[] ja = (byte[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            iter.setByteNext(ja[i]);
        }
    }

    void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        byte[] ja = (byte[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getByteNext();
        }
    }

    public ByteBuffer getDataAsByteBuffer() {
        return ByteBuffer.wrap((byte[])this.get1DJavaArray(Byte.TYPE));
    }

    public Class getElementType() {
        return Byte.TYPE;
    }

    public byte get(Index i) {
        return this.storage[i.currentElement()];
    }

    public void set(Index i, byte value) {
        this.storage[i.currentElement()] = value;
    }

    public double getDouble(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setDouble(Index i, double value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    public float getFloat(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setFloat(Index i, float value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    public long getLong(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setLong(Index i, long value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    public int getInt(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setInt(Index i, int value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    public short getShort(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setShort(Index i, short value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    public byte getByte(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setByte(Index i, byte value) {
        this.storage[i.currentElement()] = value;
    }

    public char getChar(Index i) {
        return (char)this.storage[i.currentElement()];
    }

    public void setChar(Index i, char value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    public Object getObject(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = ((Number)value).byteValue();
    }

    double getDouble(int index) {
        return this.storage[index];
    }

    void setDouble(int index, double value) {
        this.storage[index] = (byte)value;
    }

    float getFloat(int index) {
        return this.storage[index];
    }

    void setFloat(int index, float value) {
        this.storage[index] = (byte)value;
    }

    long getLong(int index) {
        return this.storage[index];
    }

    void setLong(int index, long value) {
        this.storage[index] = (byte)value;
    }

    int getInt(int index) {
        return this.storage[index];
    }

    void setInt(int index, int value) {
        this.storage[index] = (byte)value;
    }

    short getShort(int index) {
        return this.storage[index];
    }

    void setShort(int index, short value) {
        this.storage[index] = (byte)value;
    }

    byte getByte(int index) {
        return this.storage[index];
    }

    void setByte(int index, byte value) {
        this.storage[index] = value;
    }

    char getChar(int index) {
        return (char)this.storage[index];
    }

    void setChar(int index, char value) {
        this.storage[index] = (byte)value;
    }

    boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    Object getObject(int index) {
        return this.getByte(index);
    }

    void setObject(int index, Object value) {
        this.storage[index] = ((Number)value).byteValue();
    }

    public static class D7
    extends ArrayByte {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l, int m, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n, o)];
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayByte {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5) {
            super(new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l, int m, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n)];
        }

        public void set(int i, int j, int k, int l, int m, int n, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayByte {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4) {
            super(new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l, int m) {
            return this.storage[this.ix.setDirect(i, j, k, l, m)];
        }

        public void set(int i, int j, int k, int l, int m, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m)] = value;
        }
    }

    public static class D4
    extends ArrayByte {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3) {
            super(new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayByte {
        private Index3D ix;

        public D3(int len0, int len1, int len2) {
            super(new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public byte get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }
    }

    public static class D2
    extends ArrayByte {
        private Index2D ix;

        public D2(int len0, int len1) {
            super(new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public byte get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayByte {
        private Index1D ix;

        public D1(int len0) {
            super(new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public byte get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, byte value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayByte {
        private Index0D ix;

        public D0() {
            super(new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Index i, byte[] store) {
            super(i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public byte get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(byte value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

