/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.process.ImageProcessor;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.cache.CacheException;
import loci.formats.cache.ICacheSource;
import loci.plugins.util.ImagePlusReader;

public class ImageProcessorSource
implements ICacheSource {
    protected ImagePlusReader reader;

    public ImageProcessorSource(IFormatReader reader) throws CacheException {
        this.reader = new ImagePlusReader(reader);
    }

    public int getObjectCount() {
        return this.reader.getImageCount();
    }

    public Object getObject(int index) throws CacheException {
        ImageProcessor ip = null;
        try {
            ip = this.reader.openProcessors(index)[0];
        }
        catch (FormatException exc) {
            throw new CacheException(exc);
        }
        catch (IOException exc) {
            throw new CacheException(exc);
        }
        return ip;
    }
}

