/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.config;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import javax.imageio.spi.IIORegistry;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import loci.plugins.config.FormatEntry;
import loci.plugins.config.LibraryEntry;
import loci.plugins.config.LociInstaller;
import loci.plugins.config.SpringUtilities;
import loci.plugins.config.TextAreaWriter;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.util.WindowTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigWindow
extends JFrame
implements ActionListener,
ItemListener,
ListSelectionListener,
Runnable {
    private static final int PAD = 5;
    private DefaultListModel formatsListModel;
    private JList formatsList;
    private JPanel formatInfo;
    private JTextField extensions;
    private JCheckBox enabledBox;
    private JCheckBox windowlessBox;
    private JCheckBox upgradeBox;
    private ImporterOptions options;
    private DefaultListModel libsListModel;
    private JList libsList;
    private JTextField type;
    private JTextField status;
    private JTextField version;
    private JTextField path;
    private JTextField url;
    private JTextField license;
    private JTextArea notes;
    private PrintWriter log;
    private static final Class[] PARAMS = new Class[]{String.class, Boolean.TYPE};

    public ConfigWindow() {
        this.setTitle("LOCI Plugins Configuration");
        this.setDefaultCloseOperation(2);
        String loading = "Loading...";
        JTabbedPane tabs = new JTabbedPane();
        tabs.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(tabs);
        JPanel installPanel = new JPanel();
        JButton installButton = new JButton("<html><center><br><font size=\"+1\">Check my system,<br>install missing libraries,<br>and upgrade old files</font><br><font size=\"-1\">&nbsp;<br>(We'll ask before we install or upgrade anything.)</font><br>&nbsp;");
        installButton.addActionListener(this);
        installPanel.add(installButton);
        this.formatsListModel = new DefaultListModel();
        this.formatsListModel.addElement("Loading...");
        this.formatsList = this.makeList(this.formatsListModel);
        this.formatInfo = new JPanel();
        tabs.addTab("Formats", this.makeSplitPane(this.formatsList, this.formatInfo));
        this.extensions = ConfigWindow.makeTextField();
        this.enabledBox = new JCheckBox("", false);
        this.enabledBox.addItemListener(this);
        this.windowlessBox = new JCheckBox("", false);
        this.windowlessBox.addItemListener(this);
        this.doFormatLayout(null);
        this.libsListModel = new DefaultListModel();
        this.libsListModel.addElement("Loading...");
        this.libsList = this.makeList(this.libsListModel);
        JPanel libInfo = new JPanel();
        tabs.addTab("Libraries", this.makeSplitPane(this.libsList, libInfo));
        libInfo.setLayout(new SpringLayout());
        libInfo.add(this.makeLabel("Type", false));
        this.type = ConfigWindow.makeTextField();
        libInfo.add(this.type);
        libInfo.add(this.makeLabel("Status", false));
        this.status = ConfigWindow.makeTextField();
        libInfo.add(this.status);
        libInfo.add(this.makeLabel("Version", false));
        this.version = ConfigWindow.makeTextField();
        libInfo.add(this.version);
        libInfo.add(this.makeLabel("Path", false));
        this.path = ConfigWindow.makeTextField();
        libInfo.add(this.path);
        libInfo.add(this.makeLabel("URL", false));
        this.url = ConfigWindow.makeTextField();
        libInfo.add(this.url);
        libInfo.add(this.makeLabel("License", false));
        this.license = ConfigWindow.makeTextField();
        libInfo.add(this.license);
        libInfo.add(this.makeLabel("Notes", true));
        this.notes = new JTextArea();
        this.notes.setEditable(false);
        this.notes.setWrapStyleWord(true);
        this.notes.setLineWrap(true);
        libInfo.add(new JScrollPane(this.notes));
        JPanel upgradePanel = new JPanel();
        tabs.addTab("Upgrade", upgradePanel);
        upgradePanel.setLayout(new SpringLayout());
        JLabel upgradeLabel = new JLabel("Automatically check for new versions of the LOCI plugins");
        upgradePanel.add(upgradeLabel);
        try {
            this.options = new ImporterOptions();
        }
        catch (IOException exc) {
            WindowTools.reportException(exc);
        }
        this.options.loadOptions();
        this.upgradeBox = new JCheckBox("", this.options.doUpgradeCheck());
        this.upgradeBox.addItemListener(this);
        upgradePanel.add(this.upgradeBox);
        SpringUtilities.makeCompactGrid(upgradePanel, 1, 2, 5, 5, 5, 5);
        JPanel logPanel = new JPanel();
        tabs.addTab("Log", logPanel);
        logPanel.setLayout(new BorderLayout());
        JTextArea logArea = new JTextArea();
        logArea.setEditable(false);
        logArea.setRows(10);
        logPanel.add(new JScrollPane(logArea));
        SpringUtilities.makeCompactGrid(libInfo, 7, 2, 5, 5, 5, 5);
        this.pack();
        TextAreaWriter taw = new TextAreaWriter(logArea);
        this.log = new PrintWriter(taw);
        new Thread((Runnable)this, "ConfigWindow-Loader").start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new LociInstaller().run(null);
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.upgradeBox) {
            this.options.setUpgradeCheck(this.upgradeBox.isSelected());
            this.options.saveOptions();
            return;
        }
        Object value = this.formatsList.getSelectedValue();
        if (!(value instanceof FormatEntry)) {
            return;
        }
        FormatEntry entry = (FormatEntry)value;
        if (src == this.enabledBox) {
            this.setReaderEnabled(entry, this.enabledBox.isSelected());
        } else if (src == this.windowlessBox) {
            this.setReaderWindowless(entry, this.windowlessBox.isSelected());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == this.formatsList) {
            Object value = this.formatsList.getSelectedValue();
            if (!(value instanceof FormatEntry)) {
                return;
            }
            FormatEntry entry = (FormatEntry)this.formatsList.getSelectedValue();
            this.doFormatLayout(entry);
        } else if (src == this.libsList) {
            Object value = this.libsList.getSelectedValue();
            if (!(value instanceof LibraryEntry)) {
                return;
            }
            LibraryEntry entry = (LibraryEntry)this.libsList.getSelectedValue();
            this.type.setText(entry.type);
            this.status.setText(entry.status);
            this.version.setText(entry.version);
            this.path.setText(entry.path);
            this.url.setText(entry.url);
            this.license.setText(entry.license);
            this.notes.setText(entry.notes);
        }
    }

    @Override
    public void run() {
        String matlabVersion;
        String clibIIOVersion;
        String qtVersion;
        String bfVersion;
        String javaVersion;
        block28: {
            block27: {
                this.log.println("LOCI Plugins configuration - " + new Date());
                this.log.println();
                this.log.println("-- Formats --");
                Object formats = null;
                try {
                    Class<?> irClass = Class.forName("loci.formats.ImageReader");
                    Object ir = irClass.newInstance();
                    Method getClasses = irClass.getMethod("getReaders", new Class[0]);
                    Object[] readers = (Object[])getClasses.invoke(ir, new Object[0]);
                    for (int i = 0; i < readers.length; ++i) {
                        FormatEntry entry = new FormatEntry(this.log, readers[i]);
                        ConfigWindow.addEntry(entry, this.formatsListModel);
                    }
                }
                catch (Throwable t) {
                    this.log.println("Could not generate list of supported formats:");
                    t.printStackTrace(this.log);
                }
                this.log.println();
                this.log.println("-- Libraries --");
                String libCore = "Core library";
                String libNative = "Native library";
                String libPlugin = "ImageJ plugin";
                String libJava = "Java library";
                javaVersion = System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";
                bfVersion = "1 June 2009";
                if (bfVersion.equals("@date@")) {
                    bfVersion = "Internal build";
                }
                qtVersion = null;
                try {
                    Class<?> qtToolsClass = Class.forName("loci.formats.LegacyQTTools");
                    Object qtTools = qtToolsClass.newInstance();
                    Method getQTVersion = qtToolsClass.getMethod("getQTVersion", new Class[0]);
                    qtVersion = (String)getQTVersion.invoke(qtTools, new Object[0]);
                }
                catch (Throwable t) {
                    this.log.println("Could not determine QuickTime version:");
                    t.printStackTrace(this.log);
                }
                clibIIOVersion = null;
                try {
                    Class<?> jpegSpi = Class.forName("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReaderSpi");
                    IIORegistry registry = IIORegistry.getDefaultInstance();
                    Object jpeg = registry.getServiceProviderByClass(jpegSpi);
                    if (jpeg == null) {
                        clibIIOVersion = "!";
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ClassNotFoundException) break block27;
                    this.log.println("Error determining native Image I/O Tools version:");
                    t.printStackTrace(this.log);
                }
            }
            matlabVersion = null;
            try {
                Class<?> matlabClass = Class.forName("com.mathworks.jmi.Matlab");
                Object matlab = matlabClass.newInstance();
                Method eval = matlabClass.getMethod("eval", String.class);
                String ans = (String)eval.invoke(matlab, "version");
                if (ans.startsWith("ans =")) {
                    ans = ans.substring(5);
                }
                matlabVersion = ans.trim();
            }
            catch (Throwable t) {
                if (t instanceof ClassNotFoundException) break block28;
                this.log.println("Error determining MATLAB version:");
                t.printStackTrace(this.log);
            }
        }
        HashMap<String, String> versions = new HashMap<String, String>();
        if (javaVersion != null) {
            versions.put("javaVersion", javaVersion);
        }
        if (bfVersion != null) {
            versions.put("bfVersion", bfVersion);
        }
        if (qtVersion != null) {
            versions.put("qtVersion", qtVersion);
        }
        if (clibIIOVersion != null) {
            versions.put("clibIIOVersion", clibIIOVersion);
        }
        if (matlabVersion != null) {
            versions.put("matlabVersion", matlabVersion);
        }
        HashMap<String, String> props = null;
        String propKey = null;
        StringBuffer propValue = new StringBuffer();
        String resource = "libraries.txt";
        BufferedReader in = new BufferedReader(new InputStreamReader(ConfigWindow.class.getResourceAsStream(resource)));
        while (true) {
            String line = null;
            try {
                line = in.readLine();
            }
            catch (IOException exc) {
                this.log.println("Error parsing " + resource + ":");
                exc.printStackTrace(this.log);
                break;
            }
            if (line == null) break;
            int ndx = line.indexOf("#");
            if (ndx >= 0) {
                line = line.substring(0, ndx);
            }
            boolean space = line.startsWith(" ");
            if ((line = line.trim()).equals("")) continue;
            int equals = line.indexOf("=");
            if (line.startsWith("[")) {
                if (props == null) {
                    props = new HashMap<String, String>();
                } else {
                    this.addProp(props, propKey, propValue.toString(), versions);
                    LibraryEntry entry = new LibraryEntry(this.log, props);
                    ConfigWindow.addEntry(entry, this.libsListModel);
                }
                props.clear();
                props.put("name", line.substring(1, line.length() - 1));
                propKey = null;
                continue;
            }
            if (space) {
                propValue.append(" ");
                propValue.append(line);
                continue;
            }
            if (equals < 0) continue;
            this.addProp(props, propKey, propValue.toString(), versions);
            propKey = line.substring(0, equals - 1).trim();
            propValue.setLength(0);
            propValue.append(line.substring(equals + 1).trim());
        }
        try {
            in.close();
        }
        catch (IOException exc) {
            this.log.println("Error closing " + resource + ":");
            exc.printStackTrace(this.log);
        }
    }

    public static JTextField makeTextField() {
        JTextField textField = new JTextField(48);
        int prefHeight = textField.getPreferredSize().height;
        textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, prefHeight));
        textField.setEditable(false);
        return textField;
    }

    public static void addEntry(final Comparable c, final DefaultListModel listModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (listModel.size() == 1 && listModel.get(0) instanceof String) {
                    listModel.remove(0);
                }
                int min = 0;
                int max = listModel.size();
                while (min < max) {
                    int mid = (min + max) / 2;
                    Object o = listModel.get(mid);
                    int result = c.compareTo(o);
                    if (result > 0) {
                        min = mid + 1;
                        continue;
                    }
                    max = mid;
                }
                listModel.add(max, c);
            }
        });
    }

    private void addProp(HashMap<String, String> props, String key, String value, HashMap versions) {
        if (key == null) {
            return;
        }
        value = value.replaceAll("\\\\n *", "\n");
        if (key.equals("version")) {
            value = (String)versions.get(value);
        }
        if (value != null) {
            props.put(key, value);
        }
    }

    private JLabel makeLabel(String text, boolean top) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(4);
        if (top) {
            label.setVerticalAlignment(1);
        }
        return label;
    }

    private JList makeList(DefaultListModel listModel) {
        JList list = new JList(listModel);
        list.setSelectionMode(0);
        list.setVisibleRowCount(25);
        list.addListSelectionListener(this);
        return list;
    }

    private JSplitPane makeSplitPane(JList list, JPanel info) {
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(list), info);
        splitPane.setDividerLocation(260);
        return splitPane;
    }

    private void doFormatLayout(FormatEntry entry) {
        int i;
        if (entry != null) {
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < entry.suffixes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(entry.suffixes[i]);
            }
            this.extensions.setText(sb.toString());
        }
        this.enabledBox.setSelected(this.isReaderEnabled(entry));
        this.windowlessBox.setSelected(this.isReaderWindowless(entry));
        this.formatInfo.removeAll();
        this.formatInfo.setLayout(new SpringLayout());
        this.formatInfo.add(this.makeLabel("Extensions", false));
        this.formatInfo.add(this.extensions);
        this.formatInfo.add(this.makeLabel("Enabled", false));
        this.formatInfo.add(this.enabledBox);
        this.formatInfo.add(this.makeLabel("Windowless", false));
        this.formatInfo.add(this.windowlessBox);
        int rows = entry == null ? 0 : entry.widgets.length;
        for (i = 0; i < rows; ++i) {
            this.formatInfo.add(this.makeLabel(entry.labels[i], false));
            this.formatInfo.add(entry.widgets[i]);
        }
        SpringUtilities.makeCompactGrid(this.formatInfo, 3 + rows, 2, 5, 5, 5, 5);
        this.formatInfo.validate();
        this.formatInfo.repaint();
    }

    private boolean isReaderEnabled(FormatEntry entry) {
        return this.isReaderPref("ENABLED", entry, true);
    }

    private void setReaderEnabled(FormatEntry entry, boolean value) {
        this.setReaderPref("ENABLED", entry, value);
    }

    private boolean isReaderWindowless(FormatEntry entry) {
        return this.isReaderPref("WINDOWLESS", entry, false);
    }

    private void setReaderWindowless(FormatEntry entry, boolean value) {
        this.setReaderPref("WINDOWLESS", entry, value);
    }

    private boolean isReaderPref(String pref, FormatEntry entry, boolean defaultValue) {
        if (entry == null) {
            return false;
        }
        try {
            Boolean result = (Boolean)this.invokeMethod("PREF_READER_" + pref, "get", entry, defaultValue);
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.log.println("Error querying property '" + pref.toLowerCase() + "' for reader '" + entry.readerName + "':");
            t.printStackTrace(this.log);
            return false;
        }
    }

    private void setReaderPref(String pref, FormatEntry entry, boolean value) {
        if (entry == null) {
            return;
        }
        try {
            this.invokeMethod("PREF_READER_" + pref, "set", entry, value);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.log.println("Error setting property '" + pref.toLowerCase() + "' for reader '" + entry.readerName + "':");
            t.printStackTrace(this.log);
        }
    }

    private Object invokeMethod(String fieldName, String methodName, FormatEntry entry, boolean value) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> utilClass = Class.forName("loci.plugins.util.LociPrefs");
        Field field = utilClass.getField(fieldName);
        String key = field.get(null) + "." + entry.readerName;
        Class<?> prefsClass = Class.forName("ij.Prefs");
        Method method = prefsClass.getMethod(methodName, PARAMS);
        Object[] args = new Object[]{key, value ? Boolean.TRUE : Boolean.FALSE};
        return method.invoke(null, args);
    }
}

