/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.LegacyQTTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class LegacyQTWriter
extends FormatWriter {
    private static final int TIME_SCALE = 600;
    protected LegacyQTTools tools;
    protected ReflectedUniverse r;
    protected int codec = 0;
    protected int quality = 512;
    private int numWritten = 0;
    private int width;
    private int height;
    private int[] pixels2 = null;

    public LegacyQTWriter() {
        super("Legacy QuickTime", "mov");
    }

    public void setCodec(int codec) {
        this.codec = codec;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        MetadataRetrieve r = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(r, series);
        int width = r.getPixelsSizeX(series, 0);
        int height = r.getPixelsSizeY(series, 0);
        int c = r.getLogicalChannelSamplesPerPixel(series, 0);
        int type = FormatTools.pixelTypeFromString(r.getPixelsPixelType(series, 0));
        int bpp = FormatTools.getBytesPerPixel(type);
        boolean little = r.getPixelsBigEndian(series, 0) == false;
        BufferedImage img = AWTImageTools.makeImage(buf, width, height, c, this.interleaved, bpp, FormatTools.isFloatingPoint(type), little, FormatTools.isSigned(type));
        this.saveImage(img, series, lastInSeries, last);
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (this.tools == null) {
            this.tools = new LegacyQTTools();
            this.r = this.tools.getUniverse();
        }
        if (this.tools.isQTExpired()) {
            throw new FormatException("Your version of QuickTime for Java has expired. Please reinstall QuickTime for Java from http://www.apple.com/quicktime/");
        }
        if (!this.tools.canDoQT()) {
            throw new FormatException("QuickTime for Java is required to read some QuickTime files. Please install QuickTime for Java from http://www.apple.com/quicktime/");
        }
        if (!this.initialized) {
            this.initialized = true;
            try {
                this.r.exec("QTSession.open()");
                BufferedImage img = AWTImageTools.makeBuffered(image);
                this.width = img.getWidth();
                this.height = img.getHeight();
                File f = new File(this.currentId);
                this.r.setVar("f", f);
                this.r.setVar("width", (float)this.width);
                this.r.setVar("height", (float)this.height);
                this.r.exec("movFile = new QTFile(f)");
                this.r.setVar("val", -1879048192);
                this.r.setVar("kMoviePlayer", 1414942532);
                this.r.exec("movie = Movie.createMovieFile(movFile, kMoviePlayer, val)");
                int timeScale = 600;
                this.r.setVar("timeScale", timeScale);
                this.r.setVar("zero", 0);
                this.r.setVar("zeroFloat", 0.0f);
                this.r.exec("videoTrack = movie.addTrack(width, height, zeroFloat)");
                this.r.exec("videoMedia = new VideoMedia(videoTrack, timeScale)");
                this.r.exec("videoMedia.beginEdits()");
                this.r.setVar("pixelFormat", 32);
                this.r.exec("imgDesc2 = new ImageDescription(pixelFormat)");
                this.r.setVar("width", this.width);
                this.r.setVar("height", this.height);
                this.r.exec("imgDesc2.setWidth(width)");
                this.r.exec("imgDesc2.setHeight(height)");
                this.r.exec("gw = new QDGraphics(imgDesc2, zero)");
                this.r.exec("bounds = new QDRect(zero, zero, width, height)");
                this.r.exec("pixMap = gw.getPixMap()");
                this.r.exec("pixSize = pixMap.getPixelSize()");
                this.r.setVar("codec", this.codec);
                this.r.setVar("quality", this.quality);
                int rawImageSize = this.width * this.height * 4;
                this.r.setVar("rawImageSize", rawImageSize);
                this.r.setVar("boolTrue", true);
                this.r.exec("imageHandle = new QTHandle(rawImageSize, boolTrue)");
                this.r.exec("imageHandle.lock()");
                this.r.exec("compressedImage = RawEncodedImage.fromQTHandle(imageHandle)");
                this.r.setVar("rate", 30);
                this.r.exec("seq = new CSequence(gw, bounds, pixSize, codec, CodecComponent.bestFidelityCodec, quality, quality, rate, null, zero)");
                this.r.exec("imgDesc = seq.getDescription()");
            }
            catch (ReflectException e) {
                this.trace(e);
                throw new FormatException("Legacy QuickTime writer failed", e);
            }
        }
        ++this.numWritten;
        try {
            this.r.exec("pixMap = gw.getPixMap()");
            this.r.exec("pixelData = pixMap.getPixelData()");
            this.r.exec("intsPerRow = pixelData.getRowBytes()");
            int intsPerRow = (Integer)this.r.getVar("intsPerRow") / 4;
            byte[][] px = AWTImageTools.getBytes(AWTImageTools.makeBuffered(image));
            int[] pixels = new int[px[0].length];
            for (int i = 0; i < pixels.length; ++i) {
                int j;
                byte[] b = new byte[4];
                for (j = 0; j < px.length; ++j) {
                    b[j] = px[j][i];
                }
                for (j = px.length; j < 4; ++j) {
                    b[j] = px[j % px.length][i];
                }
                pixels[i] = DataTools.bytesToInt(b, true);
            }
            if (this.pixels2 == null) {
                this.pixels2 = new int[intsPerRow * this.height];
            }
            this.r.exec("nativeLittle = EndianOrder.isNativeLittleEndian()");
            boolean nativeLittle = (Boolean)this.r.getVar("nativeLittle");
            if (nativeLittle) {
                for (int y = 0; y < this.height; ++y) {
                    int offset1 = y * this.width;
                    int offset2 = y * intsPerRow;
                    for (int x = 0; x < this.width; ++x) {
                        this.r.setVar("thisByte", pixels[offset1++]);
                        this.r.exec("b = EndianOrder.flipBigEndianToNative32(thisByte)");
                        this.pixels2[offset2++] = (Integer)this.r.getVar("b");
                    }
                }
            } else {
                for (int i = 0; i < this.height; ++i) {
                    System.arraycopy(pixels, i * this.width, this.pixels2, i * intsPerRow, this.width);
                }
            }
            this.r.setVar("pixels2", this.pixels2);
            this.r.setVar("len", intsPerRow * this.height);
            this.r.exec("pixelData.copyFromArray(zero, pixels2, zero, len)");
            this.r.setVar("four", 4);
            this.r.exec("cfInfo = seq.compressFrame(gw, bounds, four, compressedImage)");
            this.r.exec("similarity = cfInfo.getSimilarity()");
            int sim = (Integer)this.r.getVar("similarity");
            this.r.setVar("syncSample", sim == 0);
            this.r.exec("dataSize = cfInfo.getDataSize()");
            this.r.setVar("fps", this.fps);
            this.r.setVar("frameRate", 600);
            this.r.setVar("rate", 600 / this.fps);
            boolean sync = (Boolean)this.r.getVar("syncSample");
            int syncSample = sync ? 0 : 1;
            this.r.setVar("sync", syncSample);
            this.r.setVar("one", 1);
            this.r.exec("videoMedia.addSample(imageHandle, zero, dataSize, rate, imgDesc, one, sync)");
        }
        catch (ReflectException e) {
            this.trace(e);
            throw new FormatException("Legacy QuickTime writer failed", e);
        }
        if (last) {
            try {
                this.r.exec("videoMedia.endEdits()");
                this.r.exec("duration = videoMedia.getDuration()");
                this.r.setVar("floatOne", 1.0f);
                this.r.exec("videoTrack.insertMedia(zero, zero, duration, floatOne)");
                this.r.exec("omf = OpenMovieFile.asWrite(movFile)");
                this.r.exec("name = movFile.getName()");
                this.r.setVar("minusOne", -1);
                this.r.exec("movie.addResource(omf, minusOne, name)");
                this.r.exec("QTSession.close()");
            }
            catch (ReflectException e) {
                this.trace(e);
                throw new FormatException("Legacy QuickTime writer failed", e);
            }
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public void close() throws IOException {
        this.r = null;
        this.numWritten = 0;
        this.width = 0;
        this.height = 0;
        this.pixels2 = null;
        this.currentId = null;
        this.initialized = false;
    }
}

