/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class ICSWriter
extends FormatWriter {
    private RandomAccessOutputStream out;

    public ICSWriter() {
        super("Image Cytometry Standard", "ics");
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        MetadataRetrieve meta = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(meta, series);
        int pixelType = FormatTools.pixelTypeFromString(meta.getPixelsPixelType(series, 0));
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int rgbChannels = meta.getLogicalChannelSamplesPerPixel(series, 0);
        if (!this.initialized) {
            int i;
            this.initialized = true;
            this.out = new RandomAccessOutputStream(this.currentId);
            this.out.writeBytes("\t\n");
            this.out.writeBytes("ics_version\t2.0\n");
            this.out.writeBytes("filename\t" + this.currentId + "\n");
            this.out.writeBytes("layout\tparameters\t6\n");
            String order = meta.getPixelsDimensionOrder(series, 0);
            int x = meta.getPixelsSizeX(series, 0);
            int y = meta.getPixelsSizeY(series, 0);
            int z = meta.getPixelsSizeZ(series, 0);
            int c = meta.getPixelsSizeC(series, 0);
            int t = meta.getPixelsSizeT(series, 0);
            StringBuffer dimOrder = new StringBuffer();
            int[] sizes = new int[6];
            int nextSize = 0;
            sizes[nextSize++] = 8 * bytesPerPixel;
            if (rgbChannels > 1) {
                dimOrder.append("ch\t");
                sizes[nextSize++] = c;
            }
            for (i = 0; i < order.length(); ++i) {
                if (order.charAt(i) == 'X') {
                    sizes[nextSize++] = x;
                } else if (order.charAt(i) == 'Y') {
                    sizes[nextSize++] = y;
                } else if (order.charAt(i) == 'Z') {
                    sizes[nextSize++] = z;
                } else if (order.charAt(i) == 'T') {
                    sizes[nextSize++] = t;
                } else if (order.charAt(i) == 'C' && dimOrder.indexOf("ch") == -1) {
                    sizes[nextSize++] = c;
                    dimOrder.append("ch");
                }
                if (order.charAt(i) != 'C') {
                    dimOrder.append(String.valueOf(order.charAt(i)).toLowerCase());
                }
                dimOrder.append("\t");
            }
            this.out.writeBytes("layout\torder\tbits\t" + dimOrder.toString() + "\n");
            this.out.writeBytes("layout\tsizes\t");
            for (i = 0; i < sizes.length; ++i) {
                this.out.writeBytes(sizes[i] + "\t");
                if (i != sizes.length - 1) continue;
                this.out.writeBytes("\n");
            }
            boolean signed = pixelType == 0 || pixelType == 2 || pixelType == 4;
            boolean littleEndian = meta.getPixelsBigEndian(series, 0) == false;
            this.out.writeBytes("representation\tformat\t" + (pixelType == 6 ? "real\n" : "integer\n"));
            this.out.writeBytes("representation\tsign\t" + (signed ? "signed\n" : "unsigned\n"));
            this.out.writeBytes("representation\tcompression\tuncompressed\n");
            this.out.writeBytes("representation\tbyte_order\t");
            for (int i2 = 0; i2 < sizes[0] / 8; ++i2) {
                if (littleEndian) {
                    this.out.writeBytes(i2 + 1 + "\t");
                    continue;
                }
                this.out.writeBytes(sizes[0] / 8 - i2 + "\t");
            }
            this.out.writeBytes("\nparameter\tscale\t1.000000\t");
            StringTokenizer st = new StringTokenizer(dimOrder.toString(), "\t");
            StringBuffer units = new StringBuffer();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                Number value = null;
                if (token.equals("x")) {
                    value = meta.getDimensionsPhysicalSizeX(0, 0);
                    units.append("micrometers\t");
                } else if (token.equals("y")) {
                    value = meta.getDimensionsPhysicalSizeY(0, 0);
                    units.append("micrometers\t");
                } else if (token.equals("z")) {
                    value = meta.getDimensionsPhysicalSizeZ(0, 0);
                    units.append("micrometers\t");
                } else if (token.equals("t")) {
                    value = meta.getDimensionsTimeIncrement(0, 0);
                    units.append("seconds\t");
                } else if (token.equals("ch")) {
                    value = meta.getDimensionsWaveIncrement(0, 0);
                    units.append("nm\t");
                }
                if (value == null) {
                    this.out.writeBytes("1.000000\t");
                    continue;
                }
                this.out.writeBytes(value + "\t");
            }
            this.out.writeBytes("\nparameter\tunits\tbits\t" + units.toString() + "\n");
            this.out.writeBytes("\nend\n");
        }
        this.out.seek(this.out.length());
        if (this.interleaved || rgbChannels == 1) {
            this.out.write(buf);
        } else {
            int planeSize = buf.length / rgbChannels;
            for (int i = 0; i < planeSize; i += bytesPerPixel) {
                for (int ch = 0; ch < rgbChannels; ++ch) {
                    this.out.write(buf, ch * planeSize + i, bytesPerPixel);
                }
            }
        }
        if (last) {
            this.close();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }
}

