/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.LeicaHandler;
import loci.formats.in.TiffReader;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.helpers.DefaultHandler;

public class TCSReader
extends FormatReader {
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    private Vector<String> tiffs;
    private TiffReader[] tiffReaders;
    private Vector seriesNames;
    private Vector containerNames;
    private Vector containerCounts;
    private Vector xcal;
    private Vector ycal;
    private Vector zcal;
    private Vector x;
    private Vector y;
    private Vector z;
    private Vector c;
    private Vector t;
    private Vector bits;

    public TCSReader() {
        super("Leica TCS TIFF", new String[]{"tif", "tiff", "xml"});
    }

    public boolean isThisType(String name, boolean open) {
        Location lei;
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (!(lei = new Location(prefix + ".lei")).exists()) {
            lei = new Location(prefix + ".LEI");
            while (!lei.exists() && prefix.indexOf("_") != -1) {
                lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                if (lei.exists()) continue;
                lei = new Location(prefix + ".LEI");
            }
        }
        if (lei.exists()) {
            return false;
        }
        try {
            RandomAccessInputStream s = new RandomAccessInputStream(name);
            boolean isThisType = this.isThisType(s);
            s.close();
            return isThisType;
        }
        catch (IOException e) {
            if (debug) {
                this.trace(e);
            }
            return false;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        String[] ss;
        Hashtable ifd = TiffTools.getFirstIFD(stream);
        if (ifd == null) {
            return false;
        }
        String document = (String)ifd.get(new Integer(269));
        if (document == null) {
            document = "";
        }
        Object s = ifd.get(new Integer(305));
        String software = null;
        if (s instanceof String) {
            software = (String)s;
        } else if (s instanceof String[] && (ss = (String[])s).length > 0) {
            software = ss[0];
        }
        if (software == null) {
            software = "";
        }
        return document.startsWith("CHANNEL") || software.trim().equals("TCSNTV");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[0].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[0].get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int n = no;
        for (int i = 0; i < this.series; ++i) {
            n += this.core[i].imageCount;
        }
        if (this.tiffReaders.length == 1) {
            return this.tiffReaders[0].openBytes(n, buf, x, y, w, h);
        }
        return this.tiffReaders[n].openBytes(0, buf, x, y, w, h);
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            String name = this.currentId.toLowerCase();
            if (name.endsWith(".tif") || name.endsWith(".tiff")) {
                return null;
            }
            return new String[]{this.currentId};
        }
        Vector<String> v = new Vector<String>();
        for (String f : this.tiffs) {
            v.add(f);
        }
        if (!v.contains(this.currentId)) {
            v.add(this.currentId);
        }
        return v.toArray(new String[0]);
    }

    public void close() throws IOException {
        super.close();
        this.tiffs = null;
        this.tiffReaders = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        Location l;
        Location parent;
        String[] list;
        this.debug("TCSReader.initFile(" + id + ")");
        if (TCSReader.checkSuffix(id, TiffReader.TIFF_SUFFIXES) && (list = (parent = (l = new Location(id).getAbsoluteFile()).getParentFile()).list()) != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!TCSReader.checkSuffix(list[i], XML_SUFFIX)) continue;
                this.initFile(new Location(parent, list[i]).getAbsolutePath());
                return;
            }
        }
        super.initFile(id);
        if (TCSReader.checkSuffix(id, XML_SUFFIX)) {
            int i;
            this.in = new RandomAccessInputStream(id);
            MetadataStore store = new DummyMetadata();
            LeicaHandler handler = new LeicaHandler(store);
            String prefix = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>";
            String suffix = "</LEICA>";
            String xml = prefix + this.in.readString((int)this.in.length()) + suffix;
            for (int i2 = 0; i2 < xml.length(); ++i2) {
                char ch = xml.charAt(i2);
                if (!Character.isISOControl(ch) && Character.isDefined(ch)) continue;
                xml = xml.replace(ch, ' ');
            }
            DataTools.parseXML(xml, (DefaultHandler)handler);
            this.xcal = handler.getXCal();
            this.ycal = handler.getYCal();
            this.zcal = handler.getZCal();
            this.seriesNames = handler.getSeriesNames();
            this.containerNames = handler.getContainerNames();
            this.containerCounts = handler.getContainerCounts();
            this.x = handler.getWidths();
            this.y = handler.getHeights();
            this.z = handler.getZs();
            this.c = handler.getChannels();
            this.t = handler.getTs();
            this.bits = handler.getBits();
            this.metadata = handler.getMetadata();
            this.tiffs = new Vector();
            Location parent2 = new Location(id).getAbsoluteFile().getParentFile();
            Object[] list2 = parent2.list();
            Arrays.sort(list2);
            for (i = 0; i < list2.length; ++i) {
                String file2;
                Hashtable ifd;
                String software;
                if (!TCSReader.checkSuffix((String)list2[i], TiffReader.TIFF_SUFFIXES) || (software = (String)TiffTools.getIFDValue(ifd = TiffTools.getIFDs(new RandomAccessInputStream(file2 = new Location(parent2, (String)list2[i]).getAbsolutePath()))[0], 305)) == null || !software.trim().equals("TCSNTV")) continue;
                this.tiffs.add(file2);
            }
            this.tiffReaders = new TiffReader[this.tiffs.size()];
            for (i = 0; i < this.tiffReaders.length; ++i) {
                this.tiffReaders[i] = new TiffReader();
                this.tiffReaders[i].setId(this.tiffs.get(i));
            }
            this.core = new CoreMetadata[this.x.size()];
            for (i = 0; i < this.x.size(); ++i) {
                this.core[i] = new CoreMetadata();
                this.core[i].sizeX = (Integer)this.x.get(i);
                this.core[i].sizeY = (Integer)this.y.get(i);
                this.core[i].sizeZ = this.z.size() > 0 ? (Integer)this.z.get(i) : 1;
                this.core[i].sizeC = this.c.size() > 0 ? (Integer)this.c.get(i) : 1;
                this.core[i].sizeT = this.t.size() > 0 ? (Integer)this.t.get(i) : 1;
                this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeC * this.core[i].sizeT;
                int bpp = (Integer)this.bits.get(i);
                while (bpp % 8 != 0) {
                    ++bpp;
                }
                switch (bpp) {
                    case 8: {
                        this.core[i].pixelType = 1;
                        break;
                    }
                    case 16: {
                        this.core[i].pixelType = 3;
                        break;
                    }
                    case 32: {
                        this.core[i].pixelType = 6;
                    }
                }
                if (this.tiffs.size() < this.core[i].imageCount) {
                    int div = this.core[i].imageCount / this.core[i].sizeC;
                    this.core[i].imageCount = this.tiffs.size();
                    if (div >= this.core[i].sizeZ) {
                        this.core[i].sizeZ /= div;
                    } else if (div >= this.core[i].sizeT) {
                        this.core[i].sizeT /= div;
                    }
                }
                this.core[i].dimensionOrder = this.getSizeZ() > this.getSizeT() ? "XYCZT" : "XYCTZ";
                this.core[i].metadataComplete = true;
                this.core[i].rgb = false;
                this.core[i].interleaved = false;
                this.core[i].indexed = this.tiffReaders[0].isIndexed();
                this.core[i].falseColor = true;
            }
            store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            MetadataTools.populatePixels(store, this, true);
            store.setInstrumentID("Instrument:0", 0);
            for (i = 0; i < this.x.size(); ++i) {
                store.setImageName((String)this.seriesNames.get(i), i);
                MetadataTools.setDefaultCreationDate(store, id, i);
                store.setImageInstrumentRef("Instrument:0", 0);
            }
            for (i = 0; i < this.x.size(); ++i) {
                store.setDimensionsPhysicalSizeX((Float)this.xcal.get(i), i, 0);
                store.setDimensionsPhysicalSizeY((Float)this.ycal.get(i), i, 0);
                store.setDimensionsPhysicalSizeZ((Float)this.zcal.get(i), i, 0);
            }
            DataTools.parseXML(xml, (DefaultHandler)new LeicaHandler(store));
        } else {
            this.tiffs = new Vector();
            this.tiffs.add(id);
            this.tiffReaders = new TiffReader[1];
            this.tiffReaders[0] = new TiffReader();
            this.tiffReaders[0].setMetadataStore(this.getMetadataStore());
            this.tiffReaders[0].setId(id);
            this.in = new RandomAccessInputStream(id);
            Hashtable[] ifds = TiffTools.getIFDs(this.in);
            int[] ch = new int[ifds.length];
            int[] idx = new int[ifds.length];
            long[] stamp = new long[ifds.length];
            int channelCount = 0;
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss.SSS");
            for (int i = 0; i < ifds.length; ++i) {
                String document = (String)ifds[i].get(new Integer(269));
                if (document == null) continue;
                int index = document.indexOf("INDEX");
                String s = document.substring(8, index).trim();
                ch[i] = Integer.parseInt(s);
                if (ch[i] > channelCount) {
                    channelCount = ch[i];
                }
                String n = document.substring(index + 6, document.indexOf(" ", index + 6)).trim();
                idx[i] = Integer.parseInt(n);
                String date = document.substring(document.indexOf(" ", index + 6), document.indexOf("FORMAT")).trim();
                stamp[i] = fmt.parse(date, new ParsePosition(0)).getTime();
            }
            this.core[0].sizeT = 0;
            this.core[0].dimensionOrder = this.isRGB() ? "XYC" : "XY";
            boolean unique = true;
            for (int i = 0; i < stamp.length; ++i) {
                for (int j = i + 1; j < stamp.length; ++j) {
                    if (stamp[j] != stamp[i]) continue;
                    unique = false;
                    break;
                }
                if (unique) {
                    ++this.core[0].sizeT;
                    if (this.getDimensionOrder().indexOf("T") < 0) {
                        this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
                    }
                } else if (i > 0) {
                    if (ch[i] != ch[i - 1] && this.getDimensionOrder().indexOf("C") < 0) {
                        this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                    } else if (this.getDimensionOrder().indexOf("Z") < 0) {
                        this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                    }
                }
                unique = true;
            }
            if (this.getDimensionOrder().indexOf("Z") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
            }
            if (this.getDimensionOrder().indexOf("C") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
            }
            if (this.getDimensionOrder().indexOf("T") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
            }
            if (this.getSizeT() == 0) {
                this.core[0].sizeT = 1;
            }
            if (channelCount == 0) {
                channelCount = 1;
            }
            this.core[0].sizeZ = ifds.length / (this.getSizeT() * channelCount);
            this.core[0].sizeC *= channelCount;
            this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * channelCount;
            String comment = TiffTools.getComment(ifds[0]);
            if (comment != null && comment.startsWith("[")) {
                StringTokenizer st = new StringTokenizer(comment, "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.startsWith("[")) continue;
                    int eq = token.indexOf("=");
                    String key = token.substring(0, eq).trim();
                    String value = token.substring(eq + 1).trim();
                    this.addMeta(key, value);
                }
                this.metadata.remove("Comment");
            }
            this.core = this.tiffReaders[0].getCoreMetadata();
            FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            MetadataTools.populatePixels(store, this, true);
        }
    }
}

