/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class NiftiReader
extends FormatReader {
    private static final int UNITS_METER = 1;
    private static final int UNITS_MM = 2;
    private static final int UNITS_MSEC = 16;
    private static final int UNITS_USEC = 24;
    private int pixelOffset;
    private RandomAccessInputStream pixelFile;
    private String pixelsFilename;

    public NiftiReader() {
        super("NIfTI", new String[]{"nii", "img", "hdr"});
        this.suffixSufficient = false;
        this.blockCheckLen = 348;
    }

    public boolean isThisType(String name, boolean open) {
        String extension;
        int dot = name.lastIndexOf(".") + 1;
        if (dot == 0) {
            dot = name.length();
        }
        if ((extension = name.substring(dot, name.length()).toLowerCase()).equals("nii")) {
            return true;
        }
        String headerFile = name.substring(0, dot - 1) + ".hdr";
        try {
            RandomAccessInputStream header = new RandomAccessInputStream(headerFile);
            boolean isValid = this.isThisType(header);
            header.close();
            return isValid;
        }
        catch (IOException e) {
            if (debug) {
                this.trace(e);
            }
            return false;
        }
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        stream.seek(344L);
        String magic = stream.readString(3);
        return magic.equals("ni1") || magic.equals("n+1");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType());
        this.pixelFile.seek(this.pixelOffset + no * planeSize);
        this.readPlane(this.pixelFile, x, y, w, h, buf);
        return buf;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.pixelsFilename.equals(this.currentId) && noPixels) {
            return null;
        }
        if (!noPixels && !this.pixelsFilename.equals(this.currentId)) {
            return new String[]{this.currentId, this.pixelsFilename};
        }
        return new String[]{this.currentId};
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public void close() throws IOException {
        super.close();
        this.pixelOffset = 0;
        if (this.pixelFile != null) {
            this.pixelFile.close();
        }
        this.pixelFile = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("NiftiReader.initFile(" + id + ")");
        if (id.endsWith(".img")) {
            this.status("Looking for header file");
            String header = id.substring(0, id.lastIndexOf(".")) + ".hdr";
            if (new Location(header).exists()) {
                this.setId(header);
                return;
            }
            throw new FormatException("Header file not found.");
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.seek(40L);
        short check = this.in.readShort();
        boolean little = check < 1 || check > 7;
        this.in.seek(0L);
        if (id.endsWith(".hdr")) {
            this.pixelsFilename = id.substring(0, id.lastIndexOf(".")) + ".img";
            this.pixelFile = new RandomAccessInputStream(this.pixelsFilename);
        } else if (id.endsWith(".nii")) {
            this.pixelsFilename = id;
            this.pixelFile = this.in;
        }
        this.in.order(little);
        this.pixelFile.order(little);
        this.status("Reading header");
        int fileSize = this.in.readInt();
        this.in.skipBytes(35);
        char sliceOrdering = this.in.readChar();
        short nDimensions = this.in.readShort();
        short x = this.in.readShort();
        short y = this.in.readShort();
        short z = this.in.readShort();
        short t = this.in.readShort();
        short dim5 = this.in.readShort();
        short dim6 = this.in.readShort();
        short dim7 = this.in.readShort();
        float intent1 = this.in.readFloat();
        float intent2 = this.in.readFloat();
        float intent3 = this.in.readFloat();
        short intentCode = this.in.readShort();
        short dataType = this.in.readShort();
        short bitpix = this.in.readShort();
        short sliceStart = this.in.readShort();
        this.in.skipBytes(4);
        float voxelWidth = this.in.readFloat();
        float voxelHeight = this.in.readFloat();
        float sliceThickness = this.in.readFloat();
        float deltaT = this.in.readFloat();
        this.in.skipBytes(12);
        this.pixelOffset = (int)this.in.readFloat();
        float scaleSlope = this.in.readFloat();
        float scaleIntercept = this.in.readFloat();
        short sliceEnd = this.in.readShort();
        char sliceCode = this.in.readChar();
        char units = this.in.readChar();
        int spatialUnits = units & 7;
        int timeUnits = units & 0x38;
        int spatialCorrection = 1;
        switch (spatialUnits) {
            case 1: {
                spatialCorrection = 1000000;
                break;
            }
            case 2: {
                spatialCorrection = 1000;
            }
        }
        voxelWidth *= (float)spatialCorrection;
        voxelHeight *= (float)spatialCorrection;
        sliceThickness *= (float)spatialCorrection;
        int timeCorrection = 1;
        switch (timeUnits) {
            case 16: {
                timeCorrection = 1000;
                break;
            }
            case 24: {
                timeCorrection = 1000000;
            }
        }
        deltaT /= (float)timeCorrection;
        float calMax = this.in.readFloat();
        float calMin = this.in.readFloat();
        float sliceDuration = this.in.readFloat();
        float toffset = this.in.readFloat();
        this.in.skipBytes(8);
        String description = this.in.readString(80);
        this.in.skipBytes(24);
        short qformCode = this.in.readShort();
        short sformCode = this.in.readShort();
        float quaternionB = this.in.readFloat();
        float quaternionC = this.in.readFloat();
        float quaternionD = this.in.readFloat();
        float quaternionX = this.in.readFloat();
        float quaternionY = this.in.readFloat();
        float quaternionZ = this.in.readFloat();
        float[][] transform = new float[3][4];
        for (int i = 0; i < transform.length; ++i) {
            for (int j = 0; j < transform[i].length; ++j) {
                transform[i][j] = this.in.readFloat();
            }
        }
        String intentName = this.in.readString(16);
        this.in.skipBytes(4);
        if (this.in.getFilePointer() < this.in.length()) {
            byte extension = this.in.readByte();
            this.in.skipBytes(3);
            if (extension != 0) {
                long max;
                long l = max = this.in.equals(this.pixelFile) ? (long)this.pixelOffset : this.in.length();
                while (this.in.getFilePointer() < max) {
                    long fp = this.in.getFilePointer();
                    int esize = this.in.readInt();
                    int ecode = this.in.readInt();
                    if (ecode == 2 || ecode == 4) {
                        // empty if block
                    }
                    this.in.seek(fp + (long)esize);
                }
            }
        }
        this.status("Populating metadata table");
        for (int i = 0; i < transform.length; ++i) {
            String axis = i == 0 ? "X" : (i == 1 ? "Y" : "Z");
            for (int j = 0; j < transform[i].length; ++j) {
                this.addMeta("Affine transform " + axis + "[" + j + "]", transform[i][j]);
            }
        }
        this.addMeta("Intent name", intentName);
        this.addMeta("Slice Ordering", sliceOrdering);
        this.addMeta("Number of dimensions", nDimensions);
        this.addMeta("Width", x);
        this.addMeta("Height", y);
        this.addMeta("Number of Z slices", z);
        this.addMeta("Number of time points", t);
        this.addMeta("Dimension 5", dim5);
        this.addMeta("Dimension 6", dim6);
        this.addMeta("Dimension 7", dim7);
        this.addMeta("Intent #1", intent1);
        this.addMeta("Intent #2", intent2);
        this.addMeta("Intent #3", intent3);
        this.addMeta("Intent code", intentCode);
        this.addMeta("Data type", dataType);
        this.addMeta("Bits per pixel", bitpix);
        this.addMeta("Slice start", sliceStart);
        this.addMeta("Voxel width", voxelWidth);
        this.addMeta("Voxel height", voxelHeight);
        this.addMeta("Slice thickness", sliceThickness);
        this.addMeta("Time increment", deltaT);
        this.addMeta("Scale slope", scaleSlope);
        this.addMeta("Scale intercept", scaleIntercept);
        this.addMeta("Slice end", sliceEnd);
        this.addMeta("Calibrated maximum", calMax);
        this.addMeta("Calibrated minimum", calMin);
        this.addMeta("Slice duration", sliceDuration);
        this.addMeta("Time offset", toffset);
        this.addMeta("Description", description);
        this.addMeta("Q-form Code", qformCode);
        this.addMeta("S-form Code", sformCode);
        this.addMeta("Quaternion b parameter", quaternionB);
        this.addMeta("Quaternion c parameter", quaternionC);
        this.addMeta("Quaternion d parameter", quaternionD);
        this.addMeta("Quaternion x parameter", quaternionX);
        this.addMeta("Quaternion y parameter", quaternionY);
        this.addMeta("Quaternion z parameter", quaternionZ);
        this.status("Populating core metadata");
        this.core[0].sizeX = x;
        this.core[0].sizeY = y;
        this.core[0].sizeZ = z;
        this.core[0].sizeT = t;
        this.core[0].sizeC = 1;
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZTC";
        switch (dataType) {
            case 1: 
            case 2: {
                this.core[0].pixelType = 1;
                break;
            }
            case 4: {
                this.core[0].pixelType = 2;
                break;
            }
            case 8: {
                this.core[0].pixelType = 4;
                break;
            }
            case 16: {
                this.core[0].pixelType = 6;
                break;
            }
            case 64: {
                this.core[0].pixelType = 7;
                break;
            }
            case 128: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 3;
                this.core[0].rgb = true;
                this.core[0].interleaved = true;
                this.core[0].dimensionOrder = "XYCZT";
            }
            case 256: {
                this.core[0].pixelType = 0;
                break;
            }
            case 512: {
                this.core[0].pixelType = 3;
                break;
            }
            case 768: {
                this.core[0].pixelType = 5;
                break;
            }
            case 2304: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 4;
                this.core[0].rgb = true;
                this.core[0].interleaved = true;
                this.core[0].dimensionOrder = "XYCZT";
            }
            default: {
                throw new FormatException("Unsupported data type: " + dataType);
            }
        }
        this.status("Populating MetadataStore");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageDescription(description, 0);
        store.setDimensionsPhysicalSizeX(new Float(voxelWidth), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(voxelHeight), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(sliceThickness), 0, 0);
        store.setDimensionsTimeIncrement(new Float(deltaT), 0, 0);
    }
}

