/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class MRCReader
extends FormatReader {
    private int bpp = 0;
    private int extHeaderSize = 0;
    private boolean isFloat = false;

    public MRCReader() {
        super("Medical Research Council", "mrc");
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(1024 + no * this.getSizeX() * this.getSizeY() * this.bpp);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.extHeaderSize = 0;
        this.bpp = 0;
        this.isFloat = false;
    }

    public void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("MRCReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Reading header");
        this.in.seek(213L);
        this.core[0].littleEndian = this.in.read() == 68;
        this.in.seek(0L);
        this.in.order(this.core[0].littleEndian);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].sizeZ = this.in.readInt();
        this.core[0].sizeC = 1;
        int mode = this.in.readInt();
        switch (mode) {
            case 0: {
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                this.core[0].pixelType = 2;
                break;
            }
            case 6: {
                this.core[0].pixelType = 3;
                break;
            }
            case 2: {
                this.isFloat = true;
                this.core[0].pixelType = 6;
                break;
            }
            case 3: {
                this.core[0].pixelType = 5;
                break;
            }
            case 4: {
                this.isFloat = true;
                this.core[0].pixelType = 7;
                break;
            }
            case 16: {
                this.core[0].sizeC = 3;
                this.core[0].pixelType = 3;
            }
        }
        this.bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int mx = this.in.readInt();
        int my = this.in.readInt();
        int mz = this.in.readInt();
        float xlen = this.in.readFloat();
        float ylen = this.in.readFloat();
        float zlen = this.in.readFloat();
        this.addMeta("Pixel size (X)", xlen / (float)mx);
        this.addMeta("Pixel size (Y)", ylen / (float)my);
        this.addMeta("Pixel size (Z)", zlen / (float)mz);
        this.addMeta("Alpha angle", this.in.readFloat());
        this.addMeta("Beta angle", this.in.readFloat());
        this.addMeta("Gamma angle", this.in.readFloat());
        this.in.skipBytes(12);
        this.addMeta("Minimum pixel value", this.in.readFloat());
        this.addMeta("Maximum pixel value", this.in.readFloat());
        this.addMeta("Mean pixel value", this.in.readFloat());
        this.in.skipBytes(4);
        this.extHeaderSize = this.in.readInt();
        this.in.skipBytes(64);
        short idtype = this.in.readShort();
        String[] types = new String[]{"mono", "tilt", "tilts", "lina", "lins"};
        String type = idtype >= 0 && idtype < types.length ? types[idtype] : "unknown";
        this.addMeta("Series type", type);
        this.addMeta("Lens", this.in.readShort());
        this.addMeta("ND1", this.in.readShort());
        this.addMeta("ND2", this.in.readShort());
        this.addMeta("VD1", this.in.readShort());
        this.addMeta("VD2", this.in.readShort());
        for (i = 0; i < 6; ++i) {
            this.addMeta("Angle " + (i + 1), this.in.readFloat());
        }
        this.in.skipBytes(24);
        this.addMeta("Number of useful labels", this.in.readInt());
        for (i = 0; i < 10; ++i) {
            this.addMeta("Label " + (i + 1), this.in.readString(80));
        }
        this.in.skipBytes(this.extHeaderSize);
        this.status("Populating metadata");
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYZTC";
        this.core[0].imageCount = this.getSizeZ();
        this.core[0].rgb = false;
        this.core[0].interleaved = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        float x = xlen / (float)mx == Float.POSITIVE_INFINITY ? 1.0f : xlen / (float)mx;
        float y = ylen / (float)my == Float.POSITIVE_INFINITY ? 1.0f : ylen / (float)my;
        float z = zlen / (float)mz == Float.POSITIVE_INFINITY ? 1.0f : zlen / (float)mz;
        store.setDimensionsPhysicalSizeX(new Float(x), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(y), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(z), 0, 0);
    }
}

