/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class ImarisReader
extends FormatReader {
    private static final int IMARIS_MAGIC_NUMBER = 5021964;
    private static final boolean IS_LITTLE = false;
    private int[] offsets;

    public ImarisReader() {
        super("Bitplane Imaris", "ims");
        this.blockCheckLen = 4;
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readInt() == 5021964;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(this.offsets[no] + this.getSizeX() * (this.getSizeY() - y - h));
        for (int row = h - 1; row >= 0; --row) {
            this.in.skipBytes(x);
            this.in.read(buf, row * w, w);
            this.in.skipBytes(this.getSizeX() - w - x);
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.offsets = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("ImarisReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Verifying Imaris RAW format");
        this.in.order(false);
        long magic = this.in.readInt();
        if (magic != 5021964L) {
            throw new FormatException("Imaris magic number not found.");
        }
        this.status("Reading header");
        this.addMeta("Version", this.in.readInt());
        this.in.skipBytes(4);
        this.addMeta("Image name", this.in.readString(128));
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        this.core[0].sizeZ = this.in.readShort();
        this.in.skipBytes(2);
        this.core[0].sizeC = this.in.readInt();
        this.in.skipBytes(2);
        this.addMeta("Original date", this.in.readString(32));
        float dx = this.in.readFloat();
        float dy = this.in.readFloat();
        float dz = this.in.readFloat();
        short mag = this.in.readShort();
        this.addMeta("Image comment", this.in.readString(128));
        int isSurvey = this.in.readInt();
        this.addMeta("Survey performed", isSurvey == 0);
        this.status("Calculating image offsets");
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC();
        this.offsets = new int[this.getImageCount()];
        float[] gains = new float[this.getSizeC()];
        float[] detectorOffsets = new float[this.getSizeC()];
        float[] pinholes = new float[this.getSizeC()];
        for (int i2 = 0; i2 < this.getSizeC(); ++i2) {
            this.addMeta("Channel #" + i2 + " Comment", this.in.readString(128));
            gains[i2] = this.in.readFloat();
            detectorOffsets[i2] = this.in.readFloat();
            pinholes[i2] = this.in.readFloat();
            this.in.skipBytes(24);
            int offset = 336 + 164 * this.getSizeC() + i2 * this.getSizeX() * this.getSizeY() * this.getSizeZ();
            for (int j = 0; j < this.getSizeZ(); ++j) {
                this.offsets[i2 * this.getSizeZ() + j] = offset + j * this.getSizeX() * this.getSizeY();
            }
        }
        this.status("Populating metadata");
        this.core[0].sizeT = this.getImageCount() / (this.getSizeC() * this.getSizeZ());
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = false;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        this.core[0].pixelType = 1;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        store.setDimensionsPhysicalSizeX(new Float(dx), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(dy), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(dz), 0, 0);
        store.setDimensionsTimeIncrement(new Float(1.0f), 0, 0);
        store.setDimensionsWaveIncrement(new Integer(1), 0, 0);
        for (i = 0; i < this.getSizeC(); ++i) {
            if (!(pinholes[i] > 0.0f)) continue;
            store.setLogicalChannelPinholeSize(new Float(pinholes[i]), 0, i);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (gains[i] > 0.0f) {
                store.setDetectorSettingsGain(new Float(gains[i]), 0, i);
            }
            store.setDetectorSettingsOffset(new Float(this.offsets[i]), i, 0);
            store.setDetectorID("Detector:" + i, 0, i);
            store.setDetectorSettingsDetector("Detector:" + i, 0, i);
        }
    }
}

