/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FlexReader
extends BaseTiffReader {
    public static final int FLEX = 65200;
    protected double[] factors;
    private int binX;
    private int binY;
    private int plateCount;
    private int wellCount;
    private int fieldCount;
    private Vector<String> channelNames;
    private Vector<Float> xPositions;
    private Vector<Float> yPositions;
    private Vector<String> lightSourceIDs;
    private Vector<Float> xResolutions;
    private Vector<Float> yResolutions;

    public FlexReader() {
        super("Evotec Flex", "flex");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int ifdIndex = this.getSeries() * this.getImageCount() + no;
        int nBytes = TiffTools.getBitsPerSample(this.ifds[ifdIndex])[0] / 8;
        byte[] bytes = TiffTools.getSamples(this.ifds[ifdIndex], this.in, buf, x, y, w, h);
        if (this.getPixelType() == 1) {
            int num = bytes.length;
            for (int i = num - 1; i >= 0; --i) {
                int q = (int)((double)(bytes[i] & 0xFF) * this.factors[ifdIndex]);
                bytes[i] = (byte)(q & 0xFF);
            }
        } else if (this.getPixelType() == 3) {
            int num = bytes.length / 2;
            for (int i = num - 1; i >= 0; --i) {
                int q = nBytes == 1 ? (int)((double)(bytes[i] & 0xFF) * this.factors[ifdIndex]) : (int)((double)DataTools.bytesToInt(bytes, i * 2, 2, this.isLittleEndian()) * this.factors[ifdIndex]);
                DataTools.unpackBytes(q, bytes, i * 2, 2, this.isLittleEndian());
            }
        } else if (this.getPixelType() == 5) {
            int num = bytes.length / 4;
            for (int i = num - 1; i >= 0; --i) {
                int q = nBytes == 1 ? (int)((double)(bytes[i] & 0xFF) * this.factors[ifdIndex]) : (int)((double)DataTools.bytesToInt(bytes, i * 4, nBytes, this.isLittleEndian()) * this.factors[ifdIndex]);
                DataTools.unpackBytes(q, bytes, i * 4, 4, this.isLittleEndian());
            }
        }
        System.arraycopy(bytes, 0, buf, 0, bytes.length);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.factors = null;
        this.binY = 0;
        this.binX = 0;
        this.fieldCount = 0;
        this.wellCount = 0;
        this.plateCount = 0;
        this.channelNames = null;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        int i2;
        int fsize;
        super.initStandardMetadata();
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].sizeC = 0;
        this.core[0].sizeT = 0;
        this.core[0].sizeZ = 0;
        this.channelNames = new Vector();
        this.xPositions = new Vector();
        this.yPositions = new Vector();
        this.lightSourceIDs = new Vector();
        this.xResolutions = new Vector();
        this.yResolutions = new Vector();
        String xml = (String)TiffTools.getIFDValue(this.ifds[0], 65200, true, String.class);
        byte[] c = xml.getBytes();
        for (int i3 = 0; i3 < c.length; ++i3) {
            if (c[i3] <= 126 && (c[i3] == 9 || c[i3] >= 32)) continue;
            c[i3] = 32;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        Vector<String> n = new Vector<String>();
        Vector<String> f = new Vector<String>();
        FlexHandler handler = new FlexHandler(n, f, store);
        DataTools.parseXML(c, (DefaultHandler)handler);
        this.core[0].sizeC = Math.max(this.channelNames.size(), 1);
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.plateCount == 0) {
            this.plateCount = 1;
        }
        if (this.wellCount == 0) {
            this.wellCount = 1;
        }
        if (this.fieldCount == 0) {
            this.fieldCount = 1;
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        int seriesCount = this.plateCount * this.wellCount * this.fieldCount;
        if (this.getImageCount() * seriesCount < this.ifds.length) {
            if (this.fieldCount == 1) {
                this.fieldCount = this.ifds.length / this.getSizeC();
                seriesCount = this.plateCount * this.wellCount * this.fieldCount;
            }
            this.core[0].imageCount = this.ifds.length / seriesCount;
            if (this.getSizeZ() <= 1) {
                this.core[0].sizeZ = this.getImageCount() / this.getSizeC();
            }
            this.core[0].sizeT = this.getImageCount() / (this.getSizeC() * this.getSizeZ());
        } else if (this.getImageCount() == this.ifds.length) {
            seriesCount = 1;
        }
        CoreMetadata oldCore = this.core[0];
        this.core = new CoreMetadata[seriesCount];
        this.core[0] = oldCore;
        for (int i4 = 1; i4 < seriesCount; ++i4) {
            this.core[i4] = new CoreMetadata();
            this.core[i4].sizeX = this.getSizeX();
            this.core[i4].sizeY = this.getSizeY();
            this.core[i4].sizeZ = this.getSizeZ();
            this.core[i4].sizeC = this.getSizeC();
            this.core[i4].sizeT = this.getSizeT();
            this.core[i4].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            this.core[i4].dimensionOrder = this.getDimensionOrder();
            this.core[i4].rgb = this.isRGB();
            this.core[i4].interleaved = this.isInterleaved();
            this.core[i4].indexed = this.isIndexed();
            this.core[i4].littleEndian = this.isLittleEndian();
        }
        int totalPlanes = this.getSeriesCount() * this.getImageCount();
        int nsize = n.size();
        if (nsize != (fsize = f.size()) || nsize != totalPlanes) {
            this.warn("Mismatch between image count, names and factors (count=" + totalPlanes + ", names=" + nsize + ", factors=" + fsize + ")");
        }
        for (i2 = 0; i2 < nsize; ++i2) {
            this.addMeta("Name " + i2, n.get(i2));
        }
        for (i2 = 0; i2 < fsize; ++i2) {
            this.addMeta("Factor " + i2, f.get(i2));
        }
        this.factors = new double[totalPlanes];
        int max = 0;
        for (i = 0; i < Math.min(fsize, totalPlanes); ++i) {
            String factor = f.get(i);
            double q = 1.0;
            try {
                q = Double.parseDouble(factor);
            }
            catch (NumberFormatException exc) {
                this.warn("Invalid factor #" + i + ": " + factor);
            }
            this.factors[i] = q;
            if (!(q > this.factors[max])) continue;
            max = i;
        }
        if (fsize < this.factors.length) {
            Arrays.fill(this.factors, fsize, this.factors.length, 1.0);
        }
        if (this.factors[max] > 256.0) {
            this.core[0].pixelType = 5;
        } else if (this.factors[max] > 1.0) {
            this.core[0].pixelType = 3;
        }
        for (i = 1; i < this.core.length; ++i) {
            this.core[i].pixelType = this.getPixelType();
        }
        MetadataTools.populatePixels(store, this);
        store.setInstrumentID("Instrument:0", 0);
        int[] lengths = new int[]{this.plateCount, this.wellCount, this.fieldCount};
        for (int i5 = 0; i5 < this.getSeriesCount(); ++i5) {
            int[] pos = FormatTools.rasterToPosition(lengths, i5);
            if (i5 < this.xResolutions.size()) {
                store.setDimensionsPhysicalSizeX(this.xResolutions.get(i5), i5, 0);
            }
            if (i5 < this.yResolutions.size()) {
                store.setDimensionsPhysicalSizeY(this.yResolutions.get(i5), i5, 0);
            }
            store.setImageID("Image:" + i5, i5);
            store.setImageInstrumentRef("Instrument:0", i5);
            store.setWellSampleIndex(new Integer(i5), pos[0], pos[1], pos[2]);
            store.setWellSampleImageRef("Image:" + i5, pos[0], pos[1], pos[2]);
            if (pos[2] < this.xPositions.size()) {
                store.setWellSamplePosX(this.xPositions.get(pos[2]), pos[0], pos[1], pos[2]);
            }
            if (pos[2] >= this.yPositions.size()) continue;
            store.setWellSamplePosY(this.yPositions.get(pos[2]), pos[0], pos[1], pos[2]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FlexHandler
    extends DefaultHandler {
        private Vector<String> names;
        private Vector<String> factors;
        private MetadataStore store;
        private int nextLightSource = 0;
        private int nextLaser = -1;
        private int nextSlider = 0;
        private int nextFilter = 0;
        private int nextCamera = 0;
        private int nextObjective = -1;
        private int nextSublayout = 0;
        private int nextField = 0;
        private int nextStack = 0;
        private int nextPlane = 0;
        private int nextKinetic = 0;
        private int nextDispensing = 0;
        private int nextImage = 0;
        private int nextLightSourceCombination = 0;
        private int nextLightSourceRef = 0;
        private int nextPlate = 0;
        private int nextWell = 0;
        private int nextSliderRef = 0;
        private int nextFilterCombination = 0;
        private Hashtable<String, Integer> fieldCounts;
        private String currentSublayout;
        private String parentQName;
        private String currentQName;

        public FlexHandler(Vector<String> names, Vector<String> factors, MetadataStore store) {
            this.names = names;
            this.factors = factors;
            this.store = store;
            this.fieldCounts = new Hashtable();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentQName.equals("SublayoutRef")) {
                FlexReader.this.fieldCount = this.fieldCounts.get(value);
            }
            if (this.currentQName.equals("PlateName")) {
                this.store.setPlateName(value, this.nextPlate - 1);
                FlexReader.this.addMeta("Plate " + (this.nextPlate - 1) + " Name", value);
            } else if (this.parentQName.equals("Plate")) {
                FlexReader.this.addMeta("Plate " + (this.nextPlate - 1) + " " + this.currentQName, value);
            } else if (this.parentQName.equals("WellShape")) {
                FlexReader.this.addMeta("Plate " + (this.nextPlate - 1) + " WellShape " + this.currentQName, value);
            } else if (this.currentQName.equals("Wavelength")) {
                this.store.setLaserWavelength(new Integer(value), 0, this.nextLaser);
                FlexReader.this.addMeta("Laser " + this.nextLaser + " Wavelength", value);
            } else if (this.currentQName.equals("Magnification")) {
                this.store.setObjectiveCalibratedMagnification(new Float(value), 0, this.nextObjective);
            } else if (this.currentQName.equals("NumAperture")) {
                this.store.setObjectiveLensNA(new Float(value), 0, this.nextObjective);
            } else if (this.currentQName.equals("Immersion")) {
                this.store.setObjectiveImmersion(value, 0, this.nextObjective);
            } else if (this.currentQName.equals("OffsetX") || this.currentQName.equals("OffsetY")) {
                FlexReader.this.addMeta("Sublayout " + (this.nextSublayout - 1) + " Field " + (this.nextField - 1) + " " + this.currentQName, value);
                Float offset = new Float(value);
                if (this.currentQName.equals("OffsetX")) {
                    FlexReader.this.xPositions.add(offset);
                } else {
                    FlexReader.this.yPositions.add(offset);
                }
            } else if (this.currentQName.equals("OffsetZ")) {
                FlexReader.this.addMeta("Stack " + (this.nextStack - 1) + " Plane " + (this.nextPlane - 1) + " OffsetZ", value);
            } else if (this.currentQName.equals("Power")) {
                FlexReader.this.addMeta("LightSourceCombination " + (this.nextLightSourceCombination - 1) + " LightSourceRef " + (this.nextLightSourceRef - 1) + " Power", value);
            } else if (this.parentQName.equals("Image")) {
                FlexReader.this.addMeta("Image " + (this.nextImage - 1) + " " + this.currentQName, value);
                if (this.currentQName.equals("DateTime") && this.nextImage == 1) {
                    this.store.setImageCreationDate(value, 0);
                } else if (this.currentQName.equals("CameraBinningX")) {
                    FlexReader.this.binX = Integer.parseInt(value);
                } else if (this.currentQName.equals("CameraBinningY")) {
                    FlexReader.this.binY = Integer.parseInt(value);
                }
            } else if (this.parentQName.equals("ImageResolutionX")) {
                try {
                    FlexReader.this.xResolutions.add(new Float(value));
                }
                catch (NumberFormatException e) {}
            } else if (this.parentQName.equals("ImageResolutionY")) {
                try {
                    FlexReader.this.yResolutions.add(new Float(value));
                }
                catch (NumberFormatException e) {}
            } else if (this.parentQName.equals("Well")) {
                FlexReader.this.addMeta("Well " + (this.nextWell - 1) + " " + this.currentQName, value);
            } else if (this.parentQName.equals("FLIM")) {
                FlexReader.this.addMeta("FLIM " + this.nextImage + " " + this.currentQName, value);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            block35: {
                block53: {
                    block54: {
                        block52: {
                            block51: {
                                block50: {
                                    block49: {
                                        block48: {
                                            block47: {
                                                block46: {
                                                    block45: {
                                                        block44: {
                                                            block43: {
                                                                int count;
                                                                block42: {
                                                                    block41: {
                                                                        block40: {
                                                                            block39: {
                                                                                block38: {
                                                                                    block37: {
                                                                                        block36: {
                                                                                            block34: {
                                                                                                this.currentQName = qName;
                                                                                                if (!qName.equals("Array")) break block34;
                                                                                                int len = attributes.getLength();
                                                                                                for (int i = 0; i < len; ++i) {
                                                                                                    String name = attributes.getQName(i);
                                                                                                    if (name.equals("Name")) {
                                                                                                        String imageName = attributes.getValue(i);
                                                                                                        this.names.add(imageName);
                                                                                                        this.store.setImageName(imageName, 0);
                                                                                                        imageName = imageName.substring(imageName.indexOf("_") + 1);
                                                                                                        if (FlexReader.this.channelNames.contains(imageName)) continue;
                                                                                                        FlexReader.this.channelNames.add(imageName);
                                                                                                        continue;
                                                                                                    }
                                                                                                    if (name.equals("Factor")) {
                                                                                                        this.factors.add(attributes.getValue(i));
                                                                                                        continue;
                                                                                                    }
                                                                                                    if (!name.equals("Description")) continue;
                                                                                                    this.store.setImageDescription(attributes.getValue(i), 0);
                                                                                                }
                                                                                                break block35;
                                                                                            }
                                                                                            if (!qName.equals("LightSource")) break block36;
                                                                                            this.parentQName = qName;
                                                                                            String id = attributes.getValue("ID");
                                                                                            String type = attributes.getValue("LightSourceType");
                                                                                            FlexReader.this.addMeta("LightSource " + this.nextLightSource + " ID", id);
                                                                                            FlexReader.this.addMeta("LightSource " + this.nextLightSource + " Type", type);
                                                                                            if (type.equals("Laser")) {
                                                                                                ++this.nextLaser;
                                                                                            }
                                                                                            ++this.nextLightSource;
                                                                                            break block35;
                                                                                        }
                                                                                        if (!qName.equals("Slider")) break block37;
                                                                                        this.parentQName = qName;
                                                                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                            FlexReader.this.addMeta("Slider " + this.nextSlider + " " + attributes.getQName(i), attributes.getValue(i));
                                                                                        }
                                                                                        ++this.nextSlider;
                                                                                        break block35;
                                                                                    }
                                                                                    if (!qName.equals("Filter")) break block38;
                                                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                        FlexReader.this.addMeta("Filter " + this.nextFilter + " " + attributes.getQName(i), attributes.getValue(i));
                                                                                    }
                                                                                    ++this.nextFilter;
                                                                                    break block35;
                                                                                }
                                                                                if (!qName.equals("Camera")) break block39;
                                                                                this.parentQName = qName;
                                                                                for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                    FlexReader.this.addMeta("Camera " + this.nextCamera + " " + attributes.getQName(i), attributes.getValue(i));
                                                                                }
                                                                                ++this.nextCamera;
                                                                                break block35;
                                                                            }
                                                                            if (!qName.startsWith("PixelSize") || !this.parentQName.equals("Camera")) break block40;
                                                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                FlexReader.this.addMeta("Camera " + (this.nextCamera - 1) + " " + qName + " " + attributes.getQName(i), attributes.getValue(i));
                                                                            }
                                                                            break block35;
                                                                        }
                                                                        if (!qName.equals("Objective")) break block41;
                                                                        this.parentQName = qName;
                                                                        ++this.nextObjective;
                                                                        this.store.setObjectiveID("Objective:" + this.nextObjective, 0, 0);
                                                                        this.store.setObjectiveSettingsObjective("Objective:" + this.nextObjective, 0);
                                                                        this.store.setObjectiveCorrection("Unknown", 0, 0);
                                                                        break block35;
                                                                    }
                                                                    if (!qName.equals("Sublayout")) break block42;
                                                                    this.parentQName = qName;
                                                                    this.nextField = 0;
                                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                                        FlexReader.this.addMeta("Sublayout " + this.nextSublayout + " " + attributes.getQName(i), attributes.getValue(i));
                                                                    }
                                                                    ++this.nextSublayout;
                                                                    String id = attributes.getValue("ID");
                                                                    if (id == null) break block35;
                                                                    this.currentSublayout = id;
                                                                    if (!this.fieldCounts.containsKey(this.currentSublayout)) {
                                                                        this.fieldCounts.put(this.currentSublayout, new Integer(0));
                                                                    }
                                                                    break block35;
                                                                }
                                                                if (!qName.equals("Field")) break block43;
                                                                this.parentQName = qName;
                                                                for (int i = 0; i < attributes.getLength(); ++i) {
                                                                    FlexReader.this.addMeta("Sublayout " + (this.nextSublayout - 1) + " Field " + this.nextField + " " + attributes.getQName(i), attributes.getValue(i));
                                                                }
                                                                ++this.nextField;
                                                                int fieldNo = Integer.parseInt(attributes.getValue("No"));
                                                                if (fieldNo > (count = this.fieldCounts.get(this.currentSublayout).intValue())) {
                                                                    ++count;
                                                                }
                                                                this.fieldCounts.put(this.currentSublayout, new Integer(count));
                                                                break block35;
                                                            }
                                                            if (!qName.equals("Stack")) break block44;
                                                            this.nextPlane = 0;
                                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                                FlexReader.this.addMeta("Stack " + this.nextStack + " " + attributes.getQName(i), attributes.getValue(i));
                                                            }
                                                            ++this.nextStack;
                                                            break block35;
                                                        }
                                                        if (!qName.equals("Plane")) break block45;
                                                        this.parentQName = qName;
                                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                                            FlexReader.this.addMeta("Stack " + (this.nextStack - 1) + " Plane " + this.nextPlane + " " + attributes.getQName(i), attributes.getValue(i));
                                                        }
                                                        ++this.nextPlane;
                                                        int planeNo = Integer.parseInt(attributes.getValue("No"));
                                                        if (planeNo <= FlexReader.this.getSizeZ()) break block35;
                                                        ++((FlexReader)FlexReader.this).core[0].sizeZ;
                                                        break block35;
                                                    }
                                                    if (!qName.equals("Kinetic")) break block46;
                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                        FlexReader.this.addMeta("Kinetic " + this.nextKinetic + " " + attributes.getQName(i), attributes.getValue(i));
                                                    }
                                                    ++this.nextKinetic;
                                                    break block35;
                                                }
                                                if (!qName.equals("Dispensing")) break block47;
                                                for (int i = 0; i < attributes.getLength(); ++i) {
                                                    FlexReader.this.addMeta("Dispensing " + this.nextDispensing + " " + attributes.getQName(i), attributes.getValue(i));
                                                }
                                                ++this.nextDispensing;
                                                break block35;
                                            }
                                            if (!qName.equals("LightSourceCombination")) break block48;
                                            this.nextLightSourceRef = 0;
                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                FlexReader.this.addMeta("LightSourceCombination " + this.nextLightSourceCombination + " " + attributes.getQName(i), attributes.getValue(i));
                                            }
                                            ++this.nextLightSourceCombination;
                                            FlexReader.this.lightSourceIDs.add(attributes.getValue("ID"));
                                            break block35;
                                        }
                                        if (!qName.equals("LightSourceRef")) break block49;
                                        this.parentQName = qName;
                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                            FlexReader.this.addMeta("LightSourceCombination " + (this.nextLightSourceCombination - 1) + " LightSourceRef " + this.nextLightSourceRef + " " + attributes.getQName(i), attributes.getValue(i));
                                        }
                                        ++this.nextLightSourceRef;
                                        break block35;
                                    }
                                    if (!qName.equals("FilterCombination")) break block50;
                                    this.parentQName = qName;
                                    this.nextSliderRef = 0;
                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                        FlexReader.this.addMeta("FilterCombination " + this.nextFilterCombination + " " + attributes.getQName(i), attributes.getValue(i));
                                    }
                                    ++this.nextFilterCombination;
                                    break block35;
                                }
                                if (!qName.equals("SliderRef")) break block51;
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    FlexReader.this.addMeta("FilterCombination " + (this.nextFilterCombination - 1) + " SliderRef " + this.nextSliderRef + " " + attributes.getQName(i), attributes.getValue(i));
                                }
                                ++this.nextSliderRef;
                                break block35;
                            }
                            if (!qName.equals("Image")) break block52;
                            this.parentQName = qName;
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                FlexReader.this.addMeta("Image " + this.nextImage + " " + attributes.getQName(i), attributes.getValue(i));
                            }
                            ++this.nextImage;
                            String x = attributes.getValue("CameraBinningX");
                            String y = attributes.getValue("CameraBinningY");
                            if (x != null) {
                                FlexReader.this.binX = Integer.parseInt(x);
                            }
                            if (y == null) break block35;
                            FlexReader.this.binY = Integer.parseInt(y);
                            break block35;
                        }
                        if (!qName.equals("Plate") && !qName.equals("WellShape") && !qName.equals("Well")) break block53;
                        this.parentQName = qName;
                        if (!qName.equals("Plate")) break block54;
                        ++this.nextPlate;
                        FlexReader.this.plateCount++;
                        break block35;
                    }
                    if (!qName.equals("Well")) break block35;
                    ++this.nextWell;
                    FlexReader.this.wellCount++;
                    break block35;
                }
                if (qName.equals("WellCoordinate")) {
                    int ndx = this.nextWell - 1;
                    FlexReader.this.addMeta("Well" + ndx + " Row", attributes.getValue("Row"));
                    FlexReader.this.addMeta("Well" + ndx + " Col", attributes.getValue("Col"));
                    this.store.setWellRow(new Integer(attributes.getValue("Row")), 0, ndx);
                    this.store.setWellColumn(new Integer(attributes.getValue("Col")), 0, ndx);
                } else if (qName.equals("Status")) {
                    FlexReader.this.addMeta("Status", attributes.getValue("StatusString"));
                } else if (qName.equals("ImageResolutionX")) {
                    this.parentQName = qName;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                    }
                } else if (qName.equals("ImageResolutionY")) {
                    this.parentQName = qName;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                    }
                } else if (qName.equals("FLIM")) {
                    this.parentQName = qName;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        FlexReader.this.addMeta("FLIM " + this.nextImage + " " + attributes.getQName(i), attributes.getValue(i));
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(this.parentQName)) {
                this.parentQName = "";
            }
        }
    }
}

