/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.meta.FilterMetadata;

public class BMPReader
extends FormatReader {
    private static final int RAW = 0;
    private static final int RLE_8 = 1;
    private static final int RLE_4 = 2;
    private static final int RGB_MASK = 3;
    private int offset;
    private int bpp;
    private byte[][] palette;
    private int compression;
    private long global;

    public BMPReader() {
        super("Windows Bitmap", "bmp");
        this.blockCheckLen = 2;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readString(this.blockCheckLen).startsWith("BM");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.palette;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        if (this.compression != 0) {
            throw new FormatException("Compression type " + this.compression + " not supported");
        }
        int rowsToSkip = this.getSizeY() - (h + y);
        int rowLength = this.getSizeX() * (this.isIndexed() ? 1 : this.getSizeC());
        this.in.seek(this.global + (long)(rowsToSkip * rowLength));
        int pad = rowLength * this.bpp / 8 % 2;
        pad = pad == 0 ? rowLength * this.bpp / 8 % 4 : (pad *= this.getSizeC());
        int planeSize = this.getSizeX() * this.getSizeC() * this.getSizeY();
        planeSize = this.bpp >= 8 ? (planeSize *= this.bpp / 8) : (planeSize /= 8 / this.bpp);
        if ((long)(planeSize += pad * this.getSizeY()) + this.in.getFilePointer() > this.in.length()) {
            planeSize -= pad * this.getSizeY();
            pad = 0;
        }
        byte[] rawPlane = new byte[planeSize];
        this.in.read(rawPlane);
        BitBuffer bb = new BitBuffer(rawPlane);
        if (this.palette != null && this.palette[0].length > 0 || this.getSizeC() == 1) {
            for (int row = h - 1; row >= 0; --row) {
                bb.skipBits(x * this.bpp);
                for (int i = 0; i < w; ++i) {
                    buf[row * w + i] = (byte)(bb.getBits(this.bpp) & 0xFF);
                }
                if (row <= 0) continue;
                bb.skipBits((this.getSizeX() - w - x) * this.bpp + pad * 8);
            }
        } else {
            int len = this.getSizeX() * this.getSizeC();
            for (int row = h - 1; row >= y; --row) {
                bb.skipBits(x * this.getSizeC() * this.bpp);
                for (int i = 0; i < w * this.getSizeC(); ++i) {
                    buf[row * w * this.getSizeC() + i] = (byte)(bb.getBits(this.bpp) & 0xFF);
                }
                bb.skipBits(this.getSizeC() * this.bpp * (this.getSizeX() - w - x));
                bb.skipBits(pad * 8);
            }
            for (int i = 0; i < buf.length / this.getSizeC(); ++i) {
                byte tmp = buf[i * this.getSizeC() + 2];
                buf[i * this.getSizeC() + 2] = buf[i * this.getSizeC()];
                buf[i * this.getSizeC()] = tmp;
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.compression = 0;
        this.bpp = 0;
        this.offset = 0;
        this.global = 0L;
        this.palette = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("BMPReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Reading bitmap header");
        this.in.order(true);
        this.addMeta("Magic identifier", this.in.readString(2));
        this.addMeta("File size (in bytes)", this.in.readInt());
        this.in.skipBytes(4);
        this.offset = this.in.readInt();
        this.in.skipBytes(4);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        if (this.getSizeX() < 1 || this.getSizeY() < 1) {
            throw new FormatException("Invalid image dimensions: " + this.getSizeX() + " x " + this.getSizeY());
        }
        this.addMeta("Image width", this.getSizeX());
        this.addMeta("Image height", this.getSizeY());
        this.addMeta("Color planes", this.in.readShort());
        this.bpp = this.in.readShort();
        this.addMeta("Bits per pixel", this.bpp);
        this.compression = this.in.readInt();
        String comp = "invalid";
        switch (this.compression) {
            case 0: {
                comp = "None";
                break;
            }
            case 1: {
                comp = "8 bit run length encoding";
                break;
            }
            case 2: {
                comp = "4 bit run length encoding";
                break;
            }
            case 3: {
                comp = "RGB bitmap with mask";
            }
        }
        this.addMeta("Compression type", comp);
        this.in.skipBytes(4);
        float pixelSizeX = this.in.readInt();
        float pixelSizeY = this.in.readInt();
        this.addMeta("X resolution", pixelSizeX);
        this.addMeta("Y resolution", pixelSizeY);
        int nColors = this.in.readInt();
        if (nColors == 0 && this.bpp != 32 && this.bpp != 24) {
            nColors = this.bpp < 8 ? 1 << this.bpp : 256;
        }
        this.in.skipBytes(4);
        if (nColors != 0 && this.bpp == 8) {
            this.palette = new byte[3][256];
            for (int i = 0; i < nColors; ++i) {
                for (int j = this.palette.length - 1; j >= 0; --j) {
                    this.palette[j][i] = this.in.readByte();
                }
                this.in.skipBytes(1);
            }
        } else if (nColors != 0) {
            this.in.skipBytes(nColors * 4);
        }
        this.global = this.in.getFilePointer();
        this.addMeta("Indexed color", this.palette != null);
        this.status("Populating metadata");
        int n = this.core[0].sizeC = this.bpp != 24 ? 1 : 3;
        if (this.bpp == 32) {
            this.core[0].sizeC = 4;
        }
        if (this.bpp > 8) {
            this.bpp /= this.getSizeC();
        }
        switch (this.bpp) {
            case 16: {
                this.core[0].pixelType = 3;
                break;
            }
            case 32: {
                this.core[0].pixelType = 5;
                break;
            }
            default: {
                this.core[0].pixelType = 1;
            }
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].littleEndian = true;
        this.core[0].interleaved = true;
        this.core[0].imageCount = 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].metadataComplete = true;
        boolean bl = this.core[0].indexed = this.palette != null;
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        this.core[0].falseColor = false;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        float correctedX = pixelSizeX == 0.0f ? 0.0f : 1000000.0f / pixelSizeX;
        float correctedY = pixelSizeY == 0.0f ? 0.0f : 1000000.0f / pixelSizeY;
        store.setDimensionsPhysicalSizeX(new Float(correctedX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(correctedY), 0, 0);
    }
}

