/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import loci.formats.AWTImageTools;

public class UnsignedIntColorModel
extends ColorModel {
    private int pixelBits;
    private int nChannels;
    private ComponentColorModel helper;

    public UnsignedIntColorModel(int pixelBits, int dataType, int nChannels) throws IOException {
        super(pixelBits, UnsignedIntColorModel.makeBitArray(nChannels, pixelBits), AWTImageTools.makeColorSpace(nChannels), nChannels == 4, false, 3, dataType);
        this.helper = new ComponentColorModel(AWTImageTools.makeColorSpace(nChannels), nChannels == 4, false, 3, dataType);
        this.pixelBits = pixelBits;
        this.nChannels = nChannels;
    }

    public synchronized Object getDataElements(int rgb, Object pixel) {
        return this.helper.getDataElements(rgb, pixel);
    }

    public boolean isCompatibleRaster(Raster raster) {
        return raster.getNumBands() == this.getNumComponents() && raster.getTransferType() == this.getTransferType();
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        return this.helper.createCompatibleWritableRaster(w, h);
    }

    public int getAlpha(int pixel) {
        return (int)(Math.pow(2.0, 32.0) - 1.0);
    }

    public int getBlue(int pixel) {
        return this.getComponent(pixel, 3);
    }

    public int getGreen(int pixel) {
        return this.getComponent(pixel, 2);
    }

    public int getRed(int pixel) {
        return this.getComponent(pixel, 1);
    }

    public int getAlpha(Object data) {
        int max = (int)Math.pow(2.0, 32.0) - 1;
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getAlpha(i[0]);
            }
            return this.getAlpha(i.length == 4 ? i[0] : max);
        }
        return max;
    }

    public int getRed(Object data) {
        int max = (int)Math.pow(2.0, 32.0) - 1;
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getRed(i[0]);
            }
            return this.getRed(i.length != 4 ? i[0] : i[1]);
        }
        return max;
    }

    public int getGreen(Object data) {
        int max = (int)Math.pow(2.0, 32.0) - 1;
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getGreen(i[0]);
            }
            return this.getGreen(i.length != 4 ? i[1] : i[2]);
        }
        return max;
    }

    public int getBlue(Object data) {
        int max = (int)Math.pow(2.0, 32.0) - 1;
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getBlue(i[0]);
            }
            return this.getBlue(i[i.length - 1]);
        }
        return max;
    }

    private int getComponent(int pixel, int index) {
        long v = (long)pixel & 0xFFFFFFFFL;
        if (this.nChannels == 1) {
            double f = (double)v / (Math.pow(2.0, 32.0) - 1.0);
            return (int)(255.0 * f);
        }
        int shift = (this.nChannels - index) * 8;
        return (int)(v & (long)(255 << shift)) >> shift;
    }

    private static int[] makeBitArray(int nChannels, int nBits) {
        int[] bits = new int[nChannels];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = nBits;
        }
        return bits;
    }
}

