/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.Index16ColorModel;
import loci.formats.SignedByteBuffer;
import loci.formats.SignedColorModel;
import loci.formats.TwoChannelColorSpace;
import loci.formats.UnsignedIntBuffer;
import loci.formats.UnsignedIntColorModel;

public final class AWTImageTools {
    protected static final Component OBS = new Container();

    private AWTImageTools() {
    }

    public static BufferedImage makeImage(byte[] data, int w, int h) {
        return AWTImageTools.makeImage(data, w, h, false);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, boolean signed) {
        return AWTImageTools.makeImage(new byte[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(short[] data, int w, int h) {
        return AWTImageTools.makeImage(data, w, h, false);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, boolean signed) {
        return AWTImageTools.makeImage(new short[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(int[] data, int w, int h) {
        return AWTImageTools.makeImage(data, w, h, true);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, boolean signed) {
        return AWTImageTools.makeImage(new int[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(float[] data, int w, int h) {
        return AWTImageTools.makeImage(new float[][]{data}, w, h);
    }

    public static BufferedImage makeImage(double[] data, int w, int h) {
        return AWTImageTools.makeImage(new double[][]{data}, w, h);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved) {
        return AWTImageTools.makeImage(data, w, h, c, interleaved, false);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h, signed);
        }
        if (c > 2) {
            return AWTImageTools.makeRGBImage(data, c, w, h, interleaved);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, c * w * h) : new DataBufferByte(data, c * w * h);
        return AWTImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int c, boolean interleaved) {
        return AWTImageTools.makeImage(data, w, h, c, interleaved, false);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h, signed);
        }
        if (signed) {
            dataType = 2;
            buffer = new DataBufferShort(data, c * w * h);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, c * w * h);
        }
        return AWTImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int c, boolean interleaved) {
        return AWTImageTools.makeImage(data, w, h, c, interleaved, true);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h, signed);
        }
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, c * w * h) : new UnsignedIntBuffer(data, c * w * h);
        return AWTImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(float[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h);
        }
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, c * w * h);
        return AWTImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(double[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h);
        }
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, c * w * h);
        return AWTImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h) {
        return AWTImageTools.makeImage(data, w, h, false);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, boolean signed) {
        if (data.length > 2) {
            return AWTImageTools.makeRGBImage(data, w, h);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, data[0].length) : new DataBufferByte(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h) {
        return AWTImageTools.makeImage(data, w, h, false);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (signed) {
            dataType = 2;
            buffer = new DataBufferShort(data, data[0].length);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, data[0].length);
        }
        return AWTImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h) {
        return AWTImageTools.makeImage(data, w, h, true);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h, boolean signed) {
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, data[0].length) : new UnsignedIntBuffer(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h) {
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h) {
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bpp, boolean little) {
        return AWTImageTools.makeImage(data, w, h, c, interleaved, bpp, false, little, bpp >= 4);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bpp, boolean fp, boolean little, boolean signed) {
        Object pixels = DataTools.makeDataArray(data, bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
        if (pixels instanceof byte[]) {
            return AWTImageTools.makeImage((byte[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof short[]) {
            return AWTImageTools.makeImage((short[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof int[]) {
            return AWTImageTools.makeImage((int[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof float[]) {
            return AWTImageTools.makeImage((float[])pixels, w, h, c, interleaved);
        }
        if (pixels instanceof double[]) {
            return AWTImageTools.makeImage((double[])pixels, w, h, c, interleaved);
        }
        return null;
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bpp, boolean little) {
        return AWTImageTools.makeImage(data, w, h, bpp, false, little, false);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bpp, boolean fp, boolean little, boolean signed) {
        int c = data.length;
        Object v = null;
        for (int i = 0; i < c; ++i) {
            Object pixels = DataTools.makeDataArray(data[i], bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
            if (pixels instanceof byte[]) {
                if (v == null) {
                    v = new byte[c][];
                }
                ((byte[][])v)[i] = (byte[])pixels;
                continue;
            }
            if (pixels instanceof short[]) {
                if (v == null) {
                    v = new short[c][];
                }
                ((short[][])v)[i] = (short[])pixels;
                continue;
            }
            if (pixels instanceof int[]) {
                if (v == null) {
                    v = new int[c][];
                }
                ((int[][])v)[i] = (int[])pixels;
                continue;
            }
            if (pixels instanceof float[]) {
                if (v == null) {
                    v = new float[c][];
                }
                ((float[][])v)[i] = (float[])pixels;
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            if (v == null) {
                v = new double[c][];
            }
            ((double[][])v)[i] = (double[])pixels;
        }
        if (v instanceof byte[][]) {
            return AWTImageTools.makeImage(v, w, h, signed);
        }
        if (v instanceof short[][]) {
            return AWTImageTools.makeImage((short[][])v, w, h, signed);
        }
        if (v instanceof int[][]) {
            return AWTImageTools.makeImage((int[][])v, w, h, signed);
        }
        if (v instanceof float[][]) {
            return AWTImageTools.makeImage((float[][])v, w, h);
        }
        if (v instanceof double[][]) {
            return AWTImageTools.makeImage((double[][])v, w, h);
        }
        return null;
    }

    public static BufferedImage makeRGBImage(byte[] data, int c, int w, int h, boolean interleaved) {
        int[] buf = new int[data.length / c];
        int nBits = (c - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < c; ++q) {
                if (interleaved) {
                    int n = i;
                    buf[n] = buf[n] | (data[i * c + q] & 0xFF) << nBits - q * 8;
                    continue;
                }
                int n = i;
                buf[n] = buf[n] | (data[q * buf.length + i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(c, 3, w, h, false, false, buffer);
    }

    public static BufferedImage makeRGBImage(byte[][] data, int w, int h) {
        int[] buf = new int[data[0].length];
        int nBits = (data.length - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < data.length; ++q) {
                int n = i;
                buf[n] = buf[n] | (data[q][i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(data.length, 3, w, h, false, false, buffer);
    }

    public static BufferedImage blankImage(int w, int h, int c, int type) {
        switch (type) {
            case 0: {
                return AWTImageTools.makeImage(new byte[c][w * h], w, h, true);
            }
            case 1: {
                return AWTImageTools.makeImage(new byte[c][w * h], w, h, false);
            }
            case 2: {
                return AWTImageTools.makeImage(new short[c][w * h], w, h, true);
            }
            case 3: {
                return AWTImageTools.makeImage(new short[c][w * h], w, h, false);
            }
            case 4: {
                return AWTImageTools.makeImage(new int[c][w * h], w, h, true);
            }
            case 5: {
                return AWTImageTools.makeImage(new int[c][w * h], w, h, false);
            }
            case 6: {
                return AWTImageTools.makeImage(new float[c][w * h], w, h);
            }
            case 7: {
                return AWTImageTools.makeImage(new double[c][w * h], w, h);
            }
        }
        return null;
    }

    public static BufferedImage constructImage(int c, int type, int w, int h, boolean interleaved, boolean banded, DataBuffer buffer) {
        int[] bandOffsets;
        SampleModel model;
        int i;
        ColorModel colorModel = AWTImageTools.makeColorModel(c, type);
        if (colorModel == null) {
            return null;
        }
        if (buffer instanceof UnsignedIntBuffer) {
            try {
                colorModel = new UnsignedIntColorModel(32, type, c);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (c > 2 && type == 3 && buffer.getNumBanks() == 1) {
            int[] bitMasks = new int[c];
            for (i = 0; i < c; ++i) {
                bitMasks[i] = 255 << (c - i - 1) * 8;
            }
            model = new SinglePixelPackedSampleModel(3, w, h, bitMasks);
        } else if (banded) {
            model = new BandedSampleModel(type, w, h, c);
        } else if (interleaved) {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i;
            }
            model = new PixelInterleavedSampleModel(type, w, h, c, c * w, bandOffsets);
        } else {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i * w * h;
            }
            model = new ComponentSampleModel(type, w, h, 1, w, bandOffsets);
        }
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        BufferedImage b = null;
        if (c == 1 && type == 0 && !(buffer instanceof SignedByteBuffer)) {
            b = colorModel instanceof IndexColorModel ? new BufferedImage(w, h, 13) : new BufferedImage(w, h, 10);
            b.setData(raster);
        } else if (c == 1 && type == 1) {
            if (!(colorModel instanceof IndexColorModel)) {
                b = new BufferedImage(w, h, 11);
                b.setData(raster);
            }
        } else if (c > 2 && type == 3 && buffer.getNumBanks() == 1) {
            if (c == 3) {
                b = new BufferedImage(w, h, 1);
            } else if (c == 4) {
                b = new BufferedImage(w, h, 2);
            }
            if (b != null) {
                b.setData(raster);
            }
        }
        if (b == null) {
            b = new BufferedImage(colorModel, raster, false, null);
        }
        return b;
    }

    public static BufferedImage openImage(byte[] buf, IFormatReader r, int w, int h) throws FormatException, IOException {
        int pixelType = r.getPixelType();
        boolean little = r.isLittleEndian();
        boolean normal = r.isNormalized();
        int rgbChanCount = r.getRGBChannelCount();
        boolean interleaved = r.isInterleaved();
        boolean indexed = r.isIndexed();
        if (pixelType == 6) {
            float[] f = (float[])DataTools.makeDataArray(buf, 4, true, little);
            if (normal) {
                f = DataTools.normalizeFloats(f);
            }
            return AWTImageTools.makeImage(f, w, h, rgbChanCount, interleaved);
        }
        if (pixelType == 7) {
            double[] d = (double[])DataTools.makeDataArray(buf, 8, true, little);
            if (normal) {
                d = DataTools.normalizeDoubles(d);
            }
            return AWTImageTools.makeImage(d, w, h, rgbChanCount, interleaved);
        }
        boolean signed = FormatTools.isSigned(pixelType);
        ColorModel model = null;
        if (signed) {
            if (pixelType == 0) {
                model = new SignedColorModel(8, 0, rgbChanCount);
            } else if (pixelType == 2) {
                model = new SignedColorModel(16, 2, rgbChanCount);
            } else if (pixelType == 4) {
                model = new SignedColorModel(32, 3, rgbChanCount);
            }
        }
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        BufferedImage b = AWTImageTools.makeImage(buf, w, h, indexed ? 1 : rgbChanCount, interleaved, bpp, false, little, signed);
        if (indexed) {
            Object table;
            if (pixelType == 1 || pixelType == 0) {
                table = r.get8BitLookupTable();
                if (table != null) {
                    model = new IndexColorModel(8, table[0].length, table[0], table[1], table[2]);
                }
            } else if ((pixelType == 3 || pixelType == 2) && (table = (Object)r.get16BitLookupTable()) != null) {
                model = new Index16ColorModel(16, table[0].length, (short[][])table, r.isLittleEndian());
            }
        }
        if (model != null) {
            WritableRaster raster = Raster.createWritableRaster(b.getSampleModel(), b.getRaster().getDataBuffer(), null);
            b = new BufferedImage(model, raster, false, null);
        }
        return b;
    }

    public static Object getPixels(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        int tt = raster.getTransferType();
        if (tt == 0) {
            return AWTImageTools.getBytes(image);
        }
        if (tt == 1 || tt == 2) {
            return AWTImageTools.getShorts(image);
        }
        if (tt == 3) {
            return AWTImageTools.getInts(image);
        }
        if (tt == 4) {
            return AWTImageTools.getFloats(image);
        }
        if (tt == 5) {
            return AWTImageTools.getDoubles(image);
        }
        return null;
    }

    public static byte[][] getBytes(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (AWTImageTools.canUseBankDataDirectly(image, 1, 0, DataBufferByte.class)) {
            return ((DataBufferByte)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        byte[][] samples = new byte[c][w * h];
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (byte)buf[j];
            }
        }
        return samples;
    }

    public static short[][] getShorts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (AWTImageTools.canUseBankDataDirectly(image, 2, 1, DataBufferUShort.class)) {
            return ((DataBufferUShort)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        short[][] samples = new short[c][w * h];
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (short)buf[j];
            }
        }
        return samples;
    }

    public static int[][] getInts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (AWTImageTools.canUseBankDataDirectly(image, 4, 3, DataBufferInt.class)) {
            return ((DataBufferInt)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        int[][] samples = new int[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, samples[i]);
        }
        return samples;
    }

    public static float[][] getFloats(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (AWTImageTools.canUseBankDataDirectly(image, 4, 4, DataBufferFloat.class)) {
            return ((DataBufferFloat)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        float[][] samples = new float[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, samples[i]);
        }
        return samples;
    }

    public static double[][] getDoubles(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (AWTImageTools.canUseBankDataDirectly(image, 8, 5, DataBufferDouble.class)) {
            return ((DataBufferDouble)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        double[][] samples = new double[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, samples[i]);
        }
        return samples;
    }

    private static boolean canUseBankDataDirectly(BufferedImage image, int bytesPerPixel, int transferType, Class dataBufferClass) {
        int i;
        WritableRaster r = image.getRaster();
        int tt = r.getTransferType();
        if (tt != transferType) {
            return false;
        }
        DataBuffer buffer = r.getDataBuffer();
        if (!dataBufferClass.isInstance(buffer)) {
            return false;
        }
        SampleModel model = r.getSampleModel();
        if (!(model instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)model;
        int pixelStride = csm.getPixelStride();
        if (pixelStride != 1) {
            return false;
        }
        int w = r.getWidth();
        int scanlineStride = csm.getScanlineStride();
        if (scanlineStride != w) {
            return false;
        }
        int c = r.getNumBands();
        int[] bandOffsets = csm.getBandOffsets();
        if (bandOffsets.length != c) {
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == 0) continue;
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == i) continue;
            return false;
        }
        return true;
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little) {
        Object pixels = AWTImageTools.getPixels(img);
        int imageType = img.getType();
        if (pixels instanceof byte[][]) {
            return (byte[][])pixels;
        }
        if (pixels instanceof short[][]) {
            short[][] s = (short[][])pixels;
            byte[][] b = new byte[s.length][s[0].length * 2];
            for (int i = 0; i < b.length; ++i) {
                for (int j = 0; j < s[0].length; ++j) {
                    DataTools.unpackShort(s[i][j], b[i], j * 2, little);
                }
            }
            return b;
        }
        if (pixels instanceof int[][]) {
            byte[][] b = null;
            int[][] in = (int[][])pixels;
            if (imageType == 1 || imageType == 4 || imageType == 2) {
                b = new byte[in.length][in[0].length];
                for (int c = 0; c < in.length; ++c) {
                    for (int i = 0; i < in[0].length; ++i) {
                        if (imageType != 4) {
                            b[c][i] = (byte)(in[c][i] & 0xFF);
                            continue;
                        }
                        b[in.length - c - 1][i] = (byte)(in[c][i] & 0xFF);
                    }
                }
            } else {
                b = new byte[in.length][in[0].length * 4];
                for (int i = 0; i < b.length; ++i) {
                    for (int j = 0; j < in[0].length; ++j) {
                        DataTools.unpackBytes(in[i][j], b[i], j * 4, 4, little);
                    }
                }
            }
            return b;
        }
        if (pixels instanceof float[][]) {
            float[][] in = (float[][])pixels;
            byte[][] b = new byte[in.length][in[0].length * 4];
            for (int i = 0; i < b.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    int v = Float.floatToIntBits(in[i][j]);
                    DataTools.unpackBytes(v, b[i], j * 4, 4, little);
                }
            }
            return b;
        }
        if (pixels instanceof double[][]) {
            double[][] in = (double[][])pixels;
            byte[][] b = new byte[in.length][in[0].length * 8];
            for (int i = 0; i < b.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    DataTools.unpackBytes(v, b[i], j * 8, 8, little);
                }
            }
            return b;
        }
        return null;
    }

    public static int getPixelType(BufferedImage image) {
        DataBuffer buffer = image.getRaster().getDataBuffer();
        int type = buffer.getDataType();
        int imageType = image.getType();
        switch (type) {
            case 0: {
                return 1;
            }
            case 5: {
                return 7;
            }
            case 4: {
                return 6;
            }
            case 3: {
                if (imageType == 1 || imageType == 4 || imageType == 2) {
                    return 1;
                }
                if (buffer instanceof UnsignedIntBuffer) {
                    return 5;
                }
                return 4;
            }
            case 2: {
                return 2;
            }
            case 1: {
                if (imageType == 9 || imageType == 8) {
                    return 1;
                }
                return 3;
            }
        }
        return -1;
    }

    public static byte[] getBytes(BufferedImage img, boolean separated) {
        byte[][] p = AWTImageTools.getBytes(img);
        if (separated || p.length == 1) {
            return p[0];
        }
        byte[] rtn = new byte[p.length * p[0].length];
        for (int i = 0; i < p.length; ++i) {
            System.arraycopy(p[i], 0, rtn, i * p[0].length, p[i].length);
        }
        return rtn;
    }

    public static BufferedImage[] splitChannels(BufferedImage image) {
        BufferedImage[] results;
        block7: {
            Object o;
            int c;
            int h;
            int w;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            w = image.getWidth();
                            h = image.getHeight();
                            c = image.getRaster().getNumBands();
                            if (c == 1) {
                                return new BufferedImage[]{image};
                            }
                            results = new BufferedImage[c];
                            o = AWTImageTools.getPixels(image);
                            if (!(o instanceof byte[][])) break block6;
                            byte[][] pix = (byte[][])o;
                            for (int i = 0; i < c; ++i) {
                                results[i] = AWTImageTools.makeImage(pix[i], w, h);
                            }
                            break block7;
                        }
                        if (!(o instanceof short[][])) break block8;
                        short[][] pix = (short[][])o;
                        for (int i = 0; i < c; ++i) {
                            results[i] = AWTImageTools.makeImage(pix[i], w, h);
                        }
                        break block7;
                    }
                    if (!(o instanceof int[][])) break block9;
                    int[][] pix = (int[][])o;
                    for (int i = 0; i < c; ++i) {
                        results[i] = AWTImageTools.makeImage(pix[i], w, h);
                    }
                    break block7;
                }
                if (!(o instanceof float[][])) break block10;
                float[][] pix = (float[][])o;
                for (int i = 0; i < c; ++i) {
                    results[i] = AWTImageTools.makeImage(pix[i], w, h);
                }
                break block7;
            }
            if (!(o instanceof double[][])) break block7;
            double[][] pix = (double[][])o;
            for (int i = 0; i < c; ++i) {
                results[i] = AWTImageTools.makeImage(pix[i], w, h);
            }
        }
        return results;
    }

    public static BufferedImage mergeChannels(BufferedImage[] images) {
        if (images == null || images.length == 0) {
            return null;
        }
        Object[] list = new Object[images.length];
        int c = 0;
        int type = 0;
        for (int i = 0; i < images.length; ++i) {
            Object o = AWTImageTools.getPixels(images[i]);
            if (o instanceof byte[][]) {
                if (i == 0) {
                    type = 0;
                } else if (type != 0) {
                    return null;
                }
                c += ((byte[][])o).length;
            } else if (o instanceof short[][]) {
                if (i == 0) {
                    type = 1;
                } else if (type != 1) {
                    return null;
                }
                c += ((short[][])o).length;
            } else if (o instanceof int[][]) {
                if (i == 0) {
                    type = 3;
                } else if (type != 3) {
                    return null;
                }
                c += ((int[][])o).length;
            } else if (o instanceof float[][]) {
                if (i == 0) {
                    type = 4;
                } else if (type != 4) {
                    return null;
                }
                c += ((float[][])o).length;
            } else if (o instanceof double[][]) {
                if (i == 0) {
                    type = 5;
                } else if (type != 5) {
                    return null;
                }
                c += ((double[][])o).length;
            }
            if (c > 4) {
                return null;
            }
            list[i] = o;
        }
        if (c < 1 || c > 4) {
            return null;
        }
        int w = images[0].getWidth();
        int h = images[0].getHeight();
        if (type == 0) {
            byte[][] pix = new byte[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                byte[][] b = (byte[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new byte[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h);
        }
        if (type == 1) {
            short[][] pix = new short[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                short[][] b = (short[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new short[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h);
        }
        if (type == 3) {
            int[][] pix = new int[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                int[][] b = (int[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new int[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h);
        }
        if (type == 4) {
            float[][] pix = new float[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                float[][] b = (float[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new float[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h);
        }
        if (type == 5) {
            double[][] pix = new double[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                double[][] b = (double[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new double[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h);
        }
        return null;
    }

    public static BufferedImage padImage(BufferedImage img, int width, int height) {
        boolean needsPadding;
        if (img == null) {
            byte[][] data = new byte[1][width * height];
            return AWTImageTools.makeImage(data, width, height);
        }
        boolean bl = needsPadding = img.getWidth() != width || img.getHeight() != height;
        if (needsPadding) {
            Object pixels = AWTImageTools.getPixels(img);
            if (pixels instanceof byte[][]) {
                byte[][] b = (byte[][])pixels;
                byte[][] newBytes = new byte[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newBytes[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newBytes, width, height);
            }
            if (pixels instanceof short[][]) {
                short[][] b = (short[][])pixels;
                short[][] newShorts = new short[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newShorts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newShorts, width, height);
            }
            if (pixels instanceof int[][]) {
                int[][] b = (int[][])pixels;
                int[][] newInts = new int[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newInts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newInts, width, height);
            }
            if (pixels instanceof float[][]) {
                float[][] b = (float[][])pixels;
                float[][] newFloats = new float[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newFloats[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newFloats, width, height);
            }
            if (pixels instanceof double[][]) {
                double[][] b = (double[][])pixels;
                double[][] newDoubles = new double[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newDoubles[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newDoubles, width, height);
            }
            return null;
        }
        return img;
    }

    public static BufferedImage autoscale(BufferedImage img) {
        byte[][] pixels = AWTImageTools.getPixelBytes(img, true);
        double min = Double.MAX_VALUE;
        double max = 0.0;
        int bits = pixels[0].length / (img.getWidth() * img.getHeight()) * 8;
        for (int i = 0; i < pixels.length; ++i) {
            Double[] mm = ImageTools.scanData(pixels[0], bits, true);
            double tmin = mm[0];
            double tmax = mm[1];
            if (tmin < min) {
                min = tmin;
            }
            if (!(tmax > max)) continue;
            max = tmax;
        }
        return AWTImageTools.autoscale(img, (int)min, (int)max);
    }

    public static BufferedImage autoscale(BufferedImage img, int min, int max) {
        Object pixels = AWTImageTools.getPixels(img);
        if (pixels instanceof byte[][]) {
            return img;
        }
        if (pixels instanceof short[][]) {
            short[][] shorts = (short[][])pixels;
            byte[][] out = new byte[shorts.length][shorts[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (shorts[i][j] < 0) {
                        short[] sArray = shorts[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] + Short.MAX_VALUE);
                    }
                    float diff = (float)max - (float)min;
                    float dist = (float)(shorts[i][j] - min) / diff;
                    out[i][j] = shorts[i][j] >= max ? -1 : (shorts[i][j] <= min ? 0 : (int)((int)(dist * 256.0f)));
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof int[][]) {
            int[][] ints = (int[][])pixels;
            byte[][] out = new byte[ints.length][ints[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (ints[i][j] >= max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (ints[i][j] <= min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (ints[i][j] - min) / diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof float[][]) {
            float[][] floats = (float[][])pixels;
            byte[][] out = new byte[floats.length][floats[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (floats[i][j] >= (float)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (floats[i][j] <= (float)min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (floats[i][j] - (float)min) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof double[][]) {
            double[][] doubles = (double[][])pixels;
            byte[][] out = new byte[doubles.length][doubles[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (doubles[i][j] >= (double)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (doubles[i][j] <= (double)min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (float)(doubles[i][j] - (double)min) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        return img;
    }

    public static BufferedImage copyScaled(BufferedImage source, BufferedImage target, Object hint) {
        if (hint == null) {
            hint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        Graphics2D g2 = target.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        double scalex = (double)target.getWidth() / (double)source.getWidth();
        double scaley = (double)target.getHeight() / (double)source.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
        g2.drawRenderedImage(source, xform);
        g2.dispose();
        return target;
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = AWTImageTools.getDefaultConfiguration();
        }
        int trans = image.getColorModel().getTransparency();
        return AWTImageTools.copyScaled(image, gc.createCompatibleImage(width, height, trans), hint);
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, ColorModel cm) {
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
        return AWTImageTools.copyScaled(image, new BufferedImage(cm, raster, isRasterPremultiplied, null), hint);
    }

    public static Image scaleAWT(BufferedImage source, int width, int height, int hint) {
        return source.getScaledInstance(width, height, hint);
    }

    public static BufferedImage scale(BufferedImage source, int width, int height, boolean pad) {
        int w = source.getWidth();
        int h = source.getHeight();
        if (w == width && h == height) {
            return source;
        }
        int finalWidth = width;
        int finalHeight = height;
        if (pad) {
            double r = (double)w / (double)h;
            double ratio = (double)width / (double)height;
            if (r > ratio) {
                height = h * width / w;
            } else {
                width = w * height / h;
            }
        }
        BufferedImage result = null;
        ColorModel sourceModel = source.getColorModel();
        if (sourceModel instanceof Index16ColorModel || sourceModel instanceof IndexColorModel || sourceModel instanceof SignedColorModel) {
            DataBuffer buffer = source.getData().getDataBuffer();
            WritableRaster raster = Raster.createWritableRaster(source.getSampleModel(), buffer, null);
            ColorModel model = AWTImageTools.makeColorModel(1, buffer.getDataType());
            if (sourceModel instanceof SignedColorModel) {
                model = sourceModel;
            }
            source = new BufferedImage(model, raster, false, null);
            Image scaled = AWTImageTools.scaleAWT(source, width, height, 16);
            result = AWTImageTools.makeBuffered(scaled, sourceModel);
            raster = Raster.createWritableRaster(result.getSampleModel(), result.getData().getDataBuffer(), null);
            result = new BufferedImage(sourceModel, raster, false, null);
        } else {
            Image scaled = AWTImageTools.scaleAWT(source, width, height, 16);
            result = AWTImageTools.makeBuffered(scaled, sourceModel);
        }
        return AWTImageTools.padImage(result, finalWidth, finalHeight);
    }

    public static BufferedImage makeBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        AWTImageTools.loadImage(image);
        BufferedImage img = new BufferedImage(image.getWidth(OBS), image.getHeight(OBS), 1);
        Graphics g = img.getGraphics();
        g.drawImage(image, 0, 0, OBS);
        g.dispose();
        return img;
    }

    public static BufferedImage makeBuffered(Image image, ColorModel cm) {
        BufferedImage bi;
        if (cm == null) {
            return AWTImageTools.makeBuffered(image);
        }
        if (image instanceof BufferedImage && cm.equals((bi = (BufferedImage)image).getColorModel())) {
            return bi;
        }
        AWTImageTools.loadImage(image);
        int w = image.getWidth(OBS);
        int h = image.getHeight(OBS);
        boolean alphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
        BufferedImage result = new BufferedImage(cm, raster, alphaPremultiplied, null);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, OBS);
        g.dispose();
        return result;
    }

    public static boolean loadImage(Image image) {
        if (image instanceof BufferedImage) {
            return true;
        }
        MediaTracker tracker = new MediaTracker(OBS);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException exc) {
            return false;
        }
        return 8 == tracker.statusID(0, false);
    }

    public static Dimension getSize(Image image) {
        if (image == null) {
            return new Dimension(0, 0);
        }
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            return new Dimension(bi.getWidth(), bi.getHeight());
        }
        AWTImageTools.loadImage(image);
        return new Dimension(image.getWidth(OBS), image.getHeight(OBS));
    }

    public static BufferedImage makeCompatible(BufferedImage image, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = AWTImageTools.getDefaultConfiguration();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int trans = image.getColorModel().getTransparency();
        BufferedImage result = gc.createCompatibleImage(w, h, trans);
        Graphics2D g2 = result.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static ColorSpace makeColorSpace(int c) {
        int type;
        switch (c) {
            case 1: {
                type = 1003;
                break;
            }
            case 2: {
                type = -1;
                break;
            }
            case 3: {
                type = 1000;
                break;
            }
            case 4: {
                type = 1000;
                break;
            }
            default: {
                return null;
            }
        }
        return TwoChannelColorSpace.getInstance(type);
    }

    public static ColorModel makeColorModel(int c, int dataType) {
        return new ComponentColorModel(AWTImageTools.makeColorSpace(c), c == 4, false, 3, dataType);
    }

    public static BufferedImage indexedToRGB(BufferedImage img, boolean le) {
        byte[][] indices = AWTImageTools.getPixelBytes(img, le);
        if (indices.length > 1) {
            return img;
        }
        if (AWTImageTools.getPixelType(img) == 1) {
            IndexColorModel model = (IndexColorModel)img.getColorModel();
            byte[][] b = new byte[3][indices[0].length];
            for (int i = 0; i < indices[0].length; ++i) {
                b[0][i] = (byte)(model.getRed(indices[0][i] & 0xFF) & 0xFF);
                b[1][i] = (byte)(model.getGreen(indices[0][i] & 0xFF) & 0xFF);
                b[2][i] = (byte)(model.getBlue(indices[0][i] & 0xFF) & 0xFF);
            }
            return AWTImageTools.makeImage(b, img.getWidth(), img.getHeight());
        }
        if (AWTImageTools.getPixelType(img) == 3) {
            Index16ColorModel model = (Index16ColorModel)img.getColorModel();
            short[][] s = new short[3][indices[0].length / 2];
            for (int i = 0; i < s[0].length; ++i) {
                int ndx = DataTools.bytesToInt(indices[0], i * 2, 2, le) & 0xFFFF;
                s[0][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s[1][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s[2][i] = (short)(model.getRed(ndx) & 0xFFFF);
            }
            return AWTImageTools.makeImage(s, img.getWidth(), img.getHeight());
        }
        return null;
    }
}

