/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import loci.common.CBZip2InputStream;
import loci.common.CompressedRandomAccess;

public class BZip2Handle
extends CompressedRandomAccess {
    public BZip2Handle(String file2) throws IOException {
        int skip;
        this.file = file2;
        if (!BZip2Handle.isBZip2File(file2)) {
            throw new IOException(file2 + " is not a BZip2 file.");
        }
        this.resetStream();
        this.length = 0L;
        while ((skip = this.stream.skipBytes(1024)) > 0) {
            this.length += (long)skip;
        }
        this.resetStream();
    }

    public static boolean isBZip2File(String file2) {
        return file2.toLowerCase().endsWith(".bz2");
    }

    public void seek(long pos) throws IOException {
        long oldFP = this.fp;
        this.fp = pos;
        if (this.fp > oldFP) {
            long diff = this.fp - oldFP;
            this.stream.skipBytes((int)diff);
        } else if (this.fp < oldFP) {
            this.stream.close();
            this.resetStream();
            this.stream.skipBytes((int)this.fp);
        }
    }

    private void resetStream() throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
        bis.skip(2L);
        this.stream = new DataInputStream(new CBZip2InputStream(bis));
    }
}

