/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat;
import com.sun.media.imageioimpl.plugins.jpeg2000.MediaLibAccessor;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Encoder;
import com.sun.medialib.codec.jp2k.Params;
import com.sun.medialib.codec.jp2k.Size;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NodeList;

public class J2KImageWriterCodecLib
extends ImageWriter {
    public static String WRITE_ABORTED = "Write aborted.";
    private ImageOutputStream stream = null;
    private J2KMetadataFormat format;
    private Encoder encoder;
    private Size size;
    private int tileWidth;
    private int tileHeight;
    private int tileXOffset;
    private int tileYOffset;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] sourceBands = null;
    private int numComp;
    private RenderedImage input;
    private J2KImageWriteParam param;
    private Raster inputRaster;
    private Rectangle destinationRegion = null;
    private SampleModel sampleModel;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private boolean writeRaster = false;

    public J2KImageWriterCodecLib(ImageWriterSpi originator) {
        super(originator);
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("J2KImageWriter0"));
            }
            this.stream = (ImageOutputStream)output;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new J2KImageWriteParam();
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("J2KImageWriterMedialib1"));
        }
        if (image == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriterMedialib2"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        this.encoder = new Encoder(this.stream);
        this.writeRaster = image.hasRaster();
        ColorModel colorModel = null;
        if (this.writeRaster) {
            this.inputRaster = image.getRaster();
            this.sampleModel = this.inputRaster.getSampleModel();
        } else {
            this.input = image.getRenderedImage();
            this.sampleModel = this.input.getSampleModel();
            colorModel = this.input.getColorModel();
        }
        if (param == null) {
            param = new J2KImageWriteParam();
        }
        if (param instanceof J2KImageWriteParam) {
            J2KImageWriteParam j2kParam = (J2KImageWriteParam)param;
            if (!this.writeRaster && this.input.getColorModel() instanceof IndexColorModel) {
                j2kParam.setLossless(true);
                j2kParam.setEncodingRate(Double.MAX_VALUE);
                j2kParam.setFilter("w5x3");
            } else if (j2kParam.getEncodingRate() == Double.MAX_VALUE) {
                j2kParam.setLossless(true);
                j2kParam.setFilter("w5x3");
            }
        }
        this.setParameters(param);
        Rectangle sourceRegion = param.getSourceRegion();
        sourceRegion = sourceRegion == null ? (this.writeRaster ? this.inputRaster.getBounds() : new Rectangle(this.input.getMinX(), this.input.getMinY(), this.input.getWidth(), this.input.getHeight())) : (this.writeRaster ? sourceRegion.intersection(this.inputRaster.getBounds()) : sourceRegion.intersection(new Rectangle(this.input.getMinX(), this.input.getMinY(), this.input.getWidth(), this.input.getHeight())));
        if (sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        try {
            this.tileWidth = param.getTileWidth();
            this.tileHeight = param.getTileHeight();
            this.tileXOffset = param.getTileGridXOffset();
            this.tileYOffset = param.getTileGridYOffset();
        }
        catch (IllegalStateException e) {
            param.setTilingMode(2);
            if (this.writeRaster) {
                param.setTiling(this.inputRaster.getWidth(), this.inputRaster.getHeight(), this.inputRaster.getMinX(), this.inputRaster.getMinY());
            } else {
                param.setTiling(this.input.getTileWidth(), this.input.getTileHeight(), this.input.getTileGridXOffset(), this.input.getTileGridYOffset());
            }
            this.tileWidth = param.getTileWidth();
            this.tileHeight = param.getTileHeight();
            this.tileXOffset = param.getTileGridXOffset();
            this.tileYOffset = param.getTileGridYOffset();
        }
        this.scaleX = param.getSourceXSubsampling();
        this.scaleY = param.getSourceYSubsampling();
        this.xOffset = param.getSubsamplingXOffset();
        this.yOffset = param.getSubsamplingYOffset();
        sourceRegion.translate(this.xOffset, this.yOffset);
        sourceRegion.width -= this.xOffset;
        sourceRegion.height -= this.yOffset;
        this.xOffset = sourceRegion.x % this.scaleX;
        this.yOffset = sourceRegion.y % this.scaleY;
        int minX = sourceRegion.x / this.scaleX;
        int minY = sourceRegion.y / this.scaleY;
        int w = (sourceRegion.width + this.scaleX - 1) / this.scaleX;
        int h = (sourceRegion.height + this.scaleY - 1) / this.scaleY;
        this.tileXOffset += (minX - this.tileXOffset) / this.tileWidth * this.tileWidth;
        this.tileYOffset += (minY - this.tileYOffset) / this.tileHeight * this.tileHeight;
        this.destinationRegion = new Rectangle(minX, minY, w, h);
        if (!this.destinationRegion.equals(sourceRegion) || this.tileWidth != this.sampleModel.getWidth() || this.tileHeight != this.sampleModel.getHeight() || !this.writeRaster && (this.tileXOffset != this.input.getTileGridXOffset() || this.tileYOffset != this.input.getTileGridYOffset()) || this.writeRaster && (this.tileXOffset != this.inputRaster.getMinX() || this.tileYOffset != this.inputRaster.getMinY())) {
            this.noTransform = false;
        }
        this.numComp = this.sampleModel.getNumBands();
        this.sourceBands = param.getSourceBands();
        if (this.sourceBands != null) {
            this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
            colorModel = null;
            this.noSubband = false;
        } else {
            this.sourceBands = new int[this.numComp];
            for (int i = 0; i < this.numComp; ++i) {
                this.sourceBands[i] = i;
            }
        }
        this.numComp = this.sourceBands.length;
        this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.setSize();
        this.setCompParameters(colorModel, this.sampleModel, param);
        this.encoder.setMode(2);
        if (!((J2KImageWriteParam)param).getWriteCodeStreamOnly()) {
            IIOMetadata inMetadata = image.getMetadata();
            J2KMetadata metadata1 = new J2KMetadata(colorModel, this.sampleModel, this.destinationRegion.width, this.destinationRegion.height, param, this);
            J2KMetadata metadata = null;
            if (inMetadata == null) {
                metadata = metadata1;
            } else {
                if (colorModel != null) {
                    ImageTypeSpecifier imageType = new ImageTypeSpecifier(colorModel, this.sampleModel);
                    metadata = (J2KMetadata)this.convertImageMetadata(inMetadata, imageType, param);
                } else {
                    String metaFormat = null;
                    List<String> metaFormats = Arrays.asList(inMetadata.getMetadataFormatNames());
                    if (metaFormats.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                        metaFormat = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
                    } else if (inMetadata.isStandardMetadataFormatSupported()) {
                        metaFormat = "javax_imageio_1.0";
                    }
                    metadata = new J2KMetadata();
                    if (metaFormat != null) {
                        metadata.setFromTree(metaFormat, inMetadata.getAsTree(metaFormat));
                    }
                }
                metadata.mergeTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0", metadata1.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0"));
            }
            this.writeMetadata(metadata);
        } else {
            this.encoder.setEncodeCodeStreamOnly();
        }
        for (int y = this.getMinTileY(); y <= this.getMaxTileY(); ++y) {
            for (int x = this.getMinTileX(); x <= this.getMaxTileX(); ++x) {
                Raster currentTile = this.getTile(x, y);
                int sourceFormatTag = MediaLibAccessor.findCompatibleTag(currentTile);
                MediaLibAccessor accessor = new MediaLibAccessor(currentTile, currentTile.getBounds(), sourceFormatTag, true);
                mediaLibImage[] mlImage = accessor.getMediaLibImages();
                this.encoder.encode(mlImage, x + y * this.size.nxtiles);
                float percentage = ((float)(x + y * this.size.nxtiles) + 1.0f) / (float)(this.size.nxtiles * this.size.nytiles);
                this.processImageProgress(percentage * 100.0f);
            }
        }
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return new J2KMetadata(imageType, param, this);
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageType == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        if (inData instanceof J2KMetadata) {
            return (IIOMetadata)((J2KMetadata)inData).clone();
        }
        try {
            J2KMetadata outData = new J2KMetadata();
            List<String> formats = Arrays.asList(inData.getMetadataFormatNames());
            String format = null;
            if (formats.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                format = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
            } else if (inData.isStandardMetadataFormatSupported()) {
                format = "javax_imageio_1.0";
            }
            if (format != null) {
                outData.setFromTree(format, inData.getAsTree(format));
                return outData;
            }
        }
        catch (IIOInvalidTreeException e) {
            return null;
        }
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public synchronized void abort() {
        super.abort();
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    private void checkSampleModel(SampleModel sm) {
        int type = sm.getDataType();
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter5"));
        }
        if (sm.getNumBands() > 16384) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter6"));
        }
    }

    private void writeMetadata(J2KMetadata metadata) throws IOException {
        if (metadata == null) {
            return;
        }
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        if (root == null) {
            return;
        }
        this.format = (J2KMetadataFormat)metadata.getMetadataFormat("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        this.writeSuperBox(root);
    }

    private void writeSuperBox(IIOMetadataNode node2) throws IOException {
        NodeList list = node2.getChildNodes();
        String name = node2.getNodeName();
        if (name.startsWith("JPEG2000")) {
            // empty if block
        }
        for (int i = 0; i < list.getLength(); ++i) {
            IIOMetadataNode child = (IIOMetadataNode)list.item(i);
            name = child.getNodeName();
            if (name.startsWith("JPEG2000") && this.format.isLeaf(name)) {
                this.writeBox(child);
                continue;
            }
            this.writeSuperBox(child);
        }
    }

    private void writeBox(IIOMetadataNode node2) throws IOException {
        com.sun.medialib.codec.jp2k.Box mlibBox = new com.sun.medialib.codec.jp2k.Box();
        mlibBox.type = Box.getTypeInt((String)Box.getAttribute(node2, "Type"));
        Box box = Box.createBox(mlibBox.type, node2);
        mlibBox.data = box.getContent();
        this.encoder.encodeBox(mlibBox);
    }

    private int computeLength(IIOMetadataNode root) {
        NodeList list = root.getChildNodes();
        int length = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            IIOMetadataNode node2 = (IIOMetadataNode)list.item(i);
            String name = node2.getNodeName();
            if (this.format.isLeaf(name)) {
                String s = (String)Box.getAttribute(node2, "Length");
                length += new Integer(s).intValue();
                continue;
            }
            length += this.computeLength(node2);
        }
        return length + (root.getNodeName().startsWith("JPEG2000") ? 8 : 0);
    }

    private int generateSuperBoxContent(IIOMetadataNode root, byte[] data, int pos) throws IOException {
        String name = root.getNodeName();
        if (name.startsWith("JPEG2000")) {
            int length = this.computeLength(root);
            Box.copyInt(data, pos, length);
            int type = Box.getTypeInt(Box.getTypeByName(name));
            Box.copyInt(data, pos += 4, type);
            pos += 4;
        }
        NodeList list = root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            IIOMetadataNode node2 = (IIOMetadataNode)list.item(i);
            name = node2.getNodeName();
            if (this.format.isLeaf(name)) {
                int type = Box.getTypeInt((String)Box.getAttribute(node2, "Type"));
                Box box = Box.createBox(type, node2);
                byte[] data1 = box.getContent();
                Box.copyInt(data, pos, data1.length + 8);
                Box.copyInt(data, pos += 4, type);
                System.arraycopy(data1, 0, data, pos += 4, data1.length);
                pos += data1.length;
                continue;
            }
            pos = this.generateSuperBoxContent(node2, data, pos);
        }
        return pos;
    }

    private Raster getTile(int tileX, int tileY) {
        int sx = this.tileXOffset + tileX * this.tileWidth;
        int sy = this.tileYOffset + tileY * this.tileHeight;
        Rectangle bounds = new Rectangle(sx, sy, this.tileWidth, this.tileHeight);
        if (this.writeRaster) {
            bounds = bounds.intersection(this.destinationRegion);
            if (this.noTransform) {
                return this.inputRaster.createChild(bounds.x, bounds.y, bounds.width, bounds.height, bounds.x, bounds.y, this.sourceBands);
            }
            sx = bounds.x;
            sy = bounds.y;
            WritableRaster ras = Raster.createWritableRaster(this.sampleModel, new Point(sx, sy));
            int x = this.mapToSourceX(sx);
            int y = this.mapToSourceY(sy);
            int minY = this.inputRaster.getMinY();
            int maxY = this.inputRaster.getMinY() + this.inputRaster.getHeight();
            int cTileWidth = bounds.width;
            int length = (cTileWidth - 1) * this.scaleX + 1;
            int j = 0;
            while (j < bounds.height) {
                if (y >= minY && y < maxY) {
                    Raster source = this.inputRaster.createChild(x, y, length, 1, x, y, null);
                    int tempX = sx;
                    int i = 0;
                    int offset = x;
                    while (i < cTileWidth) {
                        for (int k = 0; k < this.numComp; ++k) {
                            int p = source.getSample(offset, y, this.sourceBands[k]);
                            ras.setSample(tempX, sy, k, p);
                        }
                        ++i;
                        ++tempX;
                        offset += this.scaleX;
                    }
                }
                ++j;
                ++sy;
                y += this.scaleY;
            }
            return ras;
        }
        if (this.noTransform) {
            Raster ras = this.input.getTile(tileX, tileY);
            if (this.destinationRegion.contains(bounds) && this.noSubband) {
                return ras;
            }
            bounds = bounds.intersection(this.destinationRegion);
            return ras.createChild(bounds.x, bounds.y, bounds.width, bounds.height, bounds.x, bounds.y, this.sourceBands);
        }
        bounds = bounds.intersection(this.destinationRegion);
        sx = bounds.x;
        sy = bounds.y;
        WritableRaster ras = Raster.createWritableRaster(this.sampleModel, new Point(sx, sy));
        int x = this.mapToSourceX(sx);
        int y = this.mapToSourceY(sy);
        int minY = this.input.getMinY();
        int maxY = this.input.getMinY() + this.input.getHeight();
        int cTileWidth = bounds.width;
        int length = (cTileWidth - 1) * this.scaleX + 1;
        int j = 0;
        while (j < bounds.height) {
            if (y >= minY && y < maxY) {
                Raster source = this.input.getData(new Rectangle(x, y, length, 1));
                int tempX = sx;
                int i = 0;
                int offset = x;
                while (i < cTileWidth) {
                    for (int k = 0; k < this.numComp; ++k) {
                        int p = source.getSample(offset, y, this.sourceBands[k]);
                        ras.setSample(tempX, sy, k, p);
                    }
                    ++i;
                    ++tempX;
                    offset += this.scaleX;
                }
            }
            ++j;
            ++sy;
            y += this.scaleY;
        }
        return ras;
    }

    private int mapToSourceX(int x) {
        return x * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int y) {
        return y * this.scaleY + this.yOffset;
    }

    private int getMinTileX() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.x, this.tileXOffset, this.tileWidth);
    }

    private int getMaxTileX() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.x + this.destinationRegion.width - 1, this.tileXOffset, this.tileWidth);
    }

    private int getMinTileY() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.y, this.tileYOffset, this.tileHeight);
    }

    private int getMaxTileY() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.y + this.destinationRegion.height - 1, this.tileYOffset, this.tileHeight);
    }

    private static int ToTile(int pos, int tileOffset, int tileSize) {
        if ((pos -= tileOffset) < 0) {
            pos += 1 - tileSize;
        }
        return pos / tileSize;
    }

    private void setSize() {
        this.size = new Size();
        this.size.csize = this.numComp;
        this.size.nxtiles = this.getMaxTileX() - this.getMinTileX() + 1;
        this.size.nytiles = this.getMaxTileY() - this.getMinTileY() + 1;
        this.size.xosize = this.destinationRegion.x;
        this.size.yosize = this.destinationRegion.y;
        this.size.xsize = this.destinationRegion.width + this.destinationRegion.x;
        this.size.ysize = this.destinationRegion.height + this.destinationRegion.y;
        this.size.xtosize = this.tileXOffset;
        this.size.ytosize = this.tileYOffset;
        this.size.xtsize = this.tileWidth;
        this.size.ytsize = this.tileHeight;
        this.encoder.setSize(this.size);
    }

    private void setCompParameters(ColorModel colorModel, SampleModel sampleModel, ImageWriteParam compParamArg) {
        if (!(colorModel != null || sampleModel != null || compParamArg != null && compParamArg instanceof J2KImageWriteParam)) {
            return;
        }
        int[] bitDepths = null;
        boolean isSigned = false;
        if (colorModel != null) {
            bitDepths = colorModel.getComponentSize();
            isSigned = colorModel.getTransferType() == 2;
        } else if (sampleModel != null) {
            bitDepths = sampleModel.getSampleSize();
            isSigned = sampleModel.getDataType() == 2;
        }
        int numDecompositionLevels = -1;
        if (compParamArg != null) {
            numDecompositionLevels = ((J2KImageWriteParam)compParamArg).getNumDecompositionLevels();
        }
        if (bitDepths == null && numDecompositionLevels == -1) {
            return;
        }
        boolean bitDepthVaries = false;
        if (bitDepths != null) {
            for (int i = 1; i < bitDepths.length; ++i) {
                if (bitDepths[i] == bitDepths[0]) continue;
                bitDepthVaries = true;
                break;
            }
        }
        CompParams cp = this.encoder.getCompParams(null, -1);
        if (numDecompositionLevels != -1 && numDecompositionLevels != cp.maxlvls || bitDepths != null && ((isSigned ? 128 : 0) | bitDepths[0] - 1) != cp.depth) {
            if (numDecompositionLevels != -1) {
                cp.maxlvls = numDecompositionLevels;
            }
            if (bitDepths != null) {
                cp.depth = (isSigned ? 128 : 0) | bitDepths[0] - 1;
            }
            this.encoder.setCompParams(cp, -1);
        }
        if (bitDepthVaries) {
            for (int i = 0; i < this.numComp; ++i) {
                cp = this.encoder.getCompParams(null, i);
                if (numDecompositionLevels != -1) {
                    cp.maxlvls = numDecompositionLevels;
                }
                cp.depth = (isSigned ? 128 : 0) | bitDepths[i] - 1;
                this.encoder.setCompParams(cp, i);
            }
        }
    }

    private void setParameters(ImageWriteParam paramArg) {
        if (paramArg == null || !(paramArg instanceof J2KImageWriteParam)) {
            return;
        }
        J2KImageWriteParam param = (J2KImageWriteParam)paramArg;
        double rate = param.getEncodingRate();
        if (rate != Double.MAX_VALUE) {
            this.encoder.setRate(rate /= (double)ImageUtil.getElementSize(this.sampleModel), 0);
        } else {
            this.encoder.setRate(0.0, 0);
        }
        Params params = new Params();
        int n = params.enablemct = param.getComponentTransformation() ? 1 : 0;
        if (param.getEPH()) {
            params.cstyle |= 4;
        }
        if (param.getSOP()) {
            params.cstyle |= 2;
        }
        if ("w5x3".equals(param.getFilter())) {
            params.wavemode = 1;
        } else if ("w9x7".equals(param.getFilter())) {
            params.wavemode = 0;
        }
        String progressiveType = param.getProgressionType();
        if ("layer".equals(progressiveType)) {
            params.prgorder = 0;
        }
        if ("res".equals(progressiveType)) {
            params.prgorder = 1;
        }
        if ("res-pos".equals(progressiveType)) {
            params.prgorder = 2;
        }
        if ("pos-comp".equals(progressiveType)) {
            params.prgorder = 3;
        }
        if ("comp-pos".equals(progressiveType)) {
            params.prgorder = 4;
        }
        this.encoder.setParams(params);
    }
}

